/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientData;

public class RenderDataHandler {
    private static final Map<String, UpgradeClientDataType<?>> CLIENT_DATA_TYPES = Map.of(CookingUpgradeClientData.TYPE.getName(), CookingUpgradeClientData.TYPE, JukeboxUpgradeClientData.TYPE.getName(), JukeboxUpgradeClientData.TYPE);
    private final Consumer<RenderData> saveHandler;
    private final boolean showsCountsAndFillRatios;
    private Consumer<RenderDataHandler> displayItemsChangeListener = ri -> {};
    private RenderData renderData;

    public RenderDataHandler(RenderData renderData, Consumer<RenderData> saveHandler) {
        this(renderData, saveHandler, false);
    }

    public RenderDataHandler(RenderData renderData, Consumer<RenderData> saveHandler, boolean showsCountsAndFillRatios) {
        this.renderData = renderData;
        this.saveHandler = saveHandler;
        this.showsCountsAndFillRatios = showsCountsAndFillRatios;
    }

    public RenderData.DisplayData getDisplayData() {
        return this.renderData.display();
    }

    public void setUpgradeItems(List<ItemStack> upgradeItems) {
        this.renderData.setUpgradeItems(upgradeItems);
        this.save();
    }

    public <T extends IUpgradeClientData> void setUpgradeClientData(UpgradeClientDataType<T> upgradeClientDataType, T clientData) {
        this.renderData.putUpgradeData(upgradeClientDataType, clientData);
        this.save();
    }

    public <T extends IUpgradeClientData> Optional<T> getUpgradeClientData(UpgradeClientDataType<T> upgradeClientDataType) {
        if (!this.renderData.upgradeData().containsKey(upgradeClientDataType)) {
            return Optional.empty();
        }
        return upgradeClientDataType.cast(this.renderData.upgradeData().get(upgradeClientDataType));
    }

    public void refreshDisplayData(List<RenderData.DisplayItemData> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
        this.renderData.display().refreshData(displayItems, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        this.save();
        this.displayItemsChangeListener.accept(this);
    }

    public void refreshDisplayItemsAndInaccessibleSlots(List<RenderData.DisplayItemData> displayItems, List<Integer> inaccessibleSlots) {
        this.renderData.display().refreshDisplayItemsAndInaccessibleSlots(displayItems, inaccessibleSlots);
        this.save();
        this.displayItemsChangeListener.accept(this);
    }

    public void refreshSlotCountsFillRatiosAndInfiniteSlots(List<Integer> slotCounts, List<Float> slotFillRatios, List<Integer> infiniteSlots) {
        this.renderData.display().refreshSlotCountsFillRatiosAndInfiniteSlots(infiniteSlots, slotCounts, slotFillRatios);
        this.save();
    }

    public void setDisplayItemsChangeListener(Consumer<RenderDataHandler> displayItemsChangeListener) {
        this.displayItemsChangeListener = displayItemsChangeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.saveHandler.accept(this.renderData);
        if (triggerChangeListener) {
            this.displayItemsChangeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    public Map<UpgradeClientDataType<?>, IUpgradeClientData> getUpgradeClientData() {
        return this.renderData.upgradeData();
    }

    public void removeAllUpgradeClientData() {
        this.renderData.removeAllUpgradeData();
        this.save();
    }

    public void removeUpgradeClientData(UpgradeClientDataType<?> type) {
        this.renderData.removeUpgradeData(type);
        this.save();
    }

    public RenderData getData() {
        return this.renderData;
    }

    public void reloadFrom(RenderData renderData) {
        this.renderData = renderData;
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.renderData.clearTanks();
        this.renderData.clearBattery();
        this.save(triggerChangeListener);
    }

    public void setTankRenderData(TankPosition tankPosition, RenderData.TankRenderData data) {
        this.renderData.setTank(tankPosition, data);
        this.save();
    }

    public Map<TankPosition, RenderData.TankRenderData> getTankRenderData() {
        return this.renderData.tanks();
    }

    public Optional<RenderData.BatteryRenderData> getBatteryRenderData() {
        return this.renderData.battery();
    }

    public void setBatteryRenderData(RenderData.BatteryRenderData batteryRenderData) {
        this.renderData.setBattery(batteryRenderData);
        this.save();
    }

    public List<ItemStack> getUpgradeItems() {
        return this.renderData.upgradeItems();
    }

    public boolean showsCountsAndFillRatios() {
        return this.showsCountsAndFillRatios;
    }
}

