/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;

public abstract class MountedStorageSettingsContainerMenuBase
extends SettingsContainerMenu<IStorageWrapper> {
    private final int contraptionEntityId;
    private final BlockPos localPos;
    private ContainerContents.SettingsData lastSettingsData = null;

    public MountedStorageSettingsContainerMenuBase(MenuType<?> menuType, int windowId, Player player, IStorageWrapper storageWrapper, int contraptionEntityId, BlockPos localPos) {
        super(menuType, windowId, player, storageWrapper);
        this.contraptionEntityId = contraptionEntityId;
        this.localPos = localPos;
    }

    @Override
    public void detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide()) {
            this.storageWrapper.getContentsUuid().ifPresent(this::updateFromContents);
        }
    }

    protected abstract void updateFromContents(UUID var1);

    protected abstract CompoundTag getSettingsTag(CompoundTag var1);

    public int getContraptionEntityId() {
        return this.contraptionEntityId;
    }

    private void sendStorageSettingsToClient() {
        if (this.player.level().isClientSide()) {
            return;
        }
        if (this.lastSettingsData == null || !this.lastSettingsData.equals(this.storageWrapper.getSettingsHandler().getSettingsData())) {
            this.lastSettingsData = this.storageWrapper.getSettingsHandler().getSettingsData().copy();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                ContainerContents.SettingsData settingsData = this.storageWrapper.getSettingsHandler().getSettingsData();
                Player patt0$temp = this.player;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)this.instantiateSettingsPayload((UUID)uuid, settingsData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }

    protected abstract CustomPacketPayload instantiateSettingsPayload(UUID var1, ContainerContents.SettingsData var2);

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        this.sendStorageSettingsToClient();
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.localPos;
    }
}

