/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.Contraption;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public abstract class MountedStorageBase
extends MountedItemStorage
implements SyncedMountedStorage {
    private ItemStack storageStack;

    public MountedStorageBase(MountedItemStorageType<?> type, ItemStack storageStack) {
        super(type);
        this.storageStack = storageStack;
    }

    public ItemStack getStorageStack() {
        return this.storageStack;
    }

    public void setStorageStack(ItemStack stack) {
        this.storageStack = stack;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        this.updateWithSyncedStorageStack(this.storageStack, true);
    }

    public void markClean() {
    }

    public boolean isDirty() {
        return false;
    }

    public abstract void updateWithSyncedStorageStack(ItemStack var1, boolean var2);

    public abstract IStorageWrapper getStorageWrapper();

    protected ResourceHandler<ItemResource> getExternalItemHandler() {
        return this.getStorageWrapper().getInventoryForInputOutput();
    }

    public void setStackInSlot(int i, ItemStack itemStack) {
        InventoryHelper.set(this.getExternalItemHandler(), i, ItemResource.of((ItemStack)itemStack), itemStack.getCount());
    }

    public int getSlots() {
        return this.getExternalItemHandler().size();
    }

    public ItemStack getStackInSlot(int i) {
        return ((ItemResource)this.getExternalItemHandler().getResource(i)).toStack(this.getExternalItemHandler().getAmountAsInt(i));
    }

    public ItemStack insertItem(int i, ItemStack itemStack, boolean b) {
        int moved;
        try (Transaction tx = Transaction.openRoot();){
            moved = this.getExternalItemHandler().insert(i, (Resource)ItemResource.of((ItemStack)itemStack), itemStack.getCount(), (TransactionContext)tx);
            if (!b) {
                tx.commit();
            }
        }
        return moved == itemStack.getCount() ? ItemStack.EMPTY : itemStack.copyWithCount(itemStack.getCount() - moved);
    }

    public ItemStack extractItem(int index, int amount, boolean simulate) {
        int extracted;
        ItemResource resource = (ItemResource)this.getExternalItemHandler().getResource(index);
        try (Transaction tx = Transaction.openRoot();){
            extracted = this.getExternalItemHandler().extract(index, (Resource)resource, amount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
        }
        return resource.toStack(extracted);
    }

    public int getSlotLimit(int i) {
        return this.getExternalItemHandler().getCapacityAsInt(i, (Resource)ItemResource.EMPTY);
    }

    public boolean isItemValid(int i, ItemStack itemStack) {
        return this.getExternalItemHandler().isValid(i, (Resource)ItemResource.of((ItemStack)itemStack));
    }

    public void onClose(Player player, Vec3 pos) {
    }

    protected void onOpen(ServerLevel level, Vec3 pos) {
    }
}

