/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.accessories;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.EmptyResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class AccessoriesCompat
implements ICompat {
    @Override
    public void setup() {
        InventoryHelper.registerPlayerInventoryProvider(player -> AccessoriesCapability.getOptionally((LivingEntity)player).map(cap -> new AccessoriesHandler((Player)player, (AccessoriesCapability)cap)).orElse((ResourceHandler)EmptyResourceHandler.instance()));
        InventoryHelper.registerEquipmentInventoryProvider(player -> AccessoriesCapability.getOptionally((LivingEntity)player).map(cap -> new AccessoriesHandler((Player)player, (AccessoriesCapability)cap)).orElse((ResourceHandler)EmptyResourceHandler.instance()));
    }

    private static class AccessoriesHandler
    implements ResourceHandler<ItemResource> {
        private final AccessoriesCapability cap;
        private final Player player;
        private Map<SlotType, Integer> identifierBaseIndexes = new LinkedHashMap<SlotType, Integer>();
        private final int totalSize;

        public AccessoriesHandler(Player player, AccessoriesCapability cap) {
            this.cap = cap;
            this.player = player;
            AtomicInteger totalSlots = new AtomicInteger(0);
            cap.getContainers().forEach((identifier, container) -> {
                this.identifierBaseIndexes.put(container.slotType(), totalSlots.get());
                totalSlots.addAndGet(container.getSize());
            });
            this.totalSize = totalSlots.get();
        }

        public int size() {
            return this.totalSize;
        }

        public ItemResource getResource(int i) {
            if (this.totalSize <= i) {
                return ItemResource.EMPTY;
            }
            return ItemResource.of((ItemStack)this.getContainer(i).getAccessories().getItem(this.getLocalIndex(i)));
        }

        private AccessoriesContainer getContainer(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return container;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        private int getLocalIndex(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return slot - baseIndex;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        private SlotType getSlotType(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return slotType;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        public long getAmountAsLong(int i) {
            if (this.totalSize <= i) {
                return 0L;
            }
            return this.getContainer(i).getAccessories().getItem(this.getLocalIndex(i)).getCount();
        }

        public long getCapacityAsLong(int i, ItemResource resource) {
            if (this.totalSize <= i) {
                return 0L;
            }
            return this.getContainer(i).getAccessories().getMaxStackSize(resource.toStack());
        }

        public boolean isValid(int i, ItemResource resource) {
            if (this.totalSize <= i) {
                return false;
            }
            return this.getContainer(i).getAccessories().canPlaceItem(this.getLocalIndex(i), resource.toStack());
        }

        public int insert(int i, ItemResource resource, int amount, TransactionContext transactionContext) {
            if (this.totalSize <= i) {
                return 0;
            }
            int localIndex = this.getLocalIndex(i);
            SlotReference slotReference = SlotReference.of((LivingEntity)this.player, (String)this.getSlotType(i).name(), (int)localIndex);
            ItemStack currentStack = slotReference.getStack();
            if (currentStack != null && !currentStack.isEmpty() && !resource.matches(currentStack)) {
                return 0;
            }
            int currentCount = currentStack != null ? currentStack.getCount() : 0;
            ItemStack resourceStack = resource.toStack();
            int countToInsert = Math.min(amount, this.getContainer(i).getAccessories().getMaxStackSize(resourceStack) - currentCount);
            if (countToInsert <= 0 || !this.getContainer(i).getAccessories().canPlaceItem(localIndex, resourceStack)) {
                return 0;
            }
            new SlotReferenceJournal(slotReference).updateSnapshots(transactionContext);
            slotReference.setStack(resource.toStack(countToInsert + currentCount));
            return countToInsert;
        }

        public int extract(int i, ItemResource resource, int amount, TransactionContext transactionContext) {
            if (this.totalSize <= i) {
                return 0;
            }
            int localIndex = this.getLocalIndex(i);
            SlotReference slotReference = SlotReference.of((LivingEntity)this.player, (String)this.getSlotType(i).name(), (int)localIndex);
            ItemStack currentStack = slotReference.getStack();
            if (currentStack == null || currentStack.isEmpty() || !resource.matches(currentStack)) {
                return 0;
            }
            int countToExtract = Math.min(amount, currentStack.getCount());
            new SlotReferenceJournal(slotReference).updateSnapshots(transactionContext);
            if (currentStack.getCount() == countToExtract) {
                slotReference.setStack(ItemStack.EMPTY);
            } else {
                slotReference.setStack(currentStack.copyWithCount(currentStack.getCount() - countToExtract));
            }
            return countToExtract;
        }

        private static class SlotReferenceJournal
        extends SnapshotJournal<ItemStack> {
            private final SlotReference slotReference;

            public SlotReferenceJournal(SlotReference slotReference) {
                this.slotReference = slotReference;
            }

            protected ItemStack createSnapshot() {
                ItemStack stack = this.slotReference.getStack();
                return stack != null ? stack.copy() : ItemStack.EMPTY;
            }

            protected void revertToSnapshot(ItemStack stack) {
                this.slotReference.setStack(stack);
            }
        }
    }
}

