/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;

public class StorageInventorySlot
extends SlotSuppliedHandler {
    private final IStorageWrapper storageWrapper;
    private final int slotIndex;
    private final Player player;

    public StorageInventorySlot(IStorageWrapper storageWrapper, int slotIndex, Player player) {
        super(storageWrapper::getInventoryHandler, slotIndex, 0, 0);
        this.storageWrapper = storageWrapper;
        this.slotIndex = slotIndex;
        this.player = player;
    }

    @Override
    public void set(ItemStack stack) {
        super.set(stack);
        if (!this.player.level().isClientSide()) {
            StorageInventorySlot.processSlotChangeResponse(this.slotIndex, this.storageWrapper.getInventoryHandler(), this.storageWrapper);
        }
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return this.storageWrapper.getInventoryHandler().isItemValid(this.slotIndex, stack, this.player);
    }

    private static void processSlotChangeResponse(int slot, InventoryHandler handler, IStorageWrapper storageWrapper) {
        storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(ISlotChangeResponseUpgrade.class).forEach(u -> u.onSlotChange(handler, slot));
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.storageWrapper.getInventoryHandler().getCapacityAsInt(this.slotIndex, (Resource)ItemResource.of((ItemStack)stack));
    }

    public ItemStack safeInsert(ItemStack stack, int maxCount) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            ItemStack itemstack = this.getItem();
            int i = Math.min(Math.min(maxCount, stack.getCount()), this.getMaxStackSize(stack) - itemstack.getCount());
            if (itemstack.isEmpty()) {
                this.set(stack.split(i));
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) {
                stack.shrink(i);
                ItemStack copy = itemstack.copy();
                copy.grow(i);
                this.set(copy);
            }
            return stack;
        }
        return stack;
    }
}

