/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotStackAccessor;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import org.jetbrains.annotations.Nullable;

public class SlotSuppliedHandler
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    @Nullable
    private ItemStack cachedReturnedStack = null;
    @Nullable
    private ItemStack lastHandlerStack = null;
    private final Supplier<ResourceHandler<ItemResource>> itemHandlerSupplier;
    public final int slot;

    public SlotSuppliedHandler(Supplier<ResourceHandler<ItemResource>> itemHandlerSupplier, int slot, int xPosition, int yPosition) {
        super(emptyInventory, 0, xPosition, yPosition);
        this.itemHandlerSupplier = itemHandlerSupplier;
        this.slot = slot;
    }

    public ResourceHandler<ItemResource> getResourceHandler() {
        return this.itemHandlerSupplier.get();
    }

    public void onQuickCraft(ItemStack oldStackIn, ItemStack newStackIn) {
    }

    public boolean mayPlace(ItemStack stack) {
        return this.itemHandlerSupplier.get().isValid(this.slot, (Resource)ItemResource.of((ItemStack)stack));
    }

    public ItemStack getItem() {
        ItemStack handlerStack = this.getHandlerStack();
        if (this.cachedReturnedStack == null || this.lastHandlerStack == null || !ItemStack.matches((ItemStack)this.lastHandlerStack, (ItemStack)handlerStack)) {
            this.cachedReturnedStack = handlerStack.copy();
            this.lastHandlerStack = handlerStack;
        }
        return this.cachedReturnedStack;
    }

    private ItemStack getHandlerStack() {
        return ((ItemResource)this.itemHandlerSupplier.get().getResource(this.slot)).toStack(this.itemHandlerSupplier.get().getAmountAsInt(this.slot));
    }

    public void set(ItemStack stack) {
        ResourceHandler<ItemResource> resourceHandler = this.itemHandlerSupplier.get();
        if (resourceHandler instanceof ISlotStackAccessor) {
            ISlotStackAccessor slotStackAccessor = (ISlotStackAccessor)resourceHandler;
            slotStackAccessor.setStackInSlot(this.slot, stack);
        } else {
            resourceHandler = this.itemHandlerSupplier.get();
            if (resourceHandler instanceof IndexModifier) {
                IndexModifier indexModifier = (IndexModifier)resourceHandler;
                indexModifier.set(this.slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
            } else {
                InventoryHelper.set(this.itemHandlerSupplier.get(), this.slot, ItemResource.of((ItemStack)stack), stack.getCount());
            }
        }
        this.cachedReturnedStack = stack;
    }

    public void setChanged() {
        if (this.cachedReturnedStack != null && !ItemStack.matches((ItemStack)this.cachedReturnedStack, (ItemStack)this.getHandlerStack())) {
            this.set(this.cachedReturnedStack);
        }
    }

    public ItemStack remove(int amount) {
        ItemStack stack = this.getHandlerStack().copy();
        ItemStack ret = stack.split(amount);
        this.set(stack);
        this.cachedReturnedStack = null;
        return ret;
    }

    public int getMaxStackSize() {
        return this.itemHandlerSupplier.get().getCapacityAsInt(this.slot, (Resource)ItemResource.EMPTY);
    }

    public boolean mayPickup(Player player) {
        ItemResource resource = (ItemResource)this.itemHandlerSupplier.get().getResource(this.slot);
        if (resource.isEmpty()) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            boolean bl = this.itemHandlerSupplier.get().extract(this.slot, (Resource)resource, 1, (TransactionContext)tx) == 1;
            return bl;
        }
    }

    public int getSlotIndex() {
        return this.slot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(Slot other) {
        if (!(other instanceof SlotSuppliedHandler)) return false;
        SlotSuppliedHandler rhs = (SlotSuppliedHandler)other;
        if (rhs.itemHandlerSupplier.get() != this.itemHandlerSupplier.get()) return false;
        return true;
    }
}

