/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.api;

import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public interface IStorageFluidHandler
extends ResourceHandler<FluidResource> {
    default public int insert(TagKey<Fluid> fluidTag, int amount, Fluid fallbackFluid, TransactionContext tx) {
        return this.insert(fluidTag, amount, fallbackFluid, tx, false);
    }

    default public int insert(TagKey<Fluid> fluidTag, int amount, Fluid fallbackFluid, TransactionContext tx, boolean ignoreInOutLimit) {
        for (int index = 0; index < this.size(); ++index) {
            FluidResource resource = (FluidResource)this.getResource(index);
            if (!resource.is(fluidTag)) continue;
            return this.insert(index, FluidResource.of((Fluid)resource.getFluid()), amount, tx, ignoreInOutLimit);
        }
        return this.insert(FluidResource.of((Fluid)fallbackFluid), amount, tx, ignoreInOutLimit);
    }

    default public int insert(FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int inserted = 0;
        for (int index = 0; index < this.size(); ++index) {
            if ((inserted += this.insert(index, resource, amount - inserted, tx, ignoreInOutLimit)) < amount) continue;
            return inserted;
        }
        return inserted;
    }

    public int insert(int var1, FluidResource var2, int var3, TransactionContext var4, boolean var5);

    default public int insert(int index, FluidResource resource, int amount, TransactionContext tx) {
        return this.insert(index, resource, amount, tx, false);
    }

    default public int extract(int index, TagKey<Fluid> resourceTag, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        FluidResource resource = (FluidResource)this.getResource(index);
        if (resource.is(resourceTag)) {
            return this.extract(index, resource, amount, tx, ignoreInOutLimit);
        }
        return 0;
    }

    default public int extract(TagKey<Fluid> resourceTag, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int extracted = 0;
        for (int index = 0; index < this.size(); ++index) {
            if ((extracted += this.extract(index, resourceTag, amount - extracted, tx, ignoreInOutLimit)) < amount) continue;
            return extracted;
        }
        return extracted;
    }

    public int extract(int var1, FluidResource var2, int var3, TransactionContext var4, boolean var5);

    default public int extract(int index, FluidResource resource, int amount, TransactionContext tx) {
        return this.extract(index, resource, amount, tx, false);
    }
}

