/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.networking.server.whitelist;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yourdailymodder.weaponmaster.setup.configs.ConfigHolder;
import yourdailymodder.weaponmaster.setup.helper.ModUtils;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.client.whitelist.WhitelistCPacket;
import yourdailymodder.weaponmaster.setup.networking.server.whitelist.WhitelistSPacket;
import yourdailymodder.weaponmaster.setup.playerdata.IPlayerData;
import yourdailymodder.weaponmaster.setup.playerdata.PlayerData;

public class ServerPayloadHandler {
    public static void handleData(WhitelistSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(WhitelistSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            data.whitelist = ModUtils.stringExist(packetdata.value()) ? packetdata.value() : "empty";
            if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_WHITELIST.get()).booleanValue() && ModUtils.stringExist((String)ConfigHolder.COMMON.whitelist.get())) {
                data.whitelist = (String)ConfigHolder.COMMON.whitelist.get();
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new WhitelistCPacket(data.whitelist, false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

