/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.setup.networking.server.getserverconfigsettigns;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yourdailymodder.weaponmaster.setup.configs.ConfigHolder;
import yourdailymodder.weaponmaster.setup.helper.ModUtils;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.client.blacklist.BlacklistCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.positions.PositionsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.rotations.RotationsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.scale.ScaleCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.slotattachment.SlotAttachmentCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.slotmover.SlotMoverCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.toggle.ToggleCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.uniqueitemsettings.UniqueItemSettingsCPacket;
import yourdailymodder.weaponmaster.setup.networking.client.whitelist.WhitelistCPacket;
import yourdailymodder.weaponmaster.setup.networking.server.getserverconfigsettigns.GetServerConfigSettingsSPacket;
import yourdailymodder.weaponmaster.setup.playerdata.IPlayerData;
import yourdailymodder.weaponmaster.setup.playerdata.PlayerData;

public class ServerPayloadHandler {
    public static void handleData(GetServerConfigSettingsSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(GetServerConfigSettingsSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            int i;
            if (ConfigHolder.COMMON.positions != null) {
                for (i = 0; i < ConfigHolder.COMMON.positions.length; ++i) {
                    data.positions[i] = (Integer)ConfigHolder.COMMON.positions[i].get();
                }
            }
            if (ConfigHolder.COMMON.rotations != null) {
                for (i = 0; i < ConfigHolder.COMMON.rotations.length; ++i) {
                    data.rotations[i] = (Integer)ConfigHolder.COMMON.rotations[i].get();
                }
            }
            if (ConfigHolder.COMMON.scale != null) {
                for (i = 0; i < ConfigHolder.COMMON.scale.length; ++i) {
                    data.scale[i] = (Integer)ConfigHolder.COMMON.scale[i].get();
                }
            }
            if (ConfigHolder.COMMON.TOGGLE_SLOT_MODEL != null) {
                for (i = 0; i < ConfigHolder.COMMON.TOGGLE_SLOT_MODEL.length; ++i) {
                    data.toggleSlots[i] = (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[i].get() != false ? 1 : 0;
                }
            }
            if (ModUtils.stringExist((String)ConfigHolder.COMMON.slot_attachment.get())) {
                data.slotAttachments = (String)ConfigHolder.COMMON.slot_attachment.get();
            }
            if (ModUtils.stringExist((String)ConfigHolder.COMMON.slotMover.get())) {
                data.mover = (String)ConfigHolder.COMMON.slotMover.get();
            }
            if (ModUtils.stringExist((String)ConfigHolder.COMMON.blacklist.get())) {
                data.blacklist = (String)ConfigHolder.COMMON.blacklist.get();
            }
            if (ModUtils.stringExist((String)ConfigHolder.COMMON.whitelist.get())) {
                data.whitelist = (String)ConfigHolder.COMMON.whitelist.get();
            }
            if (ModUtils.stringExist((String)ConfigHolder.COMMON.uniqueItemDisplay.get())) {
                data.uniqueItemDisplay = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
            }
            for (Player sp : sender.level().players()) {
                if (!(sp.distanceToSqr((Entity)sender) < 4000.0)) continue;
                Networking.sendToClient(new PositionsCPacket(ModUtils.intToString(data.positions), true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new RotationsCPacket(ModUtils.intToString(data.rotations), true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new ScaleCPacket(ModUtils.intToByte(data.scale), true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new ToggleCPacket(ModUtils.intToByte(data.toggleSlots), true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new SlotAttachmentCPacket(data.slotAttachments, true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new SlotMoverCPacket(data.mover, true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new BlacklistCPacket(data.blacklist, true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new WhitelistCPacket(data.whitelist, true, sender.getStringUUID()), (ServerPlayer)sp);
                Networking.sendToClient(new UniqueItemSettingsCPacket(data.uniqueItemDisplay, true, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

