/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import yourdailymodder.weaponmaster.WeaponMasterMod;
import yourdailymodder.weaponmaster.gui.DetailedSettingsScreen;
import yourdailymodder.weaponmaster.gui.WeaponMasterScreen;
import yourdailymodder.weaponmaster.gui.normalbutton.Button;
import yourdailymodder.weaponmaster.setup.KeyHandler;
import yourdailymodder.weaponmaster.setup.configs.ConfigHolder;
import yourdailymodder.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import yourdailymodder.weaponmaster.setup.helper.FastColor;
import yourdailymodder.weaponmaster.setup.helper.KeyHelper;
import yourdailymodder.weaponmaster.setup.helper.ModUtils;
import yourdailymodder.weaponmaster.setup.networking.Networking;
import yourdailymodder.weaponmaster.setup.networking.server.blacklist.BlacklistSPacket;
import yourdailymodder.weaponmaster.setup.networking.server.whitelist.WhitelistSPacket;

public class EditTextListScreen
extends Screen {
    public static int textType;
    public String text = "empty";
    public String textFromConfig = "empty";
    public boolean textFocused = false;
    public boolean selectText = false;
    private boolean draggingPlayerMode;
    public int hoverValue = 0;
    public boolean shiftDown = false;

    public EditTextListScreen(int i) {
        super((Component)Component.translatable((String)"weaponmaster_ydm.screen3"));
        textType = i;
        if (textType == 0) {
            this.textFromConfig = (String)ConfigHolder.COMMON.whitelist.get();
        } else if (textType == 1) {
            this.textFromConfig = (String)ConfigHolder.COMMON.blacklist.get();
        }
    }

    protected void init() {
        this.addRenderableWidget(new Button(this.width / 2 - 5 - this.font.width((FormattedText)Component.translatable((String)"weaponmaster_ydm.screen.addtext")) / 2, 50, 10 + this.font.width((FormattedText)Component.translatable((String)"weaponmaster_ydm.screen.addtext")), 20, (Component)Component.translatable((String)"weaponmaster_ydm.screen.addtext"), p_96337_ -> this.addText()));
        super.init();
    }

    public void saveAllData() {
        if (WeaponMasterMod.isMultiplayer) {
            if (textType == 0) {
                Networking.sendToServer(new WhitelistSPacket(ClientOnlyForgeSetup.whitelist));
            } else {
                Networking.sendToServer(new BlacklistSPacket(ClientOnlyForgeSetup.blacklist));
            }
        }
    }

    public void addText() {
        if (ModUtils.stringExist(this.text) && !ModUtils.stringEquals(this.text, "empty")) {
            try {
                if (textType == 0) {
                    ClientOnlyForgeSetup.whitelist = ClientOnlyForgeSetup.whitelist + "," + this.text;
                    this.textFromConfig = ClientOnlyForgeSetup.whitelist;
                } else if (textType == 1) {
                    ClientOnlyForgeSetup.blacklist = ClientOnlyForgeSetup.blacklist + "," + this.text;
                    this.textFromConfig = ClientOnlyForgeSetup.blacklist;
                }
                this.text = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setClipboard(String p_95157_) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            minecraft.keyboardHandler.setClipboard(p_95157_);
        }
    }

    public static String getClipboard() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            return ChatFormatting.stripFormatting((String)minecraft.keyboardHandler.getClipboard().replaceAll("\\r", ""));
        }
        return "";
    }

    public boolean charTyped(CharacterEvent e) {
        char p_94683_ = (char)e.codepoint();
        int p_94684_ = e.modifiers();
        if (StringUtil.isAllowedChatCharacter((int)p_94683_) && this.textFocused) {
            this.text = this.text + p_94683_;
            this.text = StringUtil.filterText((String)this.text).toLowerCase();
            if (ModUtils.stringContains(this.text, ",")) {
                this.text = this.text.replace(",", "");
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return super.charTyped(e);
    }

    public boolean keyPressed(KeyEvent e) {
        Minecraft minecraft = Minecraft.getInstance();
        int p_96552_ = e.key();
        int p_96553_ = e.scancode();
        int p_96554_ = e.modifiers();
        if (p_96552_ == 257 && this.textFocused && ModUtils.stringExist(this.text)) {
            this.addText();
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else if (KeyHelper.isSelectAll(p_96552_) && ModUtils.stringExist(this.text)) {
            this.selectText = true;
        } else if (KeyHelper.isCopy(p_96552_) && ModUtils.stringExist(this.text) && this.selectText) {
            EditTextListScreen.setClipboard(this.text);
        } else if (KeyHelper.isCut(p_96552_) && ModUtils.stringExist(this.text)) {
            EditTextListScreen.setClipboard(this.text);
            this.text = "";
        } else if (KeyHelper.isPaste(p_96552_)) {
            this.text = this.selectText ? EditTextListScreen.getClipboard() : this.text + EditTextListScreen.getClipboard();
        } else {
            if (this.selectText && ModUtils.stringExist(this.text)) {
                this.text = "";
            }
            if (ModUtils.stringExist(this.text) && this.textFocused) {
                if (p_96552_ == 259 || p_96552_ == 261) {
                    this.text = this.selectText ? "" : this.text.substring(0, this.text.length() - 1);
                    minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
            } else if (p_96552_ == KeyHandler.OPEN_SCREEN.getKey().getValue() && !this.textFocused) {
                this.onClose();
                return true;
            }
            this.selectText = false;
        }
        return super.keyPressed(e);
    }

    public void render(GuiGraphics p_281549_, int p_281550_, int p_282878_, float p_282465_) {
        p_281549_.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        MutableComponent type = Component.translatable((String)"weaponmaster_ydm.screen.blacklist");
        if (textType == 0) {
            type = Component.translatable((String)"weaponmaster_ydm.screen.whitelist");
        }
        p_281549_.drawString(this.font, (Component)type, this.width / 2 - this.font.width((FormattedText)type) / 2, 10, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), false);
        type = Component.literal((String)this.text);
        int posx = this.width / 2 - 5 - this.font.width((FormattedText)type) / 2;
        int posy = 25;
        if (this.selectText) {
            p_281549_.fillGradient(posx + 5, posy, posx + this.font.width((FormattedText)type) + 5, posy + 20, -1072689136, -804253680);
        }
        p_281549_.fillGradient(posx, posy, posx + this.font.width((FormattedText)type) + 10, posy + 20, -1072689136 * (this.textFocused ? -1 : 1), -804253680 * (this.textFocused ? -1 : 1));
        p_281549_.drawString(this.font, (Component)type, this.width / 2 - this.font.width((FormattedText)type) / 2, posy + 5, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), false);
        if (ModUtils.stringContains(this.textFromConfig, ",")) {
            String[] txtArray = this.textFromConfig.split(",");
            int line = 0;
            int maxposy = this.height / 20;
            for (int i = this.hoverValue; i < txtArray.length && i + 1 <= maxposy * 2 + 1 + this.hoverValue; ++i) {
                if (ModUtils.stringEquals(txtArray[i], "empty")) continue;
                posx = line + 1 > maxposy ? this.width - this.font.width((FormattedText)Component.literal((String)txtArray[i])) - 5 : 5;
                posy = line * 20 + 5 - (line + 1 > maxposy ? maxposy * 20 : 0);
                p_281549_.fill(posx - 3, posy - 4, 3 + posx + this.font.width((FormattedText)Component.literal((String)txtArray[i])), posy + 12, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.fill(posx - 4, posy - 3, 4 + posx + this.font.width((FormattedText)Component.literal((String)txtArray[i])), posy + 11, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.fill(posx - 3, posy - 3, 3 + posx + this.font.width((FormattedText)Component.literal((String)txtArray[i])), posy + 11, FastColor.ARGB32.color(255, 37, 2, 93));
                p_281549_.fill(posx - 2, posy - 2, 2 + posx + this.font.width((FormattedText)Component.literal((String)txtArray[i])), posy + 10, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.drawString(this.font, txtArray[i], posx, posy, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), false);
                ++line;
            }
            if (txtArray.length > maxposy * 2) {
                String s = Component.translatable((String)"weaponmaster_ydm.screen.shiftscroll").getString();
                int tempx = this.width / 2 - this.font.width(s) / 2;
                int tempy = this.height - 11;
                p_281549_.fill(tempx - 3, tempy - 4, 3 + tempx + this.font.width((FormattedText)Component.literal((String)s)), tempy + 12, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.drawString(this.font, s, tempx, tempy, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), false);
            }
        } else if (ModUtils.stringExist(this.textFromConfig)) {
            posx = 5;
            posy = 5;
            if (!ModUtils.stringEquals(this.textFromConfig, "empty")) {
                p_281549_.fill(posx - 3, posy - 4, 3 + posx + this.font.width((FormattedText)Component.literal((String)this.textFromConfig)), posy + 12, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.fill(posx - 4, posy - 3, 4 + posx + this.font.width((FormattedText)Component.literal((String)this.textFromConfig)), posy + 11, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.fill(posx - 3, posy - 3, 3 + posx + this.font.width((FormattedText)Component.literal((String)this.textFromConfig)), posy + 11, FastColor.ARGB32.color(255, 37, 2, 93));
                p_281549_.fill(posx - 2, posy - 2, 2 + posx + this.font.width((FormattedText)Component.literal((String)this.textFromConfig)), posy + 10, FastColor.ARGB32.color(255, 18, 3, 19));
                p_281549_.drawString(this.font, this.textFromConfig, posx, posy, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), false);
            }
        }
        super.render(p_281549_, p_281550_, p_282878_, p_282465_);
        WeaponMasterScreen.renderEntityInInventory(p_281549_, this.width / 2 - 90, this.height / 2 - 75, 60 + DetailedSettingsScreen.scale, 0.0f, 0.0f, (LivingEntity)Minecraft.getInstance().player);
    }

    public void renderBackground(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    public void onClose() {
        if (textType == 0) {
            if (ModUtils.stringExist(ClientOnlyForgeSetup.whitelist)) {
                ConfigHolder.COMMON.whitelist.set((Object)ClientOnlyForgeSetup.whitelist);
            } else {
                ClientOnlyForgeSetup.whitelist = "empty";
                ConfigHolder.COMMON.whitelist.set((Object)"empty");
            }
            ConfigHolder.COMMON.whitelist.save();
        } else if (textType == 1) {
            if (ModUtils.stringExist(ClientOnlyForgeSetup.blacklist)) {
                ConfigHolder.COMMON.blacklist.set((Object)ClientOnlyForgeSetup.blacklist);
            } else {
                ClientOnlyForgeSetup.blacklist = "empty";
                ConfigHolder.COMMON.blacklist.set((Object)"empty");
            }
            ConfigHolder.COMMON.blacklist.save();
        }
        this.saveAllData();
        Minecraft.getInstance().setScreen((Screen)new DetailedSettingsScreen(DetailedSettingsScreen.selectedScreen));
    }

    public boolean isMouseOverArea(double mouseX, double mouseY, int posX, int posY, int sizeX, int sizeY) {
        return mouseX >= (double)posX && mouseX < (double)(posX + sizeX) && mouseY >= (double)posY && mouseY < (double)(posY + sizeY);
    }

    public boolean mouseClicked(MouseButtonEvent e, boolean bl) {
        int tempposy;
        int tempposx;
        double p_94695_ = e.x();
        double p_94696_ = e.y();
        int p_94697_ = e.button();
        MutableComponent type = Component.literal((String)this.text);
        int posx = this.width / 2 - 5 - this.font.width((FormattedText)type) / 2;
        int posy = 25;
        if (ModUtils.stringContains(this.textFromConfig, ",")) {
            String[] txtArray = this.textFromConfig.split(",");
            int line = 0;
            int maxposy = this.height / 20;
            for (int i = this.hoverValue; i < txtArray.length && i + 1 <= maxposy * 2 + 1 + this.hoverValue; ++i) {
                if (ModUtils.stringEquals(txtArray[i], "empty")) continue;
                int tempposx2 = line + 1 > maxposy ? this.width - this.font.width((FormattedText)Component.literal((String)txtArray[i])) - 8 : 1;
                int tempposy2 = line * 20 + 1 - (line + 1 > maxposy ? maxposy * 20 : 0);
                if (!ModUtils.stringEquals(txtArray[i], "empty") && !ModUtils.stringEquals(this.textFromConfig, "empty") && this.isMouseOverArea(p_94695_, p_94696_, tempposx2, tempposy2, this.font.width(txtArray[i]) + 8, 17)) {
                    Object newtxt = "";
                    for (int j = 0; j < txtArray.length; ++j) {
                        String txt = txtArray[j];
                        if (!ModUtils.stringExist((String)newtxt)) {
                            if (ModUtils.stringEquals(txt, txtArray[i]) || !ModUtils.stringExist(txt)) continue;
                            newtxt = (String)newtxt + txt;
                            continue;
                        }
                        if (ModUtils.stringEquals(txt, txtArray[i]) || !ModUtils.stringExist(txt)) continue;
                        newtxt = (String)newtxt + "," + txt;
                    }
                    try {
                        if (textType == 0) {
                            ClientOnlyForgeSetup.whitelist = newtxt;
                            this.textFromConfig = newtxt;
                        } else if (textType == 1) {
                            ClientOnlyForgeSetup.blacklist = newtxt;
                            this.textFromConfig = newtxt;
                        }
                        this.saveAllData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
                ++line;
            }
        } else if (ModUtils.stringExist(this.textFromConfig) && this.isMouseOverArea(p_94695_, p_94696_, tempposx = 1, tempposy = 1, this.font.width(this.textFromConfig) + 8, 17) && !ModUtils.stringEquals(this.textFromConfig, "empty")) {
            try {
                if (textType == 0) {
                    this.textFromConfig = ClientOnlyForgeSetup.whitelist = ClientOnlyForgeSetup.whitelist.replace(this.textFromConfig, "empty");
                } else if (textType == 1) {
                    this.textFromConfig = ClientOnlyForgeSetup.blacklist = ClientOnlyForgeSetup.blacklist.replace(this.textFromConfig, "empty");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        if (this.isMouseOverArea(p_94695_, p_94696_, posx, posy, this.font.width((FormattedText)type) + 10, 20)) {
            this.textFocused = true;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else {
            this.textFocused = false;
            this.selectText = false;
        }
        if (this.isMouseOverArea(p_94695_, p_94696_, 0, 0, this.width, this.height)) {
            this.draggingPlayerMode = true;
            ClientOnlyForgeSetup.xPos = (int)Math.floor(p_94695_);
            ClientOnlyForgeSetup.yPos = (int)Math.floor(p_94696_);
            ClientOnlyForgeSetup.fakexRot = ClientOnlyForgeSetup.xRot;
            ClientOnlyForgeSetup.fakeyRot = ClientOnlyForgeSetup.yRot;
        }
        return super.mouseClicked(e, bl);
    }

    public boolean mouseReleased(MouseButtonEvent e) {
        if (this.draggingPlayerMode) {
            this.draggingPlayerMode = false;
        }
        if (this.shiftDown) {
            this.shiftDown = false;
        }
        return super.mouseReleased(e);
    }

    public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double p_94689_) {
        if (!KeyHelper.hasShiftDown()) {
            DetailedSettingsScreen.scale = p_94689_ < 0.0 && p_94689_ + (double)DetailedSettingsScreen.scale < -60.0 ? -60 : (p_94689_ > 0.0 && p_94689_ + (double)DetailedSettingsScreen.scale > 160.0 ? 160 : (int)((double)DetailedSettingsScreen.scale + p_94689_ * 2.0));
        } else if (ModUtils.stringContains(this.textFromConfig, ",")) {
            String[] txtArray = this.textFromConfig.split(",");
            if ((double)this.hoverValue + p_94689_ * -1.0 > 0.0 && (double)this.hoverValue + p_94689_ * -1.0 + (double)(this.height / 20 * 2) <= (double)txtArray.length) {
                this.hoverValue = (int)((double)this.hoverValue + p_94689_ * -1.0);
            } else if ((double)this.hoverValue + p_94689_ * -1.0 + (double)(this.height / 20 * 2) > (double)txtArray.length) {
                this.hoverValue = txtArray.length - this.height / 20 * 2 < 0 ? 0 : txtArray.length - this.height / 20 * 2;
            }
        }
        return super.mouseScrolled(p_94686_, p_94687_, p_94688_, p_94689_);
    }

    public void mouseMoved(double p_94758_, double p_94759_) {
        if (this.draggingPlayerMode) {
            ClientOnlyForgeSetup.xRot = ClientOnlyForgeSetup.fakexRot - (int)(p_94758_ - (double)ClientOnlyForgeSetup.xPos);
            ClientOnlyForgeSetup.yRot = ClientOnlyForgeSetup.fakeyRot - (int)(p_94759_ - (double)ClientOnlyForgeSetup.yPos);
            if (ClientOnlyForgeSetup.xRot >= 360) {
                ClientOnlyForgeSetup.xRot -= 360;
            } else if (ClientOnlyForgeSetup.xRot <= -360) {
                ClientOnlyForgeSetup.xRot += 360;
            }
            if (ClientOnlyForgeSetup.yRot >= 360) {
                ClientOnlyForgeSetup.yRot -= 360;
            } else if (ClientOnlyForgeSetup.yRot <= -360) {
                ClientOnlyForgeSetup.yRot += 360;
            }
        }
        super.mouseMoved(p_94758_, p_94759_);
    }
}

