/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.placementcondition.AllOfPlacementCondition;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface PlacementCondition {
    public static final Codec<PlacementCondition> BASE_CODEC = Codec.lazyInitialized(() -> {
        Optional registry = BuiltInRegistries.REGISTRY.getOptional(LithostitchedRegistryKeys.PLACEMENT_CONDITION_TYPE.identifier());
        if (registry.isEmpty()) {
            throw new NullPointerException("Placement condition registry does not exist yet!");
        }
        return ((Registry)registry.get()).byNameCodec();
    }).dispatch(PlacementCondition::codec, Function.identity());
    public static final Codec<PlacementCondition> CODEC = Codec.withAlternative(BASE_CODEC, (Codec)BASE_CODEC.listOf(), AllOfPlacementCondition::new);

    public boolean test(Context var1, BlockPos var2);

    default public boolean test(Structure.GenerationContext context, BlockPos pos) {
        return this.test(Context.create(context), pos);
    }

    default public boolean test(PlacementContext context, BlockPos pos) {
        return this.test(Context.create(context), pos);
    }

    public MapCodec<? extends PlacementCondition> codec();

    public record Context(RegistryAccess registries, ChunkGenerator generator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource, long seed) {
        private static Context create(Structure.GenerationContext context) {
            return new Context(context.registryAccess(), context.chunkGenerator(), context.heightAccessor(), context.randomState(), context.biomeSource(), context.seed());
        }

        private static Context create(PlacementContext context) {
            WorldGenLevel level = context.getLevel();
            return new Context(level.registryAccess(), context.generator(), (LevelHeightAccessor)level, level.getLevel().getChunkSource().randomState(), context.generator().getBiomeSource(), level.getSeed());
        }
    }
}

