/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.commands.internal;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Collection;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.platform.util.IconExport;
import net.blay09.mods.balm.commands.BalmCommands;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.util.ConfigJsonExport;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.gamerules.GameRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalsCommand {
    private static final Logger logger = LoggerFactory.getLogger(InternalsCommand.class);
    private static final Identifier PERMISSION_BALM_DEV = Identifier.fromNamespaceAndPath((String)"balm", (String)"command.balm.dev");
    private static final Identifier PERMISSION_BALM_EXPORT_CONFIG = Identifier.fromNamespaceAndPath((String)"balm", (String)"command.balm.export.config");
    private static final Identifier PERMISSION_BALM_EXPORT_ICONS = Identifier.fromNamespaceAndPath((String)"balm", (String)"command.balm.export.icons");
    private static int balmDevCounter;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        BalmCommands.registerPermission(PERMISSION_BALM_DEV, Permissions.COMMANDS_OWNER);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_CONFIG, Permissions.COMMANDS_OWNER);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_ICONS, Permissions.COMMANDS_OWNER);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balm").then(((LiteralArgumentBuilder)Commands.literal((String)"dev").requires(BalmCommands.requirePermission(PERMISSION_BALM_DEV))).executes(context -> {
            if (Balm.platform().isDevelopmentEnvironment() || ++balmDevCounter >= 3) {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                MinecraftServer server = source.getServer();
                ServerLevel level = source.getLevel();
                GameRules gameRules = level.getGameRules();
                gameRules.set(GameRules.ADVANCE_TIME, (Object)false, server);
                source.sendSuccess(() -> Component.literal((String)"Daylight cycle disabled"), true);
                gameRules.set(GameRules.ADVANCE_WEATHER, (Object)false, server);
                source.sendSuccess(() -> Component.literal((String)"Weather cycle disabled"), true);
                gameRules.set(GameRules.KEEP_INVENTORY, (Object)true, server);
                source.sendSuccess(() -> Component.literal((String)"Keep Inventory enabled"), true);
                gameRules.set(GameRules.SPAWN_PHANTOMS, (Object)false, server);
                source.sendSuccess(() -> Component.literal((String)"Insomnia disabled"), true);
                gameRules.set(GameRules.MOB_GRIEFING, (Object)false, server);
                source.sendSuccess(() -> Component.literal((String)"Mob Griefing disabled"), true);
                gameRules.set(GameRules.SPAWN_WANDERING_TRADERS, (Object)false, server);
                source.sendSuccess(() -> Component.literal((String)"Trader Spawning disabled"), true);
                server.setDifficulty(Difficulty.PEACEFUL, true);
                source.sendSuccess(() -> Component.literal((String)"Difficulty set to Peaceful"), true);
                level.setWeatherParameters(99999, 0, false, false);
                source.sendSuccess(() -> Component.literal((String)"Weather cleared"), true);
                level.setDayTime(1000L);
                source.sendSuccess(() -> Component.literal((String)"Set the time to Daytime"), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"This command will change several game rules and your world's difficulty. You should only use it if you know what you're doing!").withStyle(ChatFormatting.RED), true);
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires(BalmCommands.requireAnyPermission(PERMISSION_BALM_EXPORT_CONFIG, PERMISSION_BALM_EXPORT_ICONS))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_CONFIG))).then(Commands.argument((String)"mod", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String mod = (String)context.getArgument("mod", String.class);
            Collection<BalmConfigSchema> schemas = Balm.config().getSchemasByNamespace(mod);
            try {
                ConfigJsonExport.exportToFile(schemas, new File("exports/config/" + mod + ".json"));
            }
            catch (Exception e) {
                logger.error("Error exporting config data class", (Throwable)e);
                throw new RuntimeException("Error exporting config data class: " + mod, e);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported config schema for " + mod)), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"icons").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_ICONS))).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.safeClientAccess().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    logger.error("Error exporting icons", (Throwable)e);
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }
}

