/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.platform.services;

import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.networking.PacketBase;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public void registerConfig(BuiltConfig var1);

    public <T extends PacketBase, B extends FriendlyByteBuf> void registerServerboundPacket(CustomPacketPayload.Type<T> var1, Class<T> var2, StreamCodec<B, T> var3, BiConsumer<T, Player> var4, Object ... var5);

    public <T extends PacketBase, B extends FriendlyByteBuf> void registerClientboundPacket(CustomPacketPayload.Type<T> var1, Class<T> var2, StreamCodec<B, T> var3, BiConsumer<T, Player> var4, Object ... var5);

    public void sendPacketToServer(Identifier var1, PacketBase var2);

    public void sendPacketToPlayer(Identifier var1, PacketBase var2, ServerPlayer var3);

    default public void sendPacketToAllPlayers(Identifier id, PacketBase packet, ServerLevel level) {
        for (ServerPlayer p : level.players()) {
            this.sendPacketToPlayer(id, packet, p);
        }
    }

    public CarryOnData getCarryData(Player var1);

    public void setCarryData(Player var1, CarryOnData var2);
}

