/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public boolean hasPassenger(Entity pEntity) {
        throw new IllegalStateException("EntityMixin application failed");
    }

    @ModifyExpressionValue(method={"startRiding(Lnet/minecraft/world/entity/Entity;ZZ)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;canSerialize()Z")})
    private boolean onStartRidingCheck(boolean original, Entity entity, boolean force) {
        if (force && entity instanceof Player) {
            return true;
        }
        return original;
    }

    @Shadow
    public abstract void onPassengerTurned(Entity var1);

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPositionPassenger(Entity entity, Entity.MoveFunction move, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player otherPlayer;
            Player thisPlayer = (Player)entityMixin;
            if (entity instanceof Player && this.hasPassenger((Entity)(otherPlayer = (Player)entity)) && CarryOnDataManager.getCarryData(thisPlayer).isCarrying(CarryOnData.CarryType.PLAYER)) {
                Vec3 forward = new Vec3(0.0, 0.0, 0.6);
                Vec3 otherPos = thisPlayer.position().add(forward.yRot((float)Math.toRadians(-thisPlayer.yBodyRot)));
                otherPos = otherPos.add(0.0, 0.4, 0.0);
                move.accept((Entity)otherPlayer, otherPos.x, otherPos.y, otherPos.z);
                ((Entity)this).onPassengerTurned((Entity)otherPlayer);
                ci.cancel();
            }
        }
    }

    @Inject(method={"getDismountLocationForPassenger(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")})
    private void onDismountPassenger(LivingEntity living, CallbackInfoReturnable<Vec3> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player thisPlayer = (Player)entityMixin;
            if (living instanceof Player) {
                Player otherPlayer = (Player)living;
                CarryOnData carry = CarryOnDataManager.getCarryData(thisPlayer);
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    carry.clear();
                    CarryOnDataManager.setCarryData(thisPlayer, carry);
                    Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.getId(), false), (ServerPlayer)thisPlayer);
                }
            }
        }
    }

    @Inject(method={"onPassengerTurned(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onPassengerTurned(Entity toUpdate, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            CarryOnData carry;
            Player thisPlayer = (Player)entityMixin;
            if (toUpdate instanceof Player && (carry = CarryOnDataManager.getCarryData(thisPlayer)).isCarrying(CarryOnData.CarryType.PLAYER)) {
                this.clampRotation(toUpdate);
            }
        }
    }

    @Unique
    private void clampRotation(Entity pEntityToUpdate) {
        Entity thisEntity = (Entity)this;
        pEntityToUpdate.setYBodyRot(thisEntity.getYRot());
        float f = Mth.wrapDegrees((float)(pEntityToUpdate.getYRot() - thisEntity.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-30.0f, (float)30.0f);
        pEntityToUpdate.yRotO += f1 - f;
        pEntityToUpdate.setYRot(pEntityToUpdate.getYRot() + f1 - f);
        pEntityToUpdate.setYHeadRot(pEntityToUpdate.getYRot());
    }
}

