/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.mrcrayfish.furniture.refurbished.util.ItemHash;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static Identifier resource(String name) {
        return Identifier.fromNamespaceAndPath((String)"refurbished_furniture", (String)name);
    }

    public static MutableComponent translation(String category, String path, Object ... params) {
        return Component.translatable((String)String.format("%s.%s.%s", category, "refurbished_furniture", path), (Object[])params);
    }

    public static String translationKey(String category, String path) {
        return String.format("%s.%s.%s", category, "refurbished_furniture", path);
    }

    public static <T> void shuffle(List<T> list, RandomSource random) {
        for (int i = list.size() - 1; i > 0; --i) {
            int randIndex = random.nextIntBetweenInclusive(0, i);
            T temp = list.get(i);
            list.set(i, list.get(randIndex));
            list.set(randIndex, temp);
        }
    }

    public static <T> List<T> concat(Collection<T> a, Collection<T> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    public static double pixels(double value) {
        return value * 0.0625;
    }

    public static Map<Item, Integer> countItems(boolean skipDamaged, List<Pair<Direction, Container>> containers) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemHash.INSTANCE);
        for (Pair<Direction, Container> pair : containers) {
            Direction direction = (Direction)pair.first();
            Container container = (Container)pair.second();
            Utils.getContainerSlots(container, direction).forEach(arg_0 -> Utils.lambda$countItems$0(container, skipDamaged, direction, (Map)map, arg_0));
        }
        return map;
    }

    public static int countItem(Item item, Container container) {
        return IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).filter(stack -> stack.is(item)).map(ItemStack::getCount).reduce(Integer::sum).orElse(0);
    }

    public static IntStream getContainerSlots(Container container, @Nullable Direction direction) {
        if (direction != null && container instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)container;
            return IntStream.of(worldly.getSlotsForFace(direction));
        }
        return IntStream.range(0, container.getContainerSize());
    }

    public static boolean canTakeFromContainer(Container container, int slot, ItemStack stack, @Nullable Direction direction) {
        if (container.canTakeItem(container, slot, stack)) {
            if (direction != null && container instanceof WorldlyContainer) {
                WorldlyContainer worldly = (WorldlyContainer)container;
                return worldly.canTakeItemThroughFace(slot, stack, direction);
            }
            return true;
        }
        return false;
    }

    public static String getItemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private static /* synthetic */ void lambda$countItems$0(Container container, boolean skipDamaged, Direction direction, Map map, int slot) {
        ItemStack stack = container.getItem(slot);
        if (stack.isEmpty() || skipDamaged && stack.isDamaged()) {
            return;
        }
        if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
            return;
        }
        map.merge(stack.getItem(), stack.getCount(), Integer::sum);
    }
}

