/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeliveryService
extends SavedData {
    private static final Codec<DeliveryService> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Mailbox.CODEC.listOf().fieldOf("Mailboxes").forGetter(service -> List.copyOf(service.mailboxes.values()))).apply((Applicative)instance, mailboxes -> {
        DeliveryService service = new DeliveryService();
        mailboxes.forEach(service::addMailbox);
        return service;
    }));
    private static final SavedDataType<DeliveryService> TYPE = new SavedDataType("refurbished_furniture_delivery_service", DeliveryService::new, CODEC, null);
    private final Map<Pair<Identifier, BlockPos>, Mailbox> locator = new HashMap<Pair<Identifier, BlockPos>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<Identifier, BlockPos>> pendingNames = new HashMap<UUID, Pair<Identifier, BlockPos>>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            return Optional.of((DeliveryService)level.getDataStorage().computeIfAbsent(TYPE));
        }
        return Optional.empty();
    }

    public void serverTick(MinecraftServer server) {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel(server);
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().identifier(), (Object)mailbox2.pos()));
            this.setDirty();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick(this, server));
    }

    public DeliveryResult sendMail(UUID id, ItemStack stack) {
        if (stack.isEmpty()) {
            return DeliveryResult.createFail("delivery_service.invalid_item");
        }
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox == null) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.unknown_mailbox"));
        }
        if (mailbox.queue().size() >= (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.mailbox_queue_full"));
        }
        if (!DeliveryService.isDeliverableDimension(mailbox.levelKey())) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.undeliverable_dimension"));
        }
        mailbox.queue().offer(stack);
        this.setDirty();
        return DeliveryResult.createSuccess(Utils.translationKey("gui", "delivery_service.package_sent"));
    }

    public void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public void removeMailbox(UUID mailboxId) {
        Mailbox mailbox = this.mailboxes.get(mailboxId);
        if (mailbox != null) {
            this.removal.offer(mailbox);
        }
    }

    public boolean canCreateMailbox(Player player) {
        long count = this.mailboxes.values().stream().filter(box -> box.owner().stream().anyMatch(uuid -> uuid.equals(player.getUUID()))).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    @Nullable
    public Mailbox getOrCreateMailBox(MailboxBlockEntity entity) {
        if (entity.isRemoved()) {
            return null;
        }
        this.duplicateIdCheck(entity);
        Mailbox mailbox = this.mailboxes.get(entity.getId());
        if (mailbox != null) {
            return this.removal.contains(mailbox) ? null : mailbox;
        }
        ResourceKey levelKey = entity.getLevel().dimension();
        BlockPos pos = entity.getBlockPos();
        return this.addMailbox(new Mailbox(entity.getId(), (ResourceKey<Level>)levelKey, pos));
    }

    private Mailbox addMailbox(Mailbox mailbox) {
        this.mailboxes.put(mailbox.id(), mailbox);
        this.locator.put((Pair<Identifier, BlockPos>)Pair.of((Object)mailbox.levelKey().identifier(), (Object)mailbox.pos()), mailbox);
        mailbox.setService(this);
        this.setDirty();
        return mailbox;
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.getBlockPos())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(Level level, BlockPos pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.dimension().identifier(), (Object)pos)));
    }

    public void markMailboxAsPendingName(Player player, Level level, BlockPos pos) {
        this.pendingNames.put(player.getUUID(), (Pair<Identifier, BlockPos>)Pair.of((Object)level.dimension().identifier(), (Object)pos));
    }

    public boolean renameMailbox(Player player, Level level, BlockPos pos, String customName) {
        Pair<Identifier, BlockPos> pendingLocation = this.pendingNames.remove(player.getUUID());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().orElse(null), player.getUUID())) {
                return false;
            }
            Pair location = Pair.of((Object)level.dimension().identifier(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public Collection<IMailbox> getMailboxes() {
        return Collections.unmodifiableCollection(this.mailboxes.values());
    }

    private void load(ValueInput input) {
        ValueInput.TypedInputList list = input.listOrEmpty("Mailboxes", Mailbox.CODEC);
        list.forEach(this::addMailbox);
    }

    public void save(ValueOutput output) {
        ValueOutput.TypedOutputList list = output.list("Mailboxes", Mailbox.CODEC);
        this.mailboxes.forEach((id, mailbox) -> list.add(mailbox));
    }

    @Nullable
    private static ResourceKey<Level> createLevelKey(String levelKey) {
        ResourceKey resourceKey;
        if (levelKey.isBlank()) {
            resourceKey = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    resourceKey = Level.OVERWORLD;
                    break;
                }
                case "minecraft:the_nether": {
                    resourceKey = Level.NETHER;
                    break;
                }
                case "minecraft:the_end": {
                    resourceKey = Level.END;
                    break;
                }
                default: {
                    resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.parse((String)levelKey));
                }
            }
        }
        return resourceKey;
    }

    public static boolean isBannedItem(ItemStack stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.getItem().canFitInsideContainerItems()) {
            return true;
        }
        String name = stack.getItem().getDescriptionId();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }

    public static boolean isDeliverableDimension(Level level) {
        return DeliveryService.isDeliverableDimension((ResourceKey<Level>)level.dimension());
    }

    public static boolean isDeliverableDimension(ResourceKey<Level> key) {
        List validDimensions = (List)Config.SERVER.mailing.allowedDimensions.get();
        if (!validDimensions.isEmpty()) {
            return validDimensions.contains(key.identifier().toString());
        }
        return true;
    }
}

