/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RecycleBinMenu
extends SimpleContainerMenu
implements IPowerSwitchMenu,
IElectricityMenu {
    private final ContainerData data;

    public RecycleBinMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public RecycleBinMenu(int windowId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuTypes.RECYCLE_BIN.get(), windowId, container);
        RecycleBinMenu.checkContainerSize((Container)container, (int)3);
        RecycleBinMenu.checkContainerDataCount((ContainerData)data, (int)4);
        container.startOpen((ContainerUser)playerInventory.player);
        this.data = data;
        this.addContainerSlots(26, 29, 3, 1, 0);
        this.addPlayerInventorySlots(8, 111, playerInventory);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    @Override
    public boolean isEnabled() {
        return this.data.get(1) != 0;
    }

    @Override
    public boolean isPowered() {
        return this.data.get(0) != 0;
    }

    public int getProcessTime() {
        return this.data.get(2);
    }

    public int getRecycledCount() {
        return this.data.get(3);
    }

    @Override
    public void toggle() {
        Container container = this.container;
        if (container instanceof IPowerSwitch) {
            IPowerSwitch powerSwitch = (IPowerSwitch)container;
            powerSwitch.togglePower();
        }
    }
}

