/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;

public class PaletteImage {
    public static final int[] COLOURS = new int[]{0, -15726070, -10985901, -5921399, -1382959, -2177434, -6837424, -11441352, -14346993, -11393230, -6540740, -3905987, -1798784, -10251601, -13878166, -13886156};
    private static final int BITS_PER_INDEX = 4;
    public static final Codec<PaletteImage> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Identifier.CODEC.fieldOf("id").forGetter(PaletteImage::getId), (App)Codec.INT.fieldOf("width").validate(val -> {
        if (val >= 1 && val <= 128) {
            return DataResult.success((Object)val);
        }
        return DataResult.error(() -> "Width must be between 1 and 128 (inclusive)");
    }).forGetter(PaletteImage::getWidth), (App)Codec.INT.fieldOf("height").validate(val -> {
        if (val >= 1 && val <= 128) {
            return DataResult.success((Object)val);
        }
        return DataResult.error(() -> "Height must be between 1 and 128 (inclusive)");
    }).forGetter(PaletteImage::getHeight), (App)ExtraCodecs.BIT_SET.fieldOf("data").forGetter(PaletteImage::getData)).apply((Applicative)builder, PaletteImage::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaletteImage> STREAM_CODEC = StreamCodec.of((buf, image) -> {
        buf.writeByte((byte)image.width);
        buf.writeByte((byte)image.height);
        buf.writeLongArray(image.bits.toLongArray());
    }, buf -> {
        byte width = buf.readByte();
        byte height = buf.readByte();
        long[] data = buf.readLongArray();
        return new PaletteImage(width, height, () -> BitSet.valueOf(data));
    });
    protected final Identifier id;
    protected final int width;
    protected final int height;
    protected final BitSet bits;

    public PaletteImage(int width, int height) {
        this(width, height, () -> new BitSet(width * height));
    }

    private PaletteImage(Identifier id, int width, int height, BitSet data) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.bits = BitSet.valueOf(data.toLongArray());
    }

    public PaletteImage(int width, int height, Supplier<BitSet> supplier) {
        Preconditions.checkArgument((width >= 1 && width <= 128 ? 1 : 0) != 0, (Object)"Width must be between 1 and 128 (inclusive)");
        Preconditions.checkArgument((height >= 1 && height <= 128 ? 1 : 0) != 0, (Object)"Height must be between 1 and 128 (inclusive)");
        this.width = width;
        this.height = height;
        BitSet bits = new BitSet(width * height);
        bits.or(supplier.get());
        this.bits = bits;
        this.id = this.createImageId(bits);
    }

    public Identifier getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BitSet getData() {
        return this.bits;
    }

    public void set(int x, int y, int colourIndex) {
        Preconditions.checkPositionIndex((int)(y * this.width + x), (int)(this.width * this.height - 1));
        Preconditions.checkPositionIndex((int)colourIndex, (int)(COLOURS.length - 1));
        int bitIndex = (y * this.width + x) * 4;
        this.bits.set(bitIndex + 0, (colourIndex & 1) != 0);
        this.bits.set(bitIndex + 1, (colourIndex & 2) != 0);
        this.bits.set(bitIndex + 2, (colourIndex & 4) != 0);
        this.bits.set(bitIndex + 3, (colourIndex & 8) != 0);
    }

    public int get(int x, int y) {
        Preconditions.checkArgument((y * this.width + x < this.width * this.height ? 1 : 0) != 0);
        int bitIndex = (y * this.width + x) * 4;
        int value = 0;
        value = PaletteImage.setBit(value, 0, this.bits.get(bitIndex + 0));
        value = PaletteImage.setBit(value, 1, this.bits.get(bitIndex + 1));
        value = PaletteImage.setBit(value, 2, this.bits.get(bitIndex + 2));
        value = PaletteImage.setBit(value, 3, this.bits.get(bitIndex + 3));
        return value;
    }

    private static int setBit(int value, int offset, boolean state) {
        if (state) {
            value |= 1 << offset;
        }
        return value;
    }

    private Identifier createImageId(BitSet set) {
        return Utils.resource("palette_image_" + Util.sanitizeName((String)Integer.toHexString(set.hashCode()), Identifier::validPathChar));
    }

    public PaletteImage copy() {
        return new PaletteImage(this.width, this.height, () -> BitSet.valueOf(this.bits.toLongArray()));
    }
}

