/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;

public class ComputerButton
extends Button {
    protected int outlineColour = -12107714;
    protected int outlineHighlightColour = -12107714;
    protected int outlineDisabledColour = -13423059;
    protected int backgroundColour = -14540251;
    protected int backgroundHighlightColour = -12107714;
    protected int backgroundDisabledColour = -12107714;
    protected int textColour = -10791856;
    protected int textHighlightColour = -14540251;
    protected int textDisabledColour = -13423059;
    protected int textOffset;
    protected SoundEvent clickSound;

    public ComputerButton(int width, int height, Component label, Button.OnPress onPress) {
        super(0, 0, width, height, label, onPress, DEFAULT_NARRATION);
    }

    protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.getOutlineColour());
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, this.getBackgroundColour());
        int messageWidth = mc.font.width((FormattedText)this.getMessage());
        Font font = mc.font;
        Component component = this.getMessage();
        int n = this.getX() + (this.getWidth() - messageWidth) / 2 + 1;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(mc.font);
        graphics.drawString(font, component, n, n2 + (n3 - 9) / 2 + 1 + this.textOffset, this.getTextColour(), false);
    }

    public void playDownSound(SoundManager manager) {
        if (this.clickSound != null) {
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)1.0f, (float)0.5f));
            return;
        }
        super.playDownSound(manager);
    }

    protected int getTextColour() {
        if (this.isActive()) {
            if (this.isHoveredOrFocused()) {
                return this.textHighlightColour;
            }
            return this.textColour;
        }
        return this.textDisabledColour;
    }

    protected int getOutlineColour() {
        if (this.isActive()) {
            if (this.isHoveredOrFocused()) {
                return this.outlineHighlightColour;
            }
            return this.outlineColour;
        }
        return this.outlineDisabledColour;
    }

    protected int getBackgroundColour() {
        if (this.isActive()) {
            if (this.isHoveredOrFocused()) {
                return this.backgroundHighlightColour;
            }
            return this.backgroundColour;
        }
        return this.backgroundDisabledColour;
    }

    public void setOutlineColour(int outlineColour) {
        this.outlineColour = outlineColour;
    }

    public void setOutlineHighlightColour(int outlineHighlightColour) {
        this.outlineHighlightColour = outlineHighlightColour;
    }

    public void setOutlineDisabledColour(int outlineDisabledColour) {
        this.outlineDisabledColour = outlineDisabledColour;
    }

    public void setBackgroundColour(int backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public void setBackgroundHighlightColour(int backgroundHighlightColour) {
        this.backgroundHighlightColour = backgroundHighlightColour;
    }

    public void setBackgroundDisabledColour(int backgroundDisabledColour) {
        this.backgroundDisabledColour = backgroundDisabledColour;
    }

    public void setTextColour(int textColour) {
        this.textColour = textColour;
    }

    public void setTextHighlightColour(int textHighlightColour) {
        this.textHighlightColour = textHighlightColour;
    }

    public void setTextDisabledColour(int textDisabledColour) {
        this.textDisabledColour = textDisabledColour;
    }

    public void setTextOffset(int textOffset) {
        this.textOffset = textOffset;
    }

    public void setClickSound(SoundEvent clickSound) {
        this.clickSound = clickSound;
    }
}

