/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client;

import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ProgramShortcutButton;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class Desktop {
    private static final int SHORTCUT_AREA_WIDTH = 220;
    private static final int SHORTCUT_COLUMNS = 7;
    private final ComputerScreen screen;
    private final List<ProgramShortcutButton> shortcuts;
    private int displayStart;
    private int displayTop;
    private int displayWidth;
    private int displayHeight;

    public Desktop(ComputerScreen screen) {
        this.screen = screen;
        this.shortcuts = this.createProgramShortcuts();
    }

    private List<ProgramShortcutButton> createProgramShortcuts() {
        int index = 0;
        ArrayList<ProgramShortcutButton> shortcuts = new ArrayList<ProgramShortcutButton>();
        for (Identifier id : Computer.get().getPrograms()) {
            Icon icon = Display.get().getIcon(id);
            if (icon == null) continue;
            shortcuts.add(new ProgramShortcutButton(this.screen, index++, 42, 32, this.getProgramName(id), icon, btn -> {
                Network.getPlay().sendToServer((Object)new MessageComputerOpenProgram(id));
                btn.setFocused(false);
            }));
        }
        return shortcuts;
    }

    public void update(int displayStart, int displayTop, int displayWidth, int displayHeight) {
        this.displayStart = displayStart;
        this.displayTop = displayTop;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        int startX = displayStart + (displayWidth - 220) / 2;
        int startY = displayTop + 4;
        this.shortcuts.forEach(shortcut -> {
            int shortcutX = startX + shortcut.getIndex() % 7 * 42 + shortcut.getIndex() % 7 * 4;
            int shortcutY = startY + shortcut.getIndex() / 7 * 32 + shortcut.getIndex() / 7 * 4;
            shortcut.setPosition(shortcutX, shortcutY);
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(this.displayStart, this.displayTop, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -14277082);
        this.shortcuts.forEach(shortcut -> shortcut.render(graphics, mouseX, mouseY, partialTick));
        graphics.fill(this.displayStart, this.displayTop + this.displayHeight - 16, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -10857649);
        graphics.fill(this.displayStart, this.displayTop + this.displayHeight - 16 + 2, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -13423059);
        Font font = Minecraft.getInstance().font;
        String timeLabel = this.getDayTimeLabel();
        int width = font.width(timeLabel);
        graphics.drawString(font, timeLabel, this.displayStart + this.displayWidth - width - 5, this.displayTop + this.displayHeight - 11, -1, false);
        graphics.blit(RenderPipelines.GUI_TEXTURED, ComputerScreen.TEXTURE, this.displayStart, this.displayTop + this.displayHeight - 24, 32.0f, 36.0f, 0, 150, 16, 18, 256, 256);
    }

    private Component getProgramName(Identifier id) {
        return Component.translatable((String)String.format("computer_program.%s.%s", id.getNamespace(), id.getPath()));
    }

    public List<ProgramShortcutButton> getShortcuts() {
        return this.shortcuts;
    }

    private String getDayTimeLabel() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            long time = (level.getDayTime() + 6000L) % 24000L;
            long hours = time / 1000L;
            long minutes = 60L * (time % 1000L) / 1000L;
            return "%d:%02d".formatted(hours, minutes);
        }
        return "";
    }
}

