/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.app;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.ComputerBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HomeControl
extends Program {
    public HomeControl(Identifier id, IComputer computer) {
        super(id, computer);
    }

    public List<IHomeControlDevice> findDevices() {
        BlockEntity blockEntity;
        Player player = this.computer.getUser();
        if (player != null && (blockEntity = player.level().getBlockEntity(this.computer.getComputerPos())) instanceof ComputerBlockEntity) {
            ComputerBlockEntity computerBlockEntity = (ComputerBlockEntity)blockEntity;
            int maxSize = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
            return IElectricityNode.searchNodes(computerBlockEntity, maxSize, true, node -> true, node -> node instanceof IHomeControlDevice).stream().map(node -> (IHomeControlDevice)((Object)node)).sorted(Comparator.comparing(device -> device.getDeviceName().getString())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void toggleDevice(BlockPos pos) {
        BlockEntity blockEntity;
        Player player;
        if (this.findDevices().stream().anyMatch(device -> device.getDevicePos().equals((Object)pos)) && (player = this.computer.getUser()) != null && (blockEntity = player.level().getBlockEntity(pos)) instanceof IHomeControlDevice) {
            IHomeControlDevice device2 = (IHomeControlDevice)blockEntity;
            device2.toggleDeviceState();
        }
    }

    public void updateDevices(boolean state) {
        this.findDevices().forEach(device -> device.setDeviceState(state));
    }
}

