/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.FluidEntityRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.AABB;

public class SimpleFluidRenderer {
    public static void submit(FluidEntityRenderState state, PoseStack stack, SubmitNodeCollector collector) {
        if (!state.valid()) {
            return;
        }
        collector.submitCustomGeometry(stack, RenderTypes.translucentMovingBlock(), (pose, consumer) -> SimpleFluidRenderer.drawContainer(state, pose, consumer));
    }

    private static void drawContainer(FluidEntityRenderState state, PoseStack.Pose pose, VertexConsumer consumer) {
        AABB box = state.box;
        TextureAtlasSprite still = state.fluidSprites.still();
        int colour = state.waterTintAtPos;
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float fullness = (float)state.fluidAmount / (float)state.fluidCapacity;
        float offset = (float)(box.minY + (box.maxY - box.minY) * (double)fullness);
        float uScale = still.getU1() - still.getU0();
        float vScale = still.getV1() - still.getV0();
        float u0 = still.getU0() + uScale * (float)box.minX;
        float u1 = still.getU0() + uScale * (float)box.maxX;
        float v0 = still.getV0() + vScale * (float)box.minZ;
        float v1 = still.getV0() + vScale * (float)box.maxZ;
        consumer.addVertex(pose, (float)box.minX, offset, (float)box.minZ).setColor(red, green, blue, 1.0f).setUv(u0, v0).setLight(state.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, (float)box.minX, offset, (float)box.maxZ).setColor(red, green, blue, 1.0f).setUv(u0, v1).setLight(state.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, (float)box.maxX, offset, (float)box.maxZ).setColor(red, green, blue, 1.0f).setUv(u1, v1).setLight(state.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, (float)box.maxX, offset, (float)box.minZ).setColor(red, green, blue, 1.0f).setUv(u1, v0).setLight(state.lightCoords).setNormal(0.0f, 1.0f, 0.0f);
    }

    public static AABB createRotatedBox(Direction direction, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        minX /= 16.0;
        minY /= 16.0;
        minZ /= 16.0;
        maxX /= 16.0;
        maxY /= 16.0;
        maxZ /= 16.0;
        return switch (direction) {
            case Direction.WEST -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
            case Direction.NORTH -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
            case Direction.SOUTH -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
            default -> new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        };
    }
}

