/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.CookingItemStackRenderState;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.GrillRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class GrillBlockEntityRenderer
implements BlockEntityRenderer<GrillBlockEntity, GrillRenderState> {
    private final ItemModelResolver itemModelResolver;

    public GrillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public GrillRenderState createRenderState() {
        return new GrillRenderState();
    }

    public void extractRenderState(GrillBlockEntity entity, GrillRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        ItemStackRenderState itemState;
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        NonNullList<ItemStack> foods = entity.getCookingItems();
        renderState.foods = new CookingItemStackRenderState[foods.size()];
        for (int i = 0; i < foods.size(); ++i) {
            CookingItemStackRenderState cookingItemState;
            ItemStack stack = (ItemStack)foods.get(i);
            if (stack.isEmpty()) continue;
            renderState.foods[i] = cookingItemState = new CookingItemStackRenderState();
            itemState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemState, stack, ItemDisplayContext.NONE, entity.getLevel(), null, 0);
            cookingItemState.item = itemState;
            GrillBlockEntity.CookingSpace space = entity.getCookingSpace(i);
            cookingItemState.itemFlipped = space.isFlipped();
            cookingItemState.itemRotation = space.getRotation();
            FlipAnimation animation = space.getAnimation();
            cookingItemState.animationTime = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
            cookingItemState.animationPlaying = animation.isPlaying();
        }
        NonNullList<ItemStack> fuels = entity.getFuelItems();
        renderState.fuels = new ItemStackRenderState[fuels.size()];
        for (int i = 0; i < fuels.size(); ++i) {
            ItemStack stack = (ItemStack)fuels.get(i);
            if (stack.isEmpty()) continue;
            itemState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemState, stack, ItemDisplayContext.NONE, entity.getLevel(), null, 0);
            renderState.fuels[i] = itemState;
        }
    }

    public void submit(GrillRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        int i;
        if (renderState.foods != null) {
            for (i = 0; i < renderState.foods.length; ++i) {
                CookingItemStackRenderState cookingItemState = renderState.foods[i];
                if (cookingItemState == null) continue;
                this.drawCookingSpace(cookingItemState, stack, i, renderState.lightCoords, collector);
            }
        }
        if (renderState.fuels != null) {
            for (i = 0; i < renderState.fuels.length; ++i) {
                ItemStackRenderState itemState = renderState.fuels[i];
                if (itemState == null) continue;
                this.drawFuel(itemState, stack, i, renderState.lightCoords, collector);
            }
        }
    }

    private void drawCookingSpace(CookingItemStackRenderState itemState, PoseStack stack, int quadrant, int light, SubmitNodeCollector collector) {
        if (itemState.item != null) {
            float time = itemState.animationPlaying ? itemState.animationTime : 0.0f;
            float flipProgress = this.calculateFlipProgress(time);
            float flipHeight = 0.75f;
            stack.pushPose();
            stack.translate(0.0f, flipProgress * flipHeight, 0.0f);
            stack.translate(0.3 + 0.4 * (double)(quadrant % 2), 1.0, 0.3 + 0.4 * (double)(quadrant / 2));
            stack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
            stack.mulPose((Quaternionfc)Axis.ZP.rotation(1.5707964f * (float)itemState.itemRotation));
            stack.mulPose((Quaternionfc)Axis.XP.rotation((float)Math.PI * -3 * time));
            stack.mulPose((Quaternionfc)Axis.XP.rotation(!itemState.animationPlaying && itemState.itemFlipped ? (float)Math.PI : 0.0f));
            stack.scale(0.375f, 0.375f, 0.375f);
            itemState.item.submit(stack, collector, light, OverlayTexture.NO_OVERLAY, 0);
            stack.popPose();
        }
    }

    private void drawFuel(ItemStackRenderState itemState, PoseStack stack, int index, int light, SubmitNodeCollector collector) {
        stack.pushPose();
        stack.translate(0.3 + 0.2 * (double)(index % 3), 0.85, 0.3 + 0.2 * (double)(index / 3));
        stack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(10.0f));
        stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(10.0f));
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(5.0f));
        stack.scale(0.375f, 0.375f, 0.375f);
        itemState.submit(stack, collector, light, OverlayTexture.NO_OVERLAY, 0);
        stack.popPose();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

