/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.framework.api.client.model.renderer.StandaloneModelRenderer;
import com.mrcrayfish.furniture.refurbished.block.CeilingFanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CeilingFanBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.CeilingFanRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModExtraModels;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CeilingFanBlockEntityRenderer
implements BlockEntityRenderer<CeilingFanBlockEntity, CeilingFanRenderState> {
    private static final Map<Block, Supplier<BlockModelPart>> BLADE_MODEL_MAP = new Object2ObjectOpenHashMap();
    private final EntityRenderDispatcher entityRenderer;

    public CeilingFanBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
    }

    public CeilingFanRenderState createRenderState() {
        return new CeilingFanRenderState();
    }

    public void extractRenderState(CeilingFanBlockEntity entity, CeilingFanRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        renderState.direction = entity.getDirection();
        renderState.rotation = entity.getRotation(partialTick);
        renderState.damageBox = entity.getDamageBox(entity.getDirection());
    }

    public void submit(CeilingFanRenderState renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)renderState.direction.getRotation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rotation));
        poseStack.translate(-0.5, -0.5, -0.5);
        BlockModelPart model = this.getCeilingFanBladeModel(renderState.blockState);
        StandaloneModelRenderer.submitDraw((SubmitNodeCollector)collector, (BlockModelPart)model, (PoseStack)poseStack, (float)1.0f, (float)1.0f, (float)1.0f, (int)renderState.lightCoords, (int)OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        if (Minecraft.getInstance().debugEntries.isCurrentlyEnabled(DebugScreenEntries.ENTITY_HITBOXES)) {
            // empty if block
        }
    }

    private BlockModelPart getCeilingFanBladeModel(BlockState state) {
        CeilingFanBlock block;
        Supplier<BlockModelPart> supplier;
        Block block2 = state.getBlock();
        if (block2 instanceof CeilingFanBlock && (supplier = BLADE_MODEL_MAP.get(block = (CeilingFanBlock)block2)) != null) {
            return supplier.get();
        }
        return (BlockModelPart)ModExtraModels.OAK_LIGHT_CEILING_FAN_BLADE.getModel();
    }

    public static void registerFanBlade(Block block, Supplier<BlockModelPart> modelSupplier) {
        BLADE_MODEL_MAP.putIfAbsent(block, modelSupplier);
    }
}

