/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.toast;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;

public class ItemToast
implements Toast {
    public static final Identifier TOAST_SPRITE = Identifier.withDefaultNamespace((String)"toast/advancement");
    private final Component title;
    private final Component description;
    private final ItemStack icon;
    private Toast.Visibility visibility = Toast.Visibility.HIDE;

    public ItemToast(Component title, Component description, ItemStack icon) {
        this.title = title;
        this.description = description;
        this.icon = icon;
    }

    public void render(GuiGraphics graphics, Font font, long time) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, TOAST_SPRITE, 0, 0, this.width(), this.height());
        graphics.drawString(font, this.title, 30, 7, -11534256, false);
        graphics.drawString(font, this.description, 30, 18, -16777216, false);
        graphics.renderFakeItem(this.icon, 8, 8);
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void update(ToastManager manager, long time) {
        this.visibility = time < 5000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }
}

