/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.google.common.base.MoreObjects;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class TextInputScreen
extends Screen {
    private static final Identifier WINDOW_SPRITE = Utils.resource("window");
    public static final int WINDOW_WIDTH = 160;
    public static final int WINDOW_HEIGHT = 72;
    protected final Component hint;
    protected final Function<String, Boolean> callback;
    protected Function<String, Boolean> validator = s -> true;
    protected EditBox editBox;
    protected Button closeButton;
    protected Button acceptButton;
    protected Component acceptLabel;
    protected String input = "";

    public TextInputScreen(Component title, Component hint, Function<String, Boolean> callback) {
        super(title);
        this.hint = hint;
        this.callback = callback;
    }

    public void setValidator(Function<String, Boolean> validator) {
        this.validator = validator;
    }

    public void setAcceptLabel(Component acceptLabel) {
        this.acceptLabel = acceptLabel;
    }

    protected void init() {
        int startX = (this.width - 160) / 2;
        int startY = (this.height - 72) / 2;
        this.editBox = new EditBox(this.minecraft.font, startX + 6, startY + 20, 148, 20, this.hint);
        this.addRenderableWidget((GuiEventListener)this.editBox);
        this.editBox.setResponder(this::updateAcceptButton);
        if (!this.input.isBlank()) {
            this.editBox.setValue(this.input);
        }
        this.closeButton = Button.builder((Component)Component.literal((String)"Close"), btn -> this.minecraft.setScreen(null)).pos(startX + 6, startY + 45).size(72, 20).build();
        this.addRenderableWidget((GuiEventListener)this.closeButton);
        this.acceptButton = Button.builder((Component)((Component)MoreObjects.firstNonNull((Object)this.acceptLabel, (Object)Component.literal((String)"Accept"))), btn -> {
            if (this.callback.apply(this.input).booleanValue()) {
                this.minecraft.setScreen(null);
            }
        }).pos(startX + 74 + 2 + 6, startY + 45).size(72, 20).build();
        this.addRenderableWidget((GuiEventListener)this.acceptButton);
        this.updateAcceptButton(this.input);
    }

    private void updateAcceptButton(String input) {
        boolean valid = this.validator.apply(input);
        this.editBox.setTextColor(valid ? -1 : -65536);
        this.acceptButton.active = valid;
        this.input = input;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        int startX = (this.width - 160) / 2;
        int startY = (this.height - 72) / 2;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, WINDOW_SPRITE, startX, startY, 160, 72);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int startX = (this.width - 160) / 2;
        int startY = (this.height - 72) / 2;
        graphics.drawString(this.minecraft.font, this.title, startX + 6, startY + 7, -12566464, false);
    }
}

