/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.image.ImagePresets;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdatePainting;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class DoorMatScreen
extends AbstractContainerScreen<DoorMatMenu> {
    private static final Identifier TEXTURE = Utils.resource("textures/gui/container/door_mat.png");
    private static final PaletteImage[] PRESETS = new PaletteImage[]{ImagePresets.BLANK, ImagePresets.HEART, ImagePresets.MUSHROOM, ImagePresets.FORWARD_ARROW, ImagePresets.WARNING, ImagePresets.HOUSE, ImagePresets.CRISSCROSS, ImagePresets.STRIPES, ImagePresets.WAVES_PATTERN, ImagePresets.GEM_PATTERN, ImagePresets.ABSTRACT_PATTERN, ImagePresets.SWIRL_PATTERN};
    private PaletteImage image;
    private Tool currentTool = Tool.PENCIL;
    @Nullable
    private Tool activeTool;
    private int selectedColourIndex = 1;
    private int currentPreset = 0;

    public DoorMatScreen(DoorMatMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 134;
        this.imageHeight = 103;
        this.image = PRESETS[0].copy();
    }

    protected void init() {
        super.init();
        Button previousPreset = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + this.imageWidth / 2 - 45 - 20, this.topPos + 14, 0, 20, btn -> {
            this.image = PRESETS[Math.floorMod(--this.currentPreset, PRESETS.length)].copy();
        }));
        previousPreset.setTooltip(Tooltip.create((Component)Utils.translation("gui", "previous_preset", new Object[0])));
        Button nextPreset = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + this.imageWidth / 2 + 45, this.topPos + 14, 10, 20, btn -> {
            this.image = PRESETS[Math.floorMod(++this.currentPreset, PRESETS.length)].copy();
        }));
        nextPreset.setTooltip(Tooltip.create((Component)Utils.translation("gui", "next_preset", new Object[0])));
        for (int i = 1; i < PaletteImage.COLOURS.length; ++i) {
            this.addRenderableWidget((GuiEventListener)new ColourButton(this.leftPos + (i - 1) * 8 + 7, this.topPos + 65, i));
        }
        this.addRenderableWidget((GuiEventListener)new ToolButton(this.leftPos + 6, this.topPos + 77, 30, 10, Tool.PENCIL));
        this.addRenderableWidget((GuiEventListener)new ToolButton(this.leftPos + 29, this.topPos + 77, 40, 10, Tool.ERASER));
        this.addRenderableWidget((GuiEventListener)new ToolButton(this.leftPos + 52, this.topPos + 77, 50, 10, Tool.FILL));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.translation("gui", "save", new Object[0]), var1 -> Network.getPlay().sendToServer((Object)new MessageUpdatePainting(this.image))).pos(this.leftPos + 75, this.topPos + 77).size(53, 20).build());
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        for (int y = 0; y < this.image.getHeight(); ++y) {
            for (int x = 0; x < this.image.getWidth(); ++x) {
                int pixelStart = this.leftPos + 39 + x * 4;
                int pixelEnd = pixelStart + 4;
                int pixelTop = this.topPos + 4 + y * 4;
                int pixelBottom = pixelTop + 4;
                graphics.fill(pixelStart, pixelTop, pixelEnd, pixelBottom, PaletteImage.COLOURS[this.image.get(x, y)]);
            }
        }
        if (this.activeTool != null) {
            this.activateTool(mouseX, mouseY, true);
        }
    }

    private boolean activateTool(double mouseX, double mouseY, boolean continuous) {
        int start = this.leftPos + 39;
        int end = start + 56;
        int top = this.topPos + 4;
        int bottom = top + 40;
        if (mouseX >= (double)start && mouseX < (double)end && mouseY >= (double)top && mouseY < (double)bottom) {
            int x = (int)((mouseX - (double)start) / 4.0);
            int y = (int)((mouseY - (double)top) / 4.0);
            if (this.currentTool.getFunction().apply(this.image, x, y, this.selectedColourIndex) && !continuous) {
                this.activeTool = this.currentTool;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0 && this.activateTool(event.x(), event.y(), false)) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.activeTool != null && event.button() == 0) {
            this.activeTool = null;
        }
        return super.mouseReleased(event);
    }

    private static enum Tool {
        PENCIL((image, x, y, colourIndex) -> {
            image.set(x, y, colourIndex);
            return true;
        }),
        ERASER((image, x, y, colourIndex) -> {
            image.set(x, y, 0);
            return true;
        }),
        FILL((image, x, y, colourIndex) -> {
            int fillColourIndex = image.get(x, y);
            if (fillColourIndex == colourIndex) {
                return false;
            }
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.offer(Pair.of((Object)x, (Object)y));
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.poll();
                int pixelX = (Integer)pair.left();
                int pixelY = (Integer)pair.right();
                image.set(pixelX, pixelY, colourIndex);
                if (pixelY - 1 >= 0 && image.get(pixelX, pixelY - 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY - 1)));
                }
                if (pixelY + 1 < image.getHeight() && image.get(pixelX, pixelY + 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY + 1)));
                }
                if (pixelX - 1 >= 0 && image.get(pixelX - 1, pixelY) == fillColourIndex) {
                    queue.offer(Pair.of((Object)(pixelX - 1), (Object)pixelY));
                }
                if (pixelX + 1 >= image.getWidth() || image.get(pixelX + 1, pixelY) != fillColourIndex) continue;
                queue.offer(Pair.of((Object)(pixelX + 1), (Object)pixelY));
            }
            return false;
        });

        private final ToolFunction function;

        private Tool(ToolFunction function) {
            this.function = function;
        }

        public ToolFunction getFunction() {
            return this.function;
        }
    }

    private class ColourButton
    extends ComputerButton {
        private final int colourIndex;

        protected ColourButton(int x, int y, int colourIndex) {
            super(8, 8, CommonComponents.EMPTY, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.selectedColourIndex = colourIndex;
            });
            this.setPosition(x, y);
            this.colourIndex = colourIndex;
            this.setBackgroundColour(PaletteImage.COLOURS[colourIndex]);
            this.setBackgroundHighlightColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineHighlightColour(-1);
        }

        public boolean isHovered() {
            return super.isHovered() || DoorMatScreen.this.selectedColourIndex == this.colourIndex;
        }

        public int getColourIndex() {
            return this.colourIndex;
        }
    }

    private class ToolButton
    extends IconButton {
        private final Tool tool;

        public ToolButton(int x, int y, int u, int v, Tool tool) {
            super(x, y, u, v, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.currentTool = tool;
            });
            this.tool = tool;
        }

        public boolean isHovered() {
            return super.isHovered() || DoorMatScreen.this.currentTool == this.tool;
        }
    }

    @FunctionalInterface
    private static interface ToolFunction {
        public boolean apply(PaletteImage var1, int var2, int var3, int var4);
    }
}

