/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.IWidgetGroup;
import com.mrcrayfish.furniture.refurbished.computer.client.Desktop;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Window;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ProgramShortcutButton;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.mixin.client.ScreenAccessor;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class ComputerScreen
extends ElectricityContainerScreen<ComputerMenu> {
    public static final Identifier TEXTURE = Utils.resource("textures/gui/container/computer.png");
    private static final int DISPLAY_LEFT = 15;
    private static final int DISPLAY_TOP = 15;
    public static final int DISPLAY_WIDTH = 226;
    public static final int DISPLAY_HEIGHT = 120;
    private static final int LOADING_TIME = 20;
    private static final int LOADING_BAR_WIDTH = 100;
    private final Desktop desktop = new Desktop(this);
    @Nullable
    private Window window;
    private int loading = 20;

    public ComputerScreen(ComputerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.desktop.getShortcuts().forEach(x$0 -> {
            ProgramShortcutButton cfr_ignored_0 = (ProgramShortcutButton)this.addWidget((GuiEventListener)x$0);
        });
        this.imageWidth = 256;
        this.imageHeight = 150;
        this.getComputer().setScreen(this);
    }

    public ClientComputer getComputer() {
        return (ClientComputer)((ComputerMenu)this.menu).getComputer();
    }

    @Nullable
    public Window getOrCreateWindow() {
        DisplayableProgram<?> displayable = this.getComputer().getDisplayable();
        if (this.window == null && displayable != null) {
            this.window = new Window(displayable, this.getComputer());
            this.addRenderableWidget((GuiEventListener)this.window.getCloseButton());
            this.updateWindow();
        } else if (this.window != null && displayable == null) {
            this.removeWidget((GuiEventListener)this.window.getCloseButton());
            this.window.onClose();
            this.window = null;
        }
        return this.window;
    }

    private void updateWindow() {
        if (this.window != null) {
            this.window.update(this.leftPos + 15, this.topPos + 15, 226, 120);
        }
    }

    protected void init() {
        super.init();
        this.desktop.update(this.leftPos + 15, this.topPos + 15, 226, 120);
    }

    protected void repositionElements() {
        super.init();
        this.updateWindow();
        this.desktop.update(this.leftPos + 15, this.topPos + 15, 226, 120);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        float frameTime = this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int displayLeft = this.leftPos + 15;
        int displayTop = this.topPos + 15;
        int displayEnd = displayLeft + 226;
        int displayBottom = displayTop + 120;
        if (this.loading > 0) {
            float time = (20.0f - ((float)this.loading - frameTime)) / 20.0f;
            int loadingBarStart = displayLeft + 63;
            int loadingBarWidth = (int)(100.0f * time);
            graphics.fill(loadingBarStart - 1, displayBottom - 31, loadingBarStart + 100 + 1, displayBottom - 23, -12107714);
            graphics.fill(loadingBarStart, displayBottom - 30, loadingBarStart + loadingBarWidth, displayBottom - 24, -1);
            graphics.drawCenteredString(this.font, Components.GUI_BOOTING, displayLeft + 113, displayBottom - 42, -1);
            graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, displayLeft + 97, displayTop + 23, 0.0f, (float)this.imageHeight, 32, 36, 16, 18, 256, 256);
            return;
        }
        graphics.enableScissor(displayLeft, displayTop, displayEnd, displayBottom);
        this.desktop.render(graphics, mouseX, mouseY, partialTick);
        Window window = this.getOrCreateWindow();
        if (window != null) {
            window.render(graphics, this.font, mouseX, mouseY, frameTime);
        }
        graphics.disableScissor();
    }

    protected void containerTick() {
        if (this.loading > 0) {
            --this.loading;
            return;
        }
        if (this.window != null) {
            this.window.tick();
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.loading > 0) {
            return false;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && event.button() == 0 && this.getFocused().mouseDragged(event, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseScrolled(mouseX, mouseY, deltaX, deltaY)).isPresent()) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.window != null && this.window.getDisplayable().blocksNavigation() && (event.key() == 265 || event.key() == 264 || event.key() == 263 || event.key() == 262)) {
            return true;
        }
        return super.keyPressed(event);
    }

    public void addWidgets(IWidgetGroup group) {
        ScreenAccessor accessor = (ScreenAccessor)((Object)this);
        group.getWidgets().forEach(listener -> {
            accessor.getChildren().add((GuiEventListener)listener);
            if (listener instanceof NarratableEntry) {
                NarratableEntry entry = (NarratableEntry)listener;
                accessor.getNarratables().add(entry);
            }
        });
    }

    public void removeWidgets(IWidgetGroup group) {
        group.getWidgets().forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
    }

    public List<? extends GuiEventListener> children() {
        return super.children();
    }
}

