/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui;

import com.mrcrayfish.furniture.refurbished.client.gui.screen.WorkbenchScreen;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;

public class ClientWorkbenchRecipeIngredientTooltip
implements ClientTooltipComponent {
    private final WorkbenchMenu menu;
    private final StackedIngredient material;
    private final Map<Integer, Integer> counted;
    private ItemStack display = ItemStack.EMPTY;
    private long lastUpdateTime = -1L;

    public ClientWorkbenchRecipeIngredientTooltip(WorkbenchMenu menu, StackedIngredient material, Map<Integer, Integer> counted) {
        this.menu = menu;
        this.material = material;
        this.counted = counted;
    }

    public int getHeight(Font font) {
        return 18;
    }

    public int getWidth(Font font) {
        return 18 + font.width((FormattedText)this.getStack().getDisplayName());
    }

    public void renderImage(Font font, int start, int top, int width, int height, GuiGraphics graphics) {
        ItemStack material = this.getStack().copy();
        material.setCount(this.material.count());
        graphics.renderFakeItem(material, start, top);
        graphics.renderItemDecorations(font, material, start, top);
        MutableComponent name = material.getHoverName().copy().withStyle(ChatFormatting.GRAY);
        graphics.drawString(font, (Component)name, start + 18 + 5, top + 4, -1);
        boolean checked = this.menu.hasMaterials(this.material, this.counted);
        graphics.blit(RenderPipelines.GUI_TEXTURED, WorkbenchScreen.WORKBENCH_TEXTURE, start, top, checked ? 246.0f : 240.0f, 40.0f, 6, 5, 256, 256);
    }

    private ItemStack getStack() {
        long time = Util.getMillis() / 1000L;
        if (this.lastUpdateTime != time) {
            List items = this.material.ingredient().items().toList();
            int index = (int)time % items.size();
            this.display = new ItemStack((Holder)items.get(index));
            this.lastUpdateTime = time;
        }
        return this.display;
    }
}

