/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.electricity.ElectricityRenderer;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchHandler;
import com.mrcrayfish.furniture.refurbished.compat.jei.SyncedRecipes;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ExtractBlockOutlineRenderStateEvent;
import net.neoforged.neoforge.client.event.ExtractLevelRenderStateEvent;
import net.neoforged.neoforge.client.event.FrameGraphSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="refurbished_furniture", value={Dist.CLIENT})
public class NeoForgeClientEvents {
    @SubscribeEvent
    private static void onKeyTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getKeyMapping() == mc.options.keyAttack && mc.player != null && mc.level != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && WrenchHandler.get().onPerformAttack((Level)mc.level)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onRenderLevelStage(RenderLevelStageEvent.AfterLevel event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        mc.renderBuffers().bufferSource().endBatch(ClientServices.PLATFORM.getTelevisionScreenRenderType(CustomSheets.TV_CHANNELS_SHEET));
    }

    @SubscribeEvent
    private static void onDrawHighlight(ExtractBlockOutlineRenderStateEvent event) {
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND)).is((Item)ModItems.WRENCH.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onExtractLevelRenderState(ExtractLevelRenderStateEvent event) {
        ElectricityRenderer.get().extract(event.getCamera());
    }

    @SubscribeEvent
    private static void onSetupFrameGraph(FrameGraphSetupEvent event) {
        ElectricityRenderer.get().setupFramePass(event.getFrameGrapBuilder(), event.getCamera().position());
    }

    @SubscribeEvent
    private static void afterEntities(RenderLevelStageEvent.AfterEntities event) {
        ElectricityRenderer.get().renderPowerableArea(event.getLevelRenderState().cameraRenderState.pos);
    }

    @SubscribeEvent
    private static void afterRenderLevel(RenderLevelStageEvent.AfterLevel event) {
        ElectricityRenderer.get().blitToScreen();
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch(ClientServices.PLATFORM.getTelevisionScreenRenderType(CustomSheets.TV_CHANNELS_SHEET));
    }

    @SubscribeEvent
    public static void onRecipesSynced(RecipesReceivedEvent event) {
        if (Services.PLATFORM.isModLoaded("jei")) {
            SyncedRecipes.setMap(event.getRecipeMap());
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        SyncedRecipes.reset();
    }
}

