/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.block.StoveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Util;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends ElectricityModuleLootBlockEntity
implements IProcessingBlock,
IHeatingSource,
IPowerSwitch,
IHomeControlDevice,
Nameable,
StackedContentsCompatible {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    public static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROGRESS_1 = 2;
    public static final int DATA_PROGRESS_2 = 3;
    public static final int DATA_PROGRESS_3 = 4;
    public static final int DATA_TOTAL_PROGRESS_1 = 5;
    public static final int DATA_TOTAL_PROGRESS_2 = 6;
    public static final int DATA_TOTAL_PROGRESS_3 = 7;
    protected final ImmutableList<CookingSpace> spaces;
    protected boolean enabled;
    protected boolean processing;
    protected int totalProcessingTime;
    protected int processingTime;
    protected WeakReference<ICookingBlock> cookingBlockRef;
    protected boolean sync;
    @Nullable
    protected StoveContainer container;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.getCookingSpaces((int)0).bakingTime, value -> {});
        builder.add(3, () -> this.getCookingSpaces((int)1).bakingTime, value -> {});
        builder.add(4, () -> this.getCookingSpaces((int)2).bakingTime, value -> {});
        builder.add(5, () -> this.getCookingSpaces((int)0).totalBakingTime, value -> {});
        builder.add(6, () -> this.getCookingSpaces((int)1).totalBakingTime, value -> {});
        builder.add(7, () -> this.getCookingSpaces((int)2).totalBakingTime, value -> {});
    });

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.STOVE.get(), pos, state);
    }

    public StoveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 6);
        this.spaces = (ImmutableList)Util.make(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)3);
            IntStream.range(0, 3).forEach(i -> builder.add((Object)new CookingSpace(i, i + 3, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.OVEN_BAKING.get()))));
            return builder.build();
        });
    }

    private CookingSpace getCookingSpaces(int index) {
        return (CookingSpace)this.spaces.get(index);
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.DOWN) {
            return OUTPUT_SLOTS;
        }
        return INPUT_SLOTS;
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public boolean requiresEnergy() {
        return false;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            time = block.getTimeToCook();
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        boolean changed = false;
        if (this.processingTime == 0 && time > this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStartCooking();
            }
            this.processing = true;
            this.sync();
            changed = true;
        } else if (time == 0 && time < this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStopCooking();
            }
            this.processing = false;
            this.sync();
            changed = true;
        }
        if (this.processingTime != time) {
            this.processingTime = time;
            changed = true;
        }
        if (changed) {
            this.setChanged();
        }
    }

    @Override
    public void onCompleteProcess() {
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            block.onCompleteCooking();
            this.processing = false;
            this.setChanged();
            this.sync();
        }
    }

    @Override
    public boolean canProcess() {
        if (!this.isNodePowered() || !this.enabled) {
            return false;
        }
        ICookingBlock block = this.getCookingBlock();
        return block != null && block.canCook();
    }

    @Nullable
    public ICookingBlock getCookingBlock() {
        ServerLevel serverLevel;
        BlockEntity entity;
        Level level;
        if (this.cookingBlockRef != null) {
            ICookingBlock block = (ICookingBlock)this.cookingBlockRef.get();
            if (block != null && !block.getBlockEntity().isRemoved()) {
                return block;
            }
            this.cookingBlockRef = null;
        }
        if ((level = this.level) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getBlockEntity(this.worldPosition.above())) instanceof ICookingBlock) {
            ICookingBlock cookingBlock = (ICookingBlock)entity;
            this.cookingBlockRef = new WeakReference<ICookingBlock>(cookingBlock);
            return cookingBlock;
        }
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StoveBlockEntity stove) {
        stove.processTick();
        stove.spaces.forEach(IProcessingBlock::processTick);
        if (stove.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)stove, BlockEntity::getUpdateTag);
            stove.sync = false;
        }
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "stove", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return Services.MENU.createStoveMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)StoveBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, center.x, center.y, center.z, (SoundEvent)ModSounds.BLOCK_STOVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)StoveBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, center.x, center.y, center.z, (SoundEvent)ModSounds.BLOCK_STOVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)StoveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public boolean isHeating() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)StoveBlock.LIT) && (Boolean)state.getValue((Property)StoveBlock.LIT) != false;
    }

    public void onDestroyed(BlockPos pos) {
        BlockEntity blockEntity;
        Level level;
        if (this.isProcessing() && (level = this.getLevel()) != null && (blockEntity = level.getBlockEntity(pos.above())) instanceof ICookingBlock) {
            ICookingBlock cooking = (ICookingBlock)blockEntity;
            cooking.onStopCooking();
        }
    }

    public void onNeighbourChanged() {
        this.container = null;
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.container = null;
    }

    public WorldlyContainer getContainer() {
        if (this.container == null) {
            BlockEntity blockEntity;
            ICookingBlock cookingBlock = this.getCookingBlock();
            if (cookingBlock != null && (blockEntity = cookingBlock.getBlockEntity()) instanceof Container) {
                Container cookingContainer = (Container)blockEntity;
                this.container = new StoveContainer(this, cookingBlock, cookingContainer);
            }
        } else if (!this.container.isValid()) {
            this.container = null;
        }
        return this.container != null ? this.container : this;
    }

    protected void sync() {
        this.sync = true;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read("Processing", (Codec)Codec.BOOL).ifPresent(value -> {
            this.processing = value;
        });
        input.getInt("ProcessingTime").ifPresent(value -> {
            this.processingTime = value;
        });
        input.getInt("TotalProcessingTime").ifPresent(value -> {
            this.totalProcessingTime = value;
        });
        input.read("Enabled", (Codec)Codec.BOOL).ifPresent(value -> {
            this.enabled = value;
        });
        this.readCookingSpaces(input);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("Processing", (Codec)Codec.BOOL, (Object)this.processing);
        output.putInt("TotalProcessingTime", this.totalProcessingTime);
        output.putInt("ProcessingTime", this.processingTime);
        output.store("Enabled", (Codec)Codec.BOOL, (Object)this.enabled);
        this.writeCookingSpaces(output);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)StoveBlock.POWERED) && (Boolean)state.getValue((Property)StoveBlock.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)StoveBlock.POWERED)) {
            state = (BlockState)state.setValue((Property)StoveBlock.POWERED, (Comparable)Boolean.valueOf(powered));
        }
        if (state.hasProperty((Property)StoveBlock.LIT)) {
            state = (BlockState)state.setValue((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(powered && this.enabled));
        }
        this.level.setBlock(this.worldPosition, state, 3);
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.isNodePowered() && this.enabled)), 3);
        this.setChanged();
        this.sync();
    }

    @Override
    public BlockPos getDevicePos() {
        return this.worldPosition;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.setChanged();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.setChanged();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    public Component getDeviceName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return this.getDefaultName();
    }

    private void writeCookingSpaces(ValueOutput output) {
        ValueOutput.ValueOutputList list = output.childrenList("CookingSpaces");
        for (int i = 0; i < this.spaces.size(); ++i) {
            ValueOutput spaceOutput = list.addChild();
            spaceOutput.putInt("Position", i);
            ((CookingSpace)this.spaces.get(i)).writeToOutput(spaceOutput);
        }
        if (list.isEmpty()) {
            output.discard("CookingSpaces");
        }
    }

    private void readCookingSpaces(ValueInput input) {
        input.childrenList("CookingSpaces").ifPresent(list -> list.forEach(spaceInput -> {
            int position = spaceInput.getIntOr("Position", -1);
            if (position >= 0 && position < this.spaces.size()) {
                ((CookingSpace)this.spaces.get(position)).readFromInput((ValueInput)spaceInput);
            }
        }));
    }

    public void fillStackedContents(StackedItemContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.onDestroyed(pos);
    }

    protected class CookingSpace
    implements IProcessingBlock {
        private final int inputIndex;
        private final int outputIndex;
        private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> inputRecipeCache;
        private int totalBakingTime;
        private int bakingTime;

        public CookingSpace(int inputIndex, int outputIndex, RecipeType<? extends ProcessingRecipe> recipeType) {
            this.inputIndex = inputIndex;
            this.outputIndex = outputIndex;
            this.inputRecipeCache = RecipeManager.createCheck(recipeType);
        }

        @Override
        public int getEnergy() {
            return 0;
        }

        @Override
        public void addEnergy(int energy) {
        }

        @Override
        public boolean requiresEnergy() {
            return false;
        }

        @Override
        public int retrieveEnergy(boolean simulate) {
            return 0;
        }

        @Override
        public int updateAndGetTotalProcessingTime() {
            int time = 0;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe();
            if (optional.isPresent()) {
                time = Math.max(time, optional.get().getTime());
            }
            if (this.totalBakingTime != time) {
                this.totalBakingTime = time;
                StoveBlockEntity.this.setChanged();
            }
            return this.totalBakingTime;
        }

        @Override
        public int getTotalProcessingTime() {
            return this.totalBakingTime;
        }

        @Override
        public int getProcessingTime() {
            return this.bakingTime;
        }

        @Override
        public void setProcessingTime(int time) {
            this.bakingTime = time;
            StoveBlockEntity.this.setChanged();
        }

        @Override
        public void onCompleteProcess() {
            ItemStack stack = StoveBlockEntity.this.getItem(this.inputIndex);
            if (!stack.isEmpty()) {
                ItemStack remainingItem = stack.getMaxStackSize() == 1 ? stack.getItem().getCraftingRemainder() : ItemStack.EMPTY;
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                Level level = Objects.requireNonNull(StoveBlockEntity.this.getLevel());
                ItemStack result = optional.map(recipe -> recipe.assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
                stack.shrink(1);
                if (!result.isEmpty()) {
                    ItemStack copy = result.copy();
                    ItemStack outputStack = StoveBlockEntity.this.getItem(this.outputIndex);
                    if (outputStack.isEmpty()) {
                        StoveBlockEntity.this.setItem(this.outputIndex, copy);
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)copy, (ItemStack)outputStack) && outputStack.getCount() + copy.getCount() <= outputStack.getMaxStackSize()) {
                        outputStack.grow(copy.getCount());
                        StoveBlockEntity.this.setChanged();
                    }
                    if (!remainingItem.isEmpty()) {
                        if (stack.isEmpty()) {
                            StoveBlockEntity.this.setItem(this.inputIndex, remainingItem.copy());
                        } else {
                            Vec3 pos = StoveBlockEntity.this.getBlockPos().getCenter().add(0.0, 0.5, 0.0);
                            Containers.dropItemStack((Level)StoveBlockEntity.this.level, (double)pos.x, (double)pos.y, (double)pos.z, (ItemStack)remainingItem.copy());
                        }
                    }
                }
            }
        }

        @Override
        public boolean canProcess() {
            if (!StoveBlockEntity.this.isNodePowered() || !StoveBlockEntity.this.enabled) {
                return false;
            }
            ItemStack stack = StoveBlockEntity.this.getItem(this.inputIndex);
            if (!stack.isEmpty()) {
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                if (optional.isEmpty()) {
                    return false;
                }
                Level level = Objects.requireNonNull(StoveBlockEntity.this.getLevel());
                ItemStack result = optional.get().assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)level.registryAccess());
                return this.canOutput(result);
            }
            return false;
        }

        private boolean canOutput(ItemStack result) {
            if (result.isEmpty()) {
                return false;
            }
            ItemStack stack = StoveBlockEntity.this.getItem(this.outputIndex);
            return stack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)stack) && stack.getCount() + result.getCount() <= stack.getMaxStackSize();
        }

        private Optional<? extends ProcessingRecipe> getRecipe() {
            Level level;
            ItemStack stack = StoveBlockEntity.this.getItem(this.inputIndex);
            if (!stack.isEmpty() && (level = StoveBlockEntity.this.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return this.inputRecipeCache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), serverLevel).map(RecipeHolder::value);
            }
            return Optional.empty();
        }

        public void writeToOutput(ValueOutput output) {
            output.putInt("CookingTime", this.bakingTime);
            output.putInt("TotalCookingTime", this.totalBakingTime);
        }

        public void readFromInput(ValueInput input) {
            input.getInt("CookingTime").ifPresent(value -> {
                this.bakingTime = value;
            });
            input.getInt("TotalCookingTime").ifPresent(value -> {
                this.totalBakingTime = value;
            });
        }
    }
}

