/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.MailboxBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.blockentity.RowedStorageBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class MailboxBlockEntity
extends RowedStorageBlockEntity
implements INameable {
    protected UUID uuid = UUID.randomUUID();
    protected WeakReference<Mailbox> mailboxRef;

    public MailboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MAIL_BOX.get(), pos, state, (Integer)Config.SERVER.mailing.mailboxInventoryRows.get());
    }

    public UUID getId() {
        return this.uuid;
    }

    public void regenerateId() {
        this.uuid = UUID.randomUUID();
        this.setChanged();
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (player == null) {
            return;
        }
        DeliveryService.get(player.level().getServer()).ifPresent(service -> {
            if (!service.renameMailbox((Player)player, (Level)player.level(), this.worldPosition, name)) {
                player.sendSystemMessage((Component)Utils.translation("gui", "rename_mailbox_failed", new Object[0]));
            }
        });
    }

    public boolean deliverItem(ItemStack mail) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) {
                this.setItem(i, mail);
                this.setUnchecked();
                return true;
            }
            if (stack.getCount() == stack.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)mail) || stack.getCount() + mail.getCount() > stack.getMaxStackSize()) continue;
            stack.grow(mail.getCount());
            this.setChanged();
            this.setUnchecked();
            return true;
        }
        return false;
    }

    public void setUnchecked() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MailboxBlock.ENABLED, (Comparable)Boolean.valueOf(true)), 3);
    }

    public Optional<Mailbox> getMailbox() {
        ServerLevel serverLevel;
        Optional<DeliveryService> optional;
        Level level = this.level;
        if (level instanceof ServerLevel && (optional = DeliveryService.get((serverLevel = (ServerLevel)level).getServer())).isPresent()) {
            DeliveryService service;
            Mailbox mailbox;
            if (this.mailboxRef != null) {
                Mailbox mailbox2 = (Mailbox)this.mailboxRef.get();
                if (mailbox2 != null && !mailbox2.removed()) {
                    return Optional.of(mailbox2);
                }
                this.mailboxRef = null;
            }
            if ((mailbox = (service = optional.get()).getOrCreateMailBox(this)) != null) {
                this.mailboxRef = new WeakReference<Mailbox>(mailbox);
                return Optional.of(mailbox);
            }
        }
        return Optional.empty();
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "mailbox", new Object[0]);
    }

    public Component getDisplayName() {
        String customName;
        Optional<String> customNameOptional;
        Optional<Mailbox> mailboxOptional = this.getMailbox();
        if (mailboxOptional.isPresent() && (customNameOptional = mailboxOptional.get().customName()).isPresent() && !(customName = customNameOptional.get()).isBlank()) {
            return Component.literal((String)customName);
        }
        return super.getDisplayName();
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read("UUID", UUIDUtil.CODEC).ifPresentOrElse(uuid -> {
            this.uuid = uuid;
        }, () -> {
            this.uuid = UUID.randomUUID();
        });
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("UUID", UUIDUtil.CODEC, (Object)this.uuid);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<DeliveryService> optional = DeliveryService.get(serverLevel.getServer());
            optional.ifPresent(service -> service.removeMailbox(this.uuid));
            this.mailboxRef = null;
        }
    }
}

