/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends BlockEntity
implements WorldlyContainer {
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final NonNullList<ItemStack> fuel = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> cooking = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final ImmutableList<CookingSpace> spaces;
    protected final RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> recipeCache;
    protected final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> campfireCookingCache;
    private int remainingFuel;
    private float storedExperience;

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.GRILL.get(), pos, state, (RecipeType<? extends ProcessingRecipe.Item>)((RecipeType)ModRecipeTypes.GRILL_COOKING.get()));
    }

    protected GrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state);
        this.recipeCache = RecipeManager.createCheck(recipeType);
        this.campfireCookingCache = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
        this.spaces = (ImmutableList)Util.make(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.cooking.size());
            IntStream.range(0, this.cooking.size()).forEach(i -> builder.add((Object)new CookingSpace(i, this)));
            return builder.build();
        });
    }

    public CookingSpace getCookingSpace(int position) {
        return (CookingSpace)this.spaces.get(position);
    }

    public NonNullList<ItemStack> getCookingItems() {
        return this.cooking;
    }

    public NonNullList<ItemStack> getFuelItems() {
        return this.fuel;
    }

    public boolean addCookingItem(ItemStack stack, int position, int rotation) {
        Optional<? extends ProcessingRecipe> optional;
        if (((ItemStack)this.cooking.get(position)).isEmpty() && (optional = this.getRecipe(stack)).isPresent()) {
            ProcessingRecipe recipe = optional.get();
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.cooking.set(position, (Object)copy);
            ((CookingSpace)this.spaces.get(position)).update(recipe.getTime(), 0.0f, rotation);
            this.syncCookingSpace(position);
            this.playPlaceSound((CookingSpace)this.spaces.get(position), false, 0.85f);
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean addFuel(ItemStack stack) {
        if (stack.getItem() == Items.CHARCOAL) {
            for (int i = 0; i < this.fuel.size(); ++i) {
                if (!((ItemStack)this.fuel.get(i)).isEmpty()) continue;
                ItemStack fuel = stack.copy();
                fuel.setCount(1);
                this.fuel.set(i, (Object)fuel);
                this.syncFuel();
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public void flipItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((ItemStack)this.cooking.get(position)).isEmpty()) {
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isHalfCooked()) {
                space.flip();
                this.sendFlipAnimationToPlayers(position);
                this.syncCookingSpace(position);
                this.setChanged();
            } else if (space.isFullyCooked()) {
                this.removeCookingItem(position);
            }
        }
    }

    private void sendFlipAnimationToPlayers(int position) {
        Level level = Objects.requireNonNull(this.level);
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = this.getBlockPos();
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageFlipAnimation(pos, position)));
        }
    }

    public boolean flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.cooking.get(i)).isEmpty() || !((CookingSpace)this.spaces.get(i)).isHalfCooked()) continue;
            this.flipItem(i);
            return true;
        }
        return false;
    }

    public void removeCookingItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((ItemStack)this.cooking.get(position)).isEmpty()) {
            double posX = (double)this.worldPosition.getX() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.worldPosition.getY() + 1.0;
            double posZ = (double)this.worldPosition.getZ() + 0.3 + 0.4 * (double)(position / 2);
            ItemEntity entity = new ItemEntity(this.level, posX, posY + 0.1, posZ, ((ItemStack)this.cooking.get(position)).copy());
            this.level.addFreshEntity((Entity)entity);
            this.cooking.set(position, (Object)ItemStack.EMPTY);
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isFullyCooked()) {
                this.spawnExperience(posX, posY, posZ, space.getExperience());
            }
            space.update(0, 0.0f, 0);
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this::writeCookingItems);
            this.setChanged();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        boolean canCook = grill.canCook();
        if (grill.remainingFuel == 0 && canCook) {
            for (int i = grill.fuel.size() - 1; i >= 0; --i) {
                ItemStack fuel = (ItemStack)grill.fuel.get(i);
                if (fuel.isEmpty()) continue;
                grill.remainingFuel = level.fuelValues().burnDuration(fuel);
                grill.fuel.set(i, (Object)ItemStack.EMPTY);
                grill.setChanged();
                BlockEntityHelper.sendCustomUpdate((BlockEntity)grill, output -> {
                    grill.writeFuel((ValueOutput)output);
                    grill.writeRemainingFuel((ValueOutput)output);
                });
                break;
            }
        }
        if (canCook && grill.remainingFuel > 0) {
            grill.cookItems();
            --grill.remainingFuel;
            grill.setChanged();
            if (grill.remainingFuel == 0) {
                BlockEntityHelper.sendCustomUpdate((BlockEntity)grill, grill::writeRemainingFuel);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        grill.spawnParticles();
        grill.spaces.forEach(space -> {
            AudioManager.get().playLevelAudio((ILevelAudio)space);
            FlipAnimation animation = space.getAnimation();
            boolean wasPlaying = animation.isPlaying();
            animation.tick();
            if (wasPlaying && !animation.isPlaying()) {
                grill.playPlaceSound((CookingSpace)space, true, 1.0f);
            }
        });
    }

    private boolean canCook() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((ItemStack)this.cooking.get(i)).isEmpty() || !space.canCook()) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean changed = false;
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space;
            if (((ItemStack)this.cooking.get(i)).isEmpty() || !(space = (CookingSpace)this.spaces.get(i)).canCook()) continue;
            space.cook();
            if (!space.isCooked()) continue;
            if (space.isFlipped()) {
                Level level = Objects.requireNonNull(this.level);
                Optional<? extends ProcessingRecipe> optional = this.getRecipe((ItemStack)this.cooking.get(i));
                if (optional.isPresent()) {
                    this.cooking.set(i, (Object)optional.get().getResult().copy());
                }
            }
            this.syncCookingSpace(i);
            changed = true;
        }
        if (changed) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this::writeCookingItems);
            this.setChanged();
        }
    }

    private void spawnParticles() {
        Level level = this.getLevel();
        if (level != null) {
            if (this.isCooking()) {
                double posX = (double)this.worldPosition.getX() + 0.2 + 0.6 * level.random.nextDouble();
                double posY = (double)this.worldPosition.getY() + 0.85;
                double posZ = (double)this.worldPosition.getZ() + 0.2 + 0.6 * level.random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < this.cooking.size(); ++i) {
                CookingSpace space;
                if (((ItemStack)this.cooking.get(i)).isEmpty()) continue;
                if (level.random.nextFloat() < 0.1f && (space = (CookingSpace)this.spaces.get(i)).isHalfCooked()) {
                    Vec3 spacePos = space.getWorldPosition();
                    for (int j = 0; j < 4; ++j) {
                        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, spacePos.x, spacePos.y, spacePos.z, 0.0, 0.0, 0.0);
                    }
                }
                space = (CookingSpace)this.spaces.get(i);
                if (this.remainingFuel <= 0 || !space.canCook() || space.isCooked() || space.getAnimation().isPlaying()) continue;
                Vec3 spacePos = space.getWorldPosition();
                spacePos = spacePos.add(0.05 * level.random.nextGaussian(), 0.0, 0.05 * level.random.nextGaussian());
                this.spawnSteam(level, spacePos.x, spacePos.y, spacePos.z);
            }
        }
    }

    public void spawnSteam(Level level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.worldPosition.above(2))) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.worldPosition.above(3))) {
            ySpeed = 0.1;
        }
        level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(Level level, BlockPos pos) {
        BlockPos start = this.worldPosition.above();
        while (start.getY() < pos.getY()) {
            if (!level.getBlockState(start).isAir()) {
                return false;
            }
            start = start.above();
        }
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof RangeHoodBlock) {
            return (Boolean)state.getValue((Property)RangeHoodBlock.POWERED);
        }
        return false;
    }

    private boolean isCooking() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((ItemStack)this.cooking.get(i)).isEmpty() || !space.canCook() && !space.isHalfCooked()) continue;
            return this.remainingFuel > 0;
        }
        return false;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(ItemStack stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipeFromCache(this.recipeCache, stack);
        if (((Boolean)Config.SERVER.recipes.inheritCampfireRecipes.get()).booleanValue()) {
            optional = optional.isEmpty() ? this.getCookingRecipeFromCache(this.campfireCookingCache, stack) : optional;
        }
        return optional;
    }

    private Optional<? extends ProcessingRecipe> getRecipeFromCache(RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> cache, ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return cache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), serverLevel).map(RecipeHolder::value);
        }
        return Optional.empty();
    }

    private Optional<? extends ProcessingRecipe> getCookingRecipeFromCache(RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> cache, ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return cache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), serverLevel).map(RecipeHolder::value).map(recipe -> ProcessingRecipe.Item.fromCookingRecipe(recipe, this.level.registryAccess()));
        }
        return Optional.empty();
    }

    public int getContainerSize() {
        return this.fuel.size() + this.cooking.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.fuel) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.cooking) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        if (index - this.fuel.size() >= 0) {
            return (ItemStack)this.cooking.get(index - this.fuel.size());
        }
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            ItemStack result = ContainerHelper.removeItem(this.cooking, (int)(index -= this.fuel.size()), (int)count);
            if (!result.isEmpty()) {
                this.setChanged();
            }
            if (((ItemStack)this.cooking.get(index)).isEmpty()) {
                CookingSpace space = (CookingSpace)this.spaces.get(index);
                if (space.isFullyCooked()) {
                    double posX = (double)this.worldPosition.getX() + 0.3 + 0.4 * (double)(index % 2);
                    double posY = (double)this.worldPosition.getY() + 1.0;
                    double posZ = (double)this.worldPosition.getZ() + 0.3 + 0.4 * (double)(index / 2);
                    this.spawnExperience(posX, posY, posZ, space.getExperience());
                }
                space.update(0, 0.0f, 0);
            }
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, output -> {
                this.writeCookingItems((ValueOutput)output);
                this.writeFuel((ValueOutput)output);
            });
            return result;
        }
        ItemStack result = ContainerHelper.removeItem(this.fuel, (int)index, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        this.syncFuel();
        return result;
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (index - this.fuel.size() >= 0) {
            return ContainerHelper.takeItem(this.cooking, (int)(index - this.fuel.size()));
        }
        return ContainerHelper.takeItem(this.fuel, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        NonNullList<ItemStack> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            index -= this.fuel.size();
            inventory = this.cooking;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            if (optional.isPresent()) {
                ProcessingRecipe recipe = optional.get();
                ((CookingSpace)this.spaces.get(index)).update(recipe.getTime(), 0.0f, 0);
                this.syncCookingSpace(index);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, output -> {
            this.writeCookingItems((ValueOutput)output);
            this.writeFuel((ValueOutput)output);
        });
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void clearContent() {
        this.fuel.clear();
        this.cooking.clear();
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        BlockEntityHelper.loadItems("Grill", input, this.cooking);
        BlockEntityHelper.loadItems("Fuel", input, this.fuel);
        input.getInt("RemainingFuel").ifPresent(value -> {
            this.remainingFuel = value;
        });
        input.read("StoredExperience", (Codec)Codec.FLOAT).ifPresent(value -> {
            this.storedExperience = value.floatValue();
        });
        this.readCookingSpaces(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeCookingItems(output);
        this.writeFuel(output);
        this.writeRemainingFuel(output);
        this.writeCookingSpaces(output);
        output.store("StoredExperience", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.storedExperience));
    }

    private void writeCookingItems(ValueOutput output) {
        BlockEntityHelper.saveItems("Grill", output, this.cooking);
    }

    private void writeFuel(ValueOutput output) {
        BlockEntityHelper.saveItems("Fuel", output, this.fuel);
    }

    private void writeRemainingFuel(ValueOutput output) {
        output.putInt("RemainingFuel", this.remainingFuel);
    }

    private void writeCookingSpaces(ValueOutput output) {
        this.writeCookingSpaces(output, -1);
    }

    private void writeCookingSpaces(ValueOutput output, int position) {
        ValueOutput.ValueOutputList list = output.childrenList("CookingSpaces");
        if (position >= 0 && position < this.spaces.size()) {
            ValueOutput spaceOutput = list.addChild();
            spaceOutput.putInt("Position", position);
            ((CookingSpace)this.spaces.get(position)).writeToTag(spaceOutput);
        } else if (position == -1) {
            for (int i = 0; i < this.spaces.size(); ++i) {
                ValueOutput spaceOutput = list.addChild();
                spaceOutput.putInt("Position", i);
                ((CookingSpace)this.spaces.get(i)).writeToTag(spaceOutput);
            }
        }
        if (list.isEmpty()) {
            output.discard("CookingSpaces");
        }
    }

    private void readCookingSpaces(ValueInput input) {
        input.childrenList("CookingSpaces").ifPresent(list -> list.forEach(spaceInput -> {
            int position = spaceInput.getIntOr("Position", -1);
            if (position >= 0 && position < this.spaces.size()) {
                ((CookingSpace)this.spaces.get(position)).readFromInput((ValueInput)spaceInput);
            }
        }));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public int[] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        if (!this.getItem(index).isEmpty()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.getRecipe(stack).isPresent();
        }
        return stack.getItem() == Items.COAL || stack.getItem() == Items.CHARCOAL;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index - this.fuel.size() >= 0 && ((CookingSpace)this.spaces.get(index -= this.fuel.size())).isFullyCooked()) {
            return this.getRecipe(stack).isEmpty();
        }
        return false;
    }

    private void playPlaceSound(CookingSpace space, boolean client, float pitch) {
        Level level = Objects.requireNonNull(this.level);
        Vec3 pos = space.getWorldPosition();
        if (client) {
            level.playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch, false);
            return;
        }
        level.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    private void syncCookingSpace(int position) {
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, output -> {
            this.writeCookingItems((ValueOutput)output);
            this.writeCookingSpaces((ValueOutput)output, position);
        });
    }

    private void syncFuel() {
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this::writeFuel);
    }

    private void spawnExperience(double x, double y, double z, float exp) {
        Level level;
        this.storedExperience += Math.max(exp, 0.0f);
        if ((float)Mth.floor((float)this.storedExperience) >= 1.0f && (level = this.level) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int amount = Mth.floor((float)this.storedExperience);
            ExperienceOrb.award((ServerLevel)level2, (Vec3)new Vec3(x, y, z), (int)amount);
            this.storedExperience = Math.max(this.storedExperience - (float)amount, 0.0f);
        }
    }

    public void playFlipAnimation(int position) {
        if (Objects.requireNonNull(this.level).isClientSide() && position >= 0 && position < this.spaces.size()) {
            ((CookingSpace)this.spaces.get(position)).getAnimation().play();
        }
    }

    public static class CookingSpace
    implements ILevelAudio {
        public static final double MAX_AUDIO_DISTANCE = Mth.square((int)8);
        private final int index;
        private final GrillBlockEntity grill;
        private int cookingTime = 0;
        private int totalCookingTime = 0;
        private boolean flipped = false;
        private float experience = 0.0f;
        private int rotation = 0;
        private FlipAnimation animation;

        public CookingSpace(int index, GrillBlockEntity grill) {
            this.index = index;
            this.grill = grill;
        }

        public boolean isFlipped() {
            return this.flipped;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void cook() {
            if (this.cookingTime < this.totalCookingTime) {
                ++this.cookingTime;
            }
        }

        public boolean isCooked() {
            return this.cookingTime == this.totalCookingTime;
        }

        public boolean isHalfCooked() {
            return !this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean isFullyCooked() {
            return this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean canCook() {
            return this.cookingTime < this.totalCookingTime;
        }

        public void update(int cookTime, float experience, int rotation) {
            this.cookingTime = 0;
            this.totalCookingTime = cookTime / 2;
            this.flipped = false;
            this.experience = experience;
            this.rotation = rotation;
        }

        public void flip() {
            if (!this.flipped) {
                this.flipped = true;
                this.cookingTime = 0;
            }
        }

        public Vec3 getWorldPosition() {
            BlockPos pos = this.grill.worldPosition;
            double x = (double)pos.getX() + 0.3 + 0.4 * (double)(this.index % 2);
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.3 + 0.4 * (double)(this.index / 2);
            return new Vec3(x, y, z);
        }

        public void writeToTag(ValueOutput output) {
            output.putInt("CookingTime", this.cookingTime);
            output.putInt("TotalCookingTime", this.totalCookingTime);
            output.store("Flipped", (Codec)Codec.BOOL, (Object)this.flipped);
            output.store("Experience", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.experience));
            output.putInt("Rotation", this.rotation);
        }

        public void readFromInput(ValueInput input) {
            input.getInt("CookingTime").ifPresent(value -> {
                this.cookingTime = value;
            });
            input.getInt("TotalCookingTime").ifPresent(value -> {
                this.totalCookingTime = value;
            });
            input.read("Flipped", (Codec)Codec.BOOL).ifPresent(value -> {
                this.flipped = value;
            });
            input.read("Experience", (Codec)Codec.FLOAT).ifPresent(value -> {
                this.experience = value.floatValue();
            });
            input.getInt("Rotation").ifPresent(value -> {
                this.rotation = value;
            });
        }

        public FlipAnimation getAnimation() {
            if (this.animation == null) {
                this.animation = new FlipAnimation();
            }
            return this.animation;
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
        }

        @Override
        public SoundSource getSource() {
            return SoundSource.BLOCKS;
        }

        @Override
        public Vec3 getAudioPosition() {
            return this.getWorldPosition();
        }

        @Override
        public boolean canPlayAudio() {
            return !this.grill.isRemoved() && this.grill.remainingFuel > 0 && !((ItemStack)this.grill.cooking.get(this.index)).isEmpty() && (!this.isCooked() || this.isHalfCooked());
        }

        @Override
        public float getAudioVolume() {
            return (this.canCook() && !this.isCooked() || this.isHalfCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
        }

        @Override
        public float getAudioPitch() {
            return this.isHalfCooked() ? 0.8f : 1.0f;
        }

        @Override
        public double getAudioRadiusSqr() {
            return MAX_AUDIO_DISTANCE;
        }

        @Override
        public int getAudioHash() {
            return Objects.hash(this.grill.worldPosition, this.index);
        }

        @Override
        public boolean isAudioEqual(ILevelAudio other) {
            return other == this;
        }
    }
}

