/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicContainerCounter;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class BasicLootBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    protected final int[] slots;
    protected final int containerSize;
    protected NonNullList<ItemStack> items;
    protected final BasicContainerCounter tracker = new BasicContainerCounter(this);

    public BasicLootBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize) {
        super(type, pos, state);
        this.items = NonNullList.withSize((int)containerSize, (Object)ItemStack.EMPTY);
        this.slots = IntStream.range(0, containerSize).toArray();
        this.containerSize = containerSize;
        this.initItemHandler();
    }

    public abstract boolean isMatchingContainerMenu(AbstractContainerMenu var1);

    public int getContainerSize() {
        return this.containerSize;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.trySaveLootTable(output)) {
            ContainerHelper.saveAllItems((ValueOutput)output, this.items, (boolean)false);
        }
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(input)) {
            ContainerHelper.loadAllItems((ValueInput)input, this.items);
        }
    }

    public int[] getSlotsForFace(Direction direction) {
        return this.slots;
    }

    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return this.isSlotInsertable(slotIndex);
    }

    public boolean canPlaceItemThroughFace(int slotIndex, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(slotIndex, stack);
    }

    public boolean canTakeItemThroughFace(int slotIndex, ItemStack stack, Direction direction) {
        return this.canTakeItem((Container)this, slotIndex, stack);
    }

    protected boolean isSlotInsertable(int slotIndex) {
        ItemStack target = this.getItem(slotIndex);
        return target.isEmpty() || target.getCount() < target.getMaxStackSize() && target.getCount() < this.getMaxStackSize();
    }

    public void startOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.tracker.incrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.tracker.decrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateOpenerCount() {
        if (!this.remove) {
            this.tracker.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void onOpen(Level level, BlockPos pos, BlockState state) {
    }

    public void onClose(Level level, BlockPos pos, BlockState state) {
    }

    public void initItemHandler() {
        if (Services.PLATFORM.getPlatform().isForge()) {
            Services.BLOCK_ENTITY.createForgeSidedWrapper(this, Direction.UP);
        }
    }

    public void reviveCaps() {
        if (Services.PLATFORM.getPlatform().isForge()) {
            Services.BLOCK_ENTITY.reviveForgeCapabilities((BlockEntity)this);
            Services.BLOCK_ENTITY.createForgeSidedWrapper(this, Direction.UP);
        }
    }
}

