#version 330 compatibility

uniform sampler2D DiffuseSampler0;

in vec2 texCoord;
out vec4 fragColor;

const vec3 AvgLumin = vec3(0.5, 0.5, 0.5);
const vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);
const float intensity = 0.0075;

vec3 BSC(vec3 color, float brt, float sat, float con) {
    vec3 brtColor = color * brt;
    vec3 intensity2 = vec3(dot(brtColor, LumCoeff));
    vec3 satColor = mix(intensity2, brtColor, sat);
    vec3 conColor = mix(AvgLumin, satColor, con);

    return conColor;
}

void main() {
    fragColor = texture(DiffuseSampler0, texCoord);

    float r_channel = texture(DiffuseSampler0, texCoord * (1 + intensity)).r;
    float g_channel = fragColor.g;
    float b_channel = texture(DiffuseSampler0, texCoord * (1 - intensity)).b;

    fragColor.rgb = vec3(r_channel, g_channel, b_channel);
    fragColor.rgb = BSC(fragColor.rgb, 1.0, 1.0, 1.25);
}
