/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.version.PermissionWrapper;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @Inject(method={"placeNewPlayer"}, at={@At(value="TAIL")})
    private void sendSuspendedInfoOnJoin(CallbackInfo ci, @Local(argsOnly=true) ServerPlayer player) {
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        int count = tickHandler.getTickingEntries().size();
        if (count > 0) {
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            Component message = messageHandler.generateSuspendedInfo((Player)player);
            int permissionLevel = Config.minPermissionLevelForMessages;
            if (permissionLevel < 0) {
                return;
            }
            if (PermissionWrapper.hasPermission((Player)player, permissionLevel)) {
                player.sendSystemMessage(message, false);
            }
        }
    }
}

