/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.registry;

import com.ametrinstudios.ametrin.world.block.helper.BlockBehaviourPropertiesHelper;
import com.ametrinstudios.ametrin.world.block.helper.BlockRegisterHelper;
import com.barion.block_variants.BVUtil;
import com.barion.block_variants.BlockVariants;
import com.barion.block_variants.block.StrippableFenceBlock;
import com.barion.block_variants.block.StrippableFenceGateBlock;
import com.barion.block_variants.block.StrippableSlabBlock;
import com.barion.block_variants.block.StrippableStairBlock;
import com.barion.block_variants.block.StrippableWallBlock;
import com.barion.block_variants.registry.BVItems;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BVBlocks {
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"block_variants");
    private static final Item.Properties DEFAULT_ITEM_PROPERTIES = new Item.Properties();
    private static final Item.Properties fireResistanceItemProperties = new Item.Properties().fireResistant();
    public static final DeferredBlock<WallBlock> POLISHED_GRANITE_WALL;
    public static final DeferredBlock<WallBlock> POLISHED_DIORITE_WALL;
    public static final DeferredBlock<WallBlock> POLISHED_ANDESITE_WALL;
    public static final DeferredBlock<WallBlock> STONE_WALL;
    public static final DeferredBlock<StairBlock> SMOOTH_STONE_STAIRS;
    public static final DeferredBlock<WallBlock> SMOOTH_STONE_WALL;
    public static final DeferredBlock<StairBlock> CUT_SANDSTONE_STAIRS;
    public static final DeferredBlock<WallBlock> CUT_SANDSTONE_WALL;
    public static final DeferredBlock<StairBlock> CUT_RED_SANDSTONE_STAIRS;
    public static final DeferredBlock<WallBlock> CUT_RED_SANDSTONE_WALL;
    public static final DeferredBlock<WallBlock> QUARTZ_WALL;
    public static final DeferredBlock<StairBlock> QUARTZ_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> QUARTZ_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> QUARTZ_BRICK_WALL;
    public static final DeferredBlock<WallBlock> SMOOTH_QUARTZ_WALL;
    public static final DeferredBlock<StairBlock> CHISELED_QUARTZ_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> CHISELED_QUARTZ_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> CHISELED_QUARTZ_BLOCK_WALL;
    public static final DeferredBlock<WallBlock> PRISMARINE_BRICK_WALL;
    public static final DeferredBlock<WallBlock> DARK_PRISMARINE_WALL;
    public static final DeferredBlock<StairBlock> NETHERRACK_STAIRS;
    public static final DeferredBlock<SlabBlock> NETHERRACK_SLAB;
    public static final DeferredBlock<WallBlock> NETHERRACK_WALL;
    public static final DeferredBlock<StairBlock> END_STONE_STAIRS;
    public static final DeferredBlock<SlabBlock> END_STONE_SLAB;
    public static final DeferredBlock<WallBlock> END_STONE_WALL;
    public static final DeferredBlock<WallBlock> PURPUR_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> BASALT_SLAB;
    public static final DeferredBlock<WallBlock> BASALT_WALL;
    public static final DeferredBlock<StairBlock> POLISHED_BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> POLISHED_BASALT_SLAB;
    public static final DeferredBlock<WallBlock> POLISHED_BASALT_WALL;
    public static final DeferredBlock<StairBlock> TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> WHITE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> MAGENTA_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> MAGENTA_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> MAGENTA_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_BLUE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_BLUE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_BLUE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> YELLOW_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> YELLOW_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> YELLOW_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIME_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIME_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIME_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PINK_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PINK_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PINK_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GRAY_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GRAY_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GRAY_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_GRAY_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_GRAY_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_GRAY_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> CYAN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLUE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BROWN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GREEN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> RED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> RED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLACK_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> DRIPSTONE_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> DRIPSTONE_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> DRIPSTONE_BLOCK_WALL;
    public static final DeferredBlock<StairBlock> AMETHYST_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> AMETHYST_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> AMETHYST_BLOCK_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_STONE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_STONE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_STONE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> STRIPPED_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_SPRUCE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_SPRUCE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_BIRCH_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BIRCH_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_JUNGLE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_JUNGLE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_ACACIA_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_ACACIA_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_DARK_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_DARK_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_MANGROVE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_MANGROVE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_CHERRY_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CHERRY_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> OAK_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> OAK_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> SPRUCE_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> SPRUCE_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> BIRCH_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> BIRCH_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> JUNGLE_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> JUNGLE_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> ACACIA_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> ACACIA_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> DARK_OAK_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> DARK_OAK_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> MANGROVE_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> MANGROVE_LOG_SLAB;
    public static final DeferredBlock<StrippableStairBlock> CHERRY_LOG_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> CHERRY_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_CRIMSON_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CRIMSON_STEM_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_WARPED_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_WARPED_STEM_SLAB;
    public static final DeferredBlock<StrippableStairBlock> CRIMSON_STEM_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> CRIMSON_STEM_SLAB;
    public static final DeferredBlock<StrippableStairBlock> WARPED_STEM_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> WARPED_STEM_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_SPRUCE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_SPRUCE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_SPRUCE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_SPRUCE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_SPRUCE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_BIRCH_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BIRCH_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_BIRCH_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_BIRCH_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_BIRCH_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_JUNGLE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_JUNGLE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_JUNGLE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_JUNGLE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_JUNGLE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_ACACIA_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_ACACIA_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_ACACIA_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_ACACIA_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_ACACIA_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_DARK_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_DARK_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_DARK_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_DARK_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_DARK_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_MANGROVE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_MANGROVE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_MANGROVE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_MANGROVE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_MANGROVE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_CHERRY_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CHERRY_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_CHERRY_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_CHERRY_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_CHERRY_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_BAMBOO_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BAMBOO_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_BAMBOO_BLOCK_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_BAMBOO_BLOCK_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_BAMBOO_BLOCK_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> OAK_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> OAK_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> OAK_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> OAK_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> SPRUCE_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> SPRUCE_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> SPRUCE_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> SPRUCE_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> SPRUCE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> BIRCH_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> BIRCH_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> BIRCH_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> BIRCH_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> BIRCH_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> JUNGLE_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> JUNGLE_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> JUNGLE_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> JUNGLE_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> JUNGLE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> ACACIA_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> ACACIA_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> ACACIA_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> ACACIA_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> ACACIA_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> DARK_OAK_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> DARK_OAK_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> DARK_OAK_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> DARK_OAK_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> DARK_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> MANGROVE_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> MANGROVE_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> MANGROVE_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> MANGROVE_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> MANGROVE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> CHERRY_WOOD_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> CHERRY_WOOD_SLAB;
    public static final DeferredBlock<StrippableWallBlock> CHERRY_WOOD_WALL;
    public static final DeferredBlock<StrippableFenceBlock> CHERRY_WOOD_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> CHERRY_WOOD_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> BAMBOO_BLOCK_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> BAMBOO_BLOCK_SLAB;
    public static final DeferredBlock<StrippableWallBlock> BAMBOO_BLOCK_WALL;
    public static final DeferredBlock<StrippableFenceBlock> BAMBOO_BLOCK_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> BAMBOO_BLOCK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_CRIMSON_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CRIMSON_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_CRIMSON_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_CRIMSON_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_CRIMSON_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_WARPED_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_WARPED_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_WARPED_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_WARPED_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_WARPED_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> CRIMSON_HYPHAE_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> CRIMSON_HYPHAE_SLAB;
    public static final DeferredBlock<StrippableWallBlock> CRIMSON_HYPHAE_WALL;
    public static final DeferredBlock<StrippableFenceBlock> CRIMSON_HYPHAE_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> CRIMSON_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StrippableStairBlock> WARPED_HYPHAE_STAIRS;
    public static final DeferredBlock<StrippableSlabBlock> WARPED_HYPHAE_SLAB;
    public static final DeferredBlock<StrippableWallBlock> WARPED_HYPHAE_WALL;
    public static final DeferredBlock<StrippableFenceBlock> WARPED_HYPHAE_FENCE;
    public static final DeferredBlock<StrippableFenceGateBlock> WARPED_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CALCITE_STAIRS;
    public static final DeferredBlock<SlabBlock> CALCITE_SLAB;
    public static final DeferredBlock<WallBlock> CALCITE_WALL;
    public static final DeferredBlock<StairBlock> SMOOTH_BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> SMOOTH_BASALT_SLAB;
    public static final DeferredBlock<WallBlock> SMOOTH_BASALT_WALL;
    public static final DeferredBlock<StairBlock> DEEPSLATE_STAIRS;
    public static final DeferredBlock<SlabBlock> DEEPSLATE_SLAB;
    public static final DeferredBlock<WallBlock> DEEPSLATE_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_DEEPSLATE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_DEEPSLATE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_DEEPSLATE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_DEEPSLATE_TILE_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_DEEPSLATE_TILE_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_DEEPSLATE_TILE_WALL;
    public static final DeferredBlock<FenceGateBlock> NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CRACKED_NETHER_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_NETHER_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_NETHER_BRICK_WALL;
    public static final DeferredBlock<FenceBlock> CRACKED_NETHER_BRICK_FENCE;
    public static final DeferredBlock<FenceGateBlock> CRACKED_NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<FenceBlock> RED_NETHER_BRICK_FENCE;
    public static final DeferredBlock<FenceGateBlock> RED_NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> OBSIDIAN_STAIRS;
    public static final DeferredBlock<SlabBlock> OBSIDIAN_SLAB;
    public static final DeferredBlock<WallBlock> OBSIDIAN_WALL;
    public static final DeferredBlock<StairBlock> CRYING_OBSIDIAN_STAIRS;
    public static final DeferredBlock<SlabBlock> CRYING_OBSIDIAN_SLAB;
    public static final DeferredBlock<WallBlock> CRYING_OBSIDIAN_WALL;
    public static final DeferredBlock<StairBlock> WHITE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> MAGENTA_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> MAGENTA_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> MAGENTA_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> YELLOW_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> YELLOW_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> YELLOW_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIME_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIME_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIME_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PINK_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PINK_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PINK_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GRAY_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GRAY_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GRAY_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> CYAN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLUE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BROWN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GREEN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> RED_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> RED_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLACK_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> WHITE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> MagentaWoolStairs;
    public static final DeferredBlock<SlabBlock> MagentaWoolSlab;
    public static final DeferredBlock<WallBlock> MagentaWoolWall;
    public static final DeferredBlock<StairBlock> LightBlueWoolStairs;
    public static final DeferredBlock<SlabBlock> LightBlueWoolSlab;
    public static final DeferredBlock<WallBlock> LightBlueWoolWall;
    public static final DeferredBlock<StairBlock> YellowWoolStairs;
    public static final DeferredBlock<SlabBlock> YellowWoolSlab;
    public static final DeferredBlock<WallBlock> YellowWoolWall;
    public static final DeferredBlock<StairBlock> LimeWoolStairs;
    public static final DeferredBlock<SlabBlock> LimeWoolSlab;
    public static final DeferredBlock<WallBlock> LimeWoolWall;
    public static final DeferredBlock<StairBlock> PinkWoolStairs;
    public static final DeferredBlock<SlabBlock> PinkWoolSlab;
    public static final DeferredBlock<WallBlock> PinkWoolWall;
    public static final DeferredBlock<StairBlock> GrayWoolStairs;
    public static final DeferredBlock<SlabBlock> GrayWoolSlab;
    public static final DeferredBlock<WallBlock> GrayWoolWall;
    public static final DeferredBlock<StairBlock> LightGrayWoolStairs;
    public static final DeferredBlock<SlabBlock> LightGrayWoolSlab;
    public static final DeferredBlock<WallBlock> LightGrayWoolWall;
    public static final DeferredBlock<StairBlock> CYAN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BLUE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BROWN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> GREEN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> RED_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> RED_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BLACK_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_WOOL_WALL;
    public static final DeferredBlock<StairBlock> PACKED_MUD_STAIRS;
    public static final DeferredBlock<SlabBlock> PACKED_MUD_SLAB;
    public static final DeferredBlock<WallBlock> PACKED_MUD_WALL;

    private static StrippableStairBlock strippableStair(Supplier<StairBlock> stripped, Block base) {
        return new StrippableStairBlock(stripped, base.defaultBlockState(), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static StrippableStairBlock strippableStair(Supplier<StairBlock> stripped, Block base, BlockBehaviour.Properties properties) {
        return new StrippableStairBlock(stripped, base.defaultBlockState(), properties);
    }

    private static StrippableSlabBlock strippableSlab(Supplier<SlabBlock> stripped, Block base) {
        return new StrippableSlabBlock(stripped, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static StrippableSlabBlock strippableSlab(Supplier<SlabBlock> stripped, BlockBehaviour.Properties properties) {
        return new StrippableSlabBlock(stripped, properties);
    }

    private static StrippableWallBlock strippableWall(Supplier<WallBlock> stripped, Block base) {
        return new StrippableWallBlock(stripped, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static StrippableWallBlock strippableWall(Supplier<WallBlock> stripped, BlockBehaviour.Properties properties) {
        return new StrippableWallBlock(stripped, properties);
    }

    private static StrippableFenceBlock strippableFence(Supplier<FenceBlock> stripped, Block base) {
        return new StrippableFenceBlock(stripped, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static StrippableFenceBlock strippableFence(Supplier<FenceBlock> stripped, BlockBehaviour.Properties properties) {
        return new StrippableFenceBlock(stripped, properties);
    }

    private static StrippableFenceGateBlock strippableFenceGate(Supplier<FenceGateBlock> stripped, WoodType type, Block base) {
        return new StrippableFenceGateBlock(stripped, type, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static StrippableFenceGateBlock strippableFenceGate(Supplier<FenceGateBlock> stripped, WoodType type, BlockBehaviour.Properties properties) {
        return new StrippableFenceGateBlock(stripped, type, properties);
    }

    private static DeferredBlock<StairBlock> regTerracottaStairs(DyeColor color, Block base) {
        return BVBlocks.register(color.getName() + "_terracotta_stairs", () -> BlockRegisterHelper.stair((Block)base));
    }

    private static DeferredBlock<SlabBlock> regTerracottaSlab(DyeColor color) {
        return BVBlocks.register(color.getName() + "_terracotta_slab", () -> BVBlocks.slab(Blocks.TERRACOTTA));
    }

    private static DeferredBlock<WallBlock> regTerracottaWall(DyeColor color) {
        return BVBlocks.register(color.getName() + "_terracotta_wall", () -> BVBlocks.wall(Blocks.TERRACOTTA));
    }

    private static DeferredBlock<StrippableStairBlock> logStairs(String type, Block base, Supplier<StairBlock> stripped) {
        return BVBlocks.register(type + "_log_stairs", () -> BVBlocks.strippableStair(stripped, base), 300);
    }

    private static DeferredBlock<StairBlock> logStairs(String type, Block base) {
        return BVBlocks.register(type + "_log_stairs", () -> BlockRegisterHelper.stair((Block)base), 300);
    }

    private static DeferredBlock<SlabBlock> logSlab(String type, Block base) {
        return BVBlocks.register(type + "_log_slab", () -> BVBlocks.slab(base), 300);
    }

    private static DeferredBlock<StrippableSlabBlock> logSlab(String type, Block base, Supplier<SlabBlock> stripped) {
        return BVBlocks.register(type + "_log_slab", () -> BVBlocks.strippableSlab(stripped, base), 300);
    }

    private static DeferredBlock<StairBlock> woodStairs(String type, Block base) {
        return BVBlocks.register(type + "_wood_stairs", () -> BlockRegisterHelper.stair((Block)base), 300);
    }

    private static DeferredBlock<StrippableStairBlock> woodStairs(String type, Block base, Supplier<StairBlock> stripped) {
        return BVBlocks.register(type + "_wood_stairs", () -> BVBlocks.strippableStair(stripped, base), 300);
    }

    private static DeferredBlock<SlabBlock> woodSlab(String type, Block base) {
        return BVBlocks.register(type + "_wood_slab", () -> BVBlocks.slab(base), 150);
    }

    private static DeferredBlock<StrippableSlabBlock> woodSlab(String type, Block base, Supplier<SlabBlock> stripped) {
        return BVBlocks.register(type + "_wood_slab", () -> BVBlocks.strippableSlab(stripped, base), 150);
    }

    private static DeferredBlock<WallBlock> woodWall(String type, Block base) {
        return BVBlocks.register(type + "_wood_wall", () -> BVBlocks.wall(base), 300);
    }

    private static DeferredBlock<StrippableWallBlock> woodWall(String type, Block base, Supplier<WallBlock> stripped) {
        return BVBlocks.register(type + "_wood_wall", () -> BVBlocks.strippableWall(stripped, base), 300);
    }

    private static DeferredBlock<FenceBlock> woodFence(String type, Block base) {
        return BVBlocks.register(type + "_wood_fence", () -> BVBlocks.fence(base), 300);
    }

    private static DeferredBlock<StrippableFenceBlock> woodFence(String type, Block base, Supplier<FenceBlock> stripped) {
        return BVBlocks.register(type + "_wood_fence", () -> BVBlocks.strippableFence(stripped, base), 300);
    }

    private static DeferredBlock<FenceGateBlock> woodFenceGate(String type, Block base) {
        return BVBlocks.register(type + "_wood_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)BVBlocks.woodTypeOf(type), (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base)), 300);
    }

    private static DeferredBlock<StrippableFenceGateBlock> woodFenceGate(WoodType type, Block base, Supplier<FenceGateBlock> stripped) {
        return BVBlocks.register(type.name() + "_wood_fence_gate", () -> BVBlocks.strippableFenceGate(stripped, type, base), 300);
    }

    private static DeferredBlock<StairBlock> regGlazedTerracottaStairs(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_stairs", () -> new StairBlock(parent.defaultBlockState(), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent)));
    }

    private static DeferredBlock<SlabBlock> regGlazedTerracottaSlab(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_slab", () -> new SlabBlock(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent)));
    }

    private static DeferredBlock<WallBlock> regGlazedTerracottaWall(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_wall", () -> new WallBlock(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent)));
    }

    private static DeferredBlock<StairBlock> regWoolStairs(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_stairs", () -> BlockRegisterHelper.stair((Block)parent));
    }

    private static DeferredBlock<SlabBlock> regWoolSlab(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_slab", () -> BVBlocks.slab(parent));
    }

    private static DeferredBlock<WallBlock> regWoolWall(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_wall", () -> BVBlocks.wall(parent));
    }

    private static SlabBlock slab(BlockBehaviour.Properties properties) {
        return new SlabBlock(properties);
    }

    private static SlabBlock slab(Block parent) {
        return BVBlocks.slab(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent));
    }

    private static WallBlock wall(BlockBehaviour.Properties properties) {
        return new WallBlock(properties);
    }

    private static WallBlock wall(Block parent) {
        return BVBlocks.wall(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent));
    }

    private static FenceBlock fence(BlockBehaviour.Properties properties) {
        return new FenceBlock(properties);
    }

    private static FenceBlock fence(Block parent) {
        return BVBlocks.fence(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent));
    }

    private static WoodType woodTypeOf(String key) {
        key = key.replace("stripped_", "");
        Iterator iterator = WoodType.values().iterator();
        while (iterator.hasNext()) {
            WoodType type = (WoodType)iterator.next();
            if (!type.name().contains(key)) continue;
            return type;
        }
        throw new IllegalArgumentException("No wood type with key: " + key);
    }

    private static Block getVanillaBlock(String name) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)name));
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block) {
        return BVBlocks.register(name, block, DEFAULT_ITEM_PROPERTIES);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block, int itemBurnTime) {
        return BVBlocks.register(name, block, itemBurnTime, DEFAULT_ITEM_PROPERTIES);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block, Item.Properties itemProperties) {
        DeferredBlock registryObject = BVBlocks.registerWithoutItem(name, block);
        BVItems.REGISTER.register(name, () -> new BlockItem((Block)registryObject.get(), itemProperties));
        return registryObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block, final int itemBurnTime, Item.Properties itemProperties) {
        DeferredBlock registryObject = BVBlocks.registerWithoutItem(name, block);
        BVItems.REGISTER.register(name, () -> new BlockItem((Block)registryObject.get(), itemProperties){

            public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return itemBurnTime;
            }
        });
        return registryObject;
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, Supplier<T> block) {
        return REGISTER.register(name, block);
    }

    public static Iterator<? extends Block> getAllBlocks() {
        return REGISTER.getEntries().stream().map(Supplier::get).iterator();
    }

    static {
        REGISTER.addAlias(BlockVariants.locate("tuff_stairs"), BVUtil.getBlockID(Blocks.TUFF_STAIRS));
        REGISTER.addAlias(BlockVariants.locate("tuff_slab"), BVUtil.getBlockID(Blocks.TUFF_SLAB));
        REGISTER.addAlias(BlockVariants.locate("tuff_wall"), BVUtil.getBlockID(Blocks.TUFF_WALL));
        POLISHED_GRANITE_WALL = BVBlocks.register("polished_granite_wall", () -> BVBlocks.wall(Blocks.POLISHED_GRANITE));
        POLISHED_DIORITE_WALL = BVBlocks.register("polished_diorite_wall", () -> BVBlocks.wall(Blocks.POLISHED_DIORITE));
        POLISHED_ANDESITE_WALL = BVBlocks.register("polished_andesite_wall", () -> BVBlocks.wall(Blocks.POLISHED_ANDESITE));
        STONE_WALL = BVBlocks.register("stone_wall", () -> BVBlocks.wall(Blocks.STONE));
        SMOOTH_STONE_STAIRS = BVBlocks.register("smooth_stone_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.SMOOTH_STONE));
        SMOOTH_STONE_WALL = BVBlocks.register("smooth_stone_wall", () -> BVBlocks.wall(Blocks.SMOOTH_STONE));
        CUT_SANDSTONE_STAIRS = BVBlocks.register("cut_sandstone_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CUT_SANDSTONE));
        CUT_SANDSTONE_WALL = BVBlocks.register("cut_sandstone_wall", () -> BVBlocks.wall(Blocks.CUT_SANDSTONE));
        CUT_RED_SANDSTONE_STAIRS = BVBlocks.register("cut_red_sandstone_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CUT_RED_SANDSTONE));
        CUT_RED_SANDSTONE_WALL = BVBlocks.register("cut_red_sandstone_wall", () -> BVBlocks.wall(Blocks.CUT_RED_SANDSTONE));
        QUARTZ_WALL = BVBlocks.register("quartz_wall", () -> BVBlocks.wall(Blocks.QUARTZ_BLOCK));
        QUARTZ_BRICK_STAIRS = BVBlocks.register("quartz_brick_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.QUARTZ_BRICKS));
        QUARTZ_BRICK_SLAB = BVBlocks.register("quartz_brick_slab", () -> BVBlocks.slab(Blocks.QUARTZ_BRICKS));
        QUARTZ_BRICK_WALL = BVBlocks.register("quartz_brick_wall", () -> BVBlocks.wall(Blocks.QUARTZ_BRICKS));
        SMOOTH_QUARTZ_WALL = BVBlocks.register("smooth_quartz_wall", () -> BVBlocks.wall(Blocks.SMOOTH_QUARTZ));
        CHISELED_QUARTZ_BLOCK_STAIRS = BVBlocks.register("chiseled_quartz_block_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CHISELED_QUARTZ_BLOCK));
        CHISELED_QUARTZ_BLOCK_SLAB = BVBlocks.register("chiseled_quartz_block_slab", () -> BVBlocks.slab(Blocks.CHISELED_QUARTZ_BLOCK));
        CHISELED_QUARTZ_BLOCK_WALL = BVBlocks.register("chiseled_quartz_block_wall", () -> BVBlocks.wall(Blocks.CHISELED_QUARTZ_BLOCK));
        PRISMARINE_BRICK_WALL = BVBlocks.register("prismarine_brick_wall", () -> BVBlocks.wall(Blocks.PRISMARINE_BRICKS));
        DARK_PRISMARINE_WALL = BVBlocks.register("dark_prismarine_wall", () -> BVBlocks.wall(Blocks.PRISMARINE_BRICKS));
        NETHERRACK_STAIRS = BVBlocks.register("netherrack_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.NETHERRACK));
        NETHERRACK_SLAB = BVBlocks.register("netherrack_slab", () -> BVBlocks.slab(Blocks.NETHERRACK));
        NETHERRACK_WALL = BVBlocks.register("netherrack_wall", () -> BVBlocks.wall(Blocks.NETHERRACK));
        END_STONE_STAIRS = BVBlocks.register("end_stone_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.END_STONE));
        END_STONE_SLAB = BVBlocks.register("end_stone_slab", () -> BVBlocks.slab(Blocks.END_STONE));
        END_STONE_WALL = BVBlocks.register("end_stone_wall", () -> BVBlocks.wall(Blocks.END_STONE));
        PURPUR_WALL = BVBlocks.register("purpur_wall", () -> BVBlocks.wall(Blocks.PURPUR_BLOCK));
        CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS = BVBlocks.register("cracked_polished_blackstone_brick_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS));
        CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB = BVBlocks.register("cracked_polished_blackstone_brick_slab", () -> BVBlocks.slab(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS));
        CRACKED_POLISHED_BLACKSTONE_BRICK_WALL = BVBlocks.register("cracked_polished_blackstone_brick_wall", () -> BVBlocks.wall(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS));
        BASALT_STAIRS = BVBlocks.register("basalt_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.BASALT));
        BASALT_SLAB = BVBlocks.register("basalt_slab", () -> BVBlocks.slab(Blocks.BASALT));
        BASALT_WALL = BVBlocks.register("basalt_wall", () -> BVBlocks.wall(Blocks.BASALT));
        POLISHED_BASALT_STAIRS = BVBlocks.register("polished_basalt_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.POLISHED_BASALT));
        POLISHED_BASALT_SLAB = BVBlocks.register("polished_basalt_slab", () -> BVBlocks.slab(Blocks.POLISHED_BASALT));
        POLISHED_BASALT_WALL = BVBlocks.register("polished_basalt_wall", () -> BVBlocks.wall(Blocks.POLISHED_BASALT));
        TERRACOTTA_STAIRS = BVBlocks.register("terracotta_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.TERRACOTTA));
        TERRACOTTA_SLAB = BVBlocks.register("terracotta_slab", () -> BVBlocks.slab(Blocks.TERRACOTTA));
        TERRACOTTA_WALL = BVBlocks.register("terracotta_wall", () -> BVBlocks.wall(Blocks.TERRACOTTA));
        WHITE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.WHITE, Blocks.WHITE_TERRACOTTA);
        WHITE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.WHITE);
        WHITE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.WHITE);
        ORANGE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.ORANGE, Blocks.ORANGE_TERRACOTTA);
        ORANGE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.ORANGE);
        ORANGE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.ORANGE);
        MAGENTA_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.MAGENTA, Blocks.MAGENTA_TERRACOTTA);
        MAGENTA_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.MAGENTA);
        MAGENTA_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.MAGENTA);
        LIGHT_BLUE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_TERRACOTTA);
        LIGHT_BLUE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIGHT_BLUE);
        YELLOW_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.YELLOW, Blocks.YELLOW_TERRACOTTA);
        YELLOW_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.YELLOW);
        YELLOW_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.YELLOW);
        LIME_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIME, Blocks.LIME_TERRACOTTA);
        LIME_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIME);
        LIME_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIME);
        PINK_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.PINK, Blocks.PINK_TERRACOTTA);
        PINK_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.PINK);
        PINK_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.PINK);
        GRAY_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.GRAY, Blocks.GRAY_TERRACOTTA);
        GRAY_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.GRAY);
        GRAY_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.GRAY);
        LIGHT_GRAY_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_TERRACOTTA);
        LIGHT_GRAY_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIGHT_GRAY);
        CYAN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.CYAN, Blocks.CYAN_TERRACOTTA);
        CYAN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.CYAN);
        CYAN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.CYAN);
        PURPLE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.PURPLE, Blocks.PURPLE_TERRACOTTA);
        PURPLE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.PURPLE);
        PURPLE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.PURPLE);
        BLUE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BLUE, Blocks.BLUE_TERRACOTTA);
        BLUE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BLUE);
        BLUE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BLUE);
        BROWN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BROWN, Blocks.BROWN_TERRACOTTA);
        BROWN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BROWN);
        BROWN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BROWN);
        GREEN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.GREEN, Blocks.GREEN_TERRACOTTA);
        GREEN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.GREEN);
        GREEN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.GREEN);
        RED_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.RED, Blocks.RED_TERRACOTTA);
        RED_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.RED);
        RED_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.RED);
        BLACK_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BLACK, Blocks.BLACK_TERRACOTTA);
        BLACK_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BLACK);
        BLACK_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BLACK);
        DRIPSTONE_BLOCK_STAIRS = BVBlocks.register("dripstone_block_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.DRIPSTONE_BLOCK));
        DRIPSTONE_BLOCK_SLAB = BVBlocks.register("dripstone_block_slab", () -> BVBlocks.slab(Blocks.DRIPSTONE_BLOCK));
        DRIPSTONE_BLOCK_WALL = BVBlocks.register("dripstone_block_wall", () -> BVBlocks.wall(Blocks.DRIPSTONE_BLOCK));
        AMETHYST_BLOCK_STAIRS = BVBlocks.register("amethyst_block_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.AMETHYST_BLOCK));
        AMETHYST_BLOCK_SLAB = BVBlocks.register("amethyst_block_slab", () -> BVBlocks.slab(Blocks.AMETHYST_BLOCK));
        AMETHYST_BLOCK_WALL = BVBlocks.register("amethyst_block_wall", () -> BVBlocks.wall(Blocks.AMETHYST_BLOCK));
        CRACKED_STONE_BRICK_STAIRS = BVBlocks.register("cracked_stone_brick_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRACKED_STONE_BRICKS));
        CRACKED_STONE_BRICK_SLAB = BVBlocks.register("cracked_stone_brick_slab", () -> BVBlocks.slab(Blocks.CRACKED_STONE_BRICKS));
        CRACKED_STONE_BRICK_WALL = BVBlocks.register("cracked_stone_brick_wall", () -> BVBlocks.wall(Blocks.CRACKED_STONE_BRICKS));
        STRIPPED_OAK_LOG_STAIRS = BVBlocks.logStairs("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_LOG_SLAB = BVBlocks.logSlab("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_SPRUCE_LOG_STAIRS = BVBlocks.logStairs("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_LOG_SLAB = BVBlocks.logSlab("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_BIRCH_LOG_STAIRS = BVBlocks.logStairs("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_LOG_SLAB = BVBlocks.logSlab("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_JUNGLE_LOG_STAIRS = BVBlocks.logStairs("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_LOG_SLAB = BVBlocks.logSlab("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_ACACIA_LOG_STAIRS = BVBlocks.logStairs("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_LOG_SLAB = BVBlocks.logSlab("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_DARK_OAK_LOG_STAIRS = BVBlocks.logStairs("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_LOG_SLAB = BVBlocks.logSlab("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_LOG_STAIRS = BVBlocks.logStairs("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_LOG_SLAB = BVBlocks.logSlab("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_CHERRY_LOG_STAIRS = BVBlocks.logStairs("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_LOG_SLAB = BVBlocks.logSlab("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        OAK_LOG_STAIRS = BVBlocks.logStairs("oak", Blocks.OAK_WOOD, STRIPPED_OAK_LOG_STAIRS);
        OAK_LOG_SLAB = BVBlocks.logSlab("oak", Blocks.OAK_WOOD, STRIPPED_OAK_LOG_SLAB);
        SPRUCE_LOG_STAIRS = BVBlocks.logStairs("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_LOG_STAIRS);
        SPRUCE_LOG_SLAB = BVBlocks.logSlab("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_LOG_SLAB);
        BIRCH_LOG_STAIRS = BVBlocks.logStairs("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_LOG_STAIRS);
        BIRCH_LOG_SLAB = BVBlocks.logSlab("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_LOG_SLAB);
        JUNGLE_LOG_STAIRS = BVBlocks.logStairs("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_LOG_STAIRS);
        JUNGLE_LOG_SLAB = BVBlocks.logSlab("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_LOG_SLAB);
        ACACIA_LOG_STAIRS = BVBlocks.logStairs("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_LOG_STAIRS);
        ACACIA_LOG_SLAB = BVBlocks.logSlab("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_LOG_SLAB);
        DARK_OAK_LOG_STAIRS = BVBlocks.logStairs("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_LOG_STAIRS);
        DARK_OAK_LOG_SLAB = BVBlocks.logSlab("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_LOG_SLAB);
        MANGROVE_LOG_STAIRS = BVBlocks.logStairs("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_LOG_STAIRS);
        MANGROVE_LOG_SLAB = BVBlocks.logSlab("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_LOG_SLAB);
        CHERRY_LOG_STAIRS = BVBlocks.logStairs("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_LOG_STAIRS);
        CHERRY_LOG_SLAB = BVBlocks.logSlab("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_LOG_SLAB);
        STRIPPED_CRIMSON_STEM_STAIRS = BVBlocks.register("stripped_crimson_stem_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.STRIPPED_CRIMSON_STEM));
        STRIPPED_CRIMSON_STEM_SLAB = BVBlocks.register("stripped_crimson_stem_slab", () -> BVBlocks.slab(Blocks.STRIPPED_CRIMSON_STEM));
        STRIPPED_WARPED_STEM_STAIRS = BVBlocks.register("stripped_warped_stem_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.STRIPPED_WARPED_STEM));
        STRIPPED_WARPED_STEM_SLAB = BVBlocks.register("stripped_warped_stem_slab", () -> BVBlocks.slab(Blocks.STRIPPED_WARPED_STEM));
        CRIMSON_STEM_STAIRS = BVBlocks.register("crimson_stem_stairs", () -> BVBlocks.strippableStair(STRIPPED_CRIMSON_STEM_STAIRS, Blocks.CRIMSON_STEM));
        CRIMSON_STEM_SLAB = BVBlocks.register("crimson_stem_slab", () -> BVBlocks.strippableSlab(STRIPPED_CRIMSON_STEM_SLAB, Blocks.CRIMSON_STEM));
        WARPED_STEM_STAIRS = BVBlocks.register("warped_stem_stairs", () -> BVBlocks.strippableStair(STRIPPED_WARPED_STEM_STAIRS, Blocks.WARPED_STEM));
        WARPED_STEM_SLAB = BVBlocks.register("warped_stem_slab", () -> BVBlocks.strippableSlab(STRIPPED_WARPED_STEM_SLAB, Blocks.WARPED_STEM));
        STRIPPED_OAK_WOOD_STAIRS = BVBlocks.woodStairs("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_SLAB = BVBlocks.woodSlab("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_WALL = BVBlocks.woodWall("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_FENCE = BVBlocks.woodFence("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_SPRUCE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_SLAB = BVBlocks.woodSlab("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_WALL = BVBlocks.woodWall("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_FENCE = BVBlocks.woodFence("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_BIRCH_WOOD_STAIRS = BVBlocks.woodStairs("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_SLAB = BVBlocks.woodSlab("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_WALL = BVBlocks.woodWall("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_FENCE = BVBlocks.woodFence("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_JUNGLE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_SLAB = BVBlocks.woodSlab("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_WALL = BVBlocks.woodWall("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_FENCE = BVBlocks.woodFence("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_ACACIA_WOOD_STAIRS = BVBlocks.woodStairs("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_SLAB = BVBlocks.woodSlab("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_WALL = BVBlocks.woodWall("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_FENCE = BVBlocks.woodFence("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_DARK_OAK_WOOD_STAIRS = BVBlocks.woodStairs("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_SLAB = BVBlocks.woodSlab("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_WALL = BVBlocks.woodWall("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_FENCE = BVBlocks.woodFence("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_SLAB = BVBlocks.woodSlab("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_WALL = BVBlocks.woodWall("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_FENCE = BVBlocks.woodFence("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_CHERRY_WOOD_STAIRS = BVBlocks.woodStairs("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_SLAB = BVBlocks.woodSlab("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_WALL = BVBlocks.woodWall("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_FENCE = BVBlocks.woodFence("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_BAMBOO_BLOCK_STAIRS = BVBlocks.register("stripped_bamboo_block_stairs", () -> BlockRegisterHelper.stair(() -> ((Block)Blocks.STRIPPED_BAMBOO_BLOCK).defaultBlockState(), (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 150);
        STRIPPED_BAMBOO_BLOCK_SLAB = BVBlocks.register("stripped_bamboo_block_slab", () -> BVBlocks.slab(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 75);
        STRIPPED_BAMBOO_BLOCK_WALL = BVBlocks.register("stripped_bamboo_block_wall", () -> BVBlocks.wall(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 150);
        STRIPPED_BAMBOO_BLOCK_FENCE = BVBlocks.register("stripped_bamboo_block_fence", () -> BVBlocks.fence(BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 150);
        STRIPPED_BAMBOO_BLOCK_FENCE_GATE = BVBlocks.register("stripped_bamboo_block_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.BAMBOO, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 75);
        OAK_WOOD_STAIRS = BVBlocks.woodStairs("oak", Blocks.OAK_WOOD, STRIPPED_OAK_WOOD_STAIRS);
        OAK_WOOD_SLAB = BVBlocks.woodSlab("oak", Blocks.OAK_WOOD, STRIPPED_OAK_WOOD_SLAB);
        OAK_WOOD_WALL = BVBlocks.woodWall("oak", Blocks.OAK_WOOD, STRIPPED_OAK_WOOD_WALL);
        OAK_WOOD_FENCE = BVBlocks.woodFence("oak", Blocks.OAK_WOOD, STRIPPED_OAK_WOOD_FENCE);
        OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.OAK, Blocks.OAK_WOOD, STRIPPED_OAK_WOOD_FENCE_GATE);
        SPRUCE_WOOD_STAIRS = BVBlocks.woodStairs("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_WOOD_STAIRS);
        SPRUCE_WOOD_SLAB = BVBlocks.woodSlab("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_WOOD_SLAB);
        SPRUCE_WOOD_WALL = BVBlocks.woodWall("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_WOOD_WALL);
        SPRUCE_WOOD_FENCE = BVBlocks.woodFence("spruce", Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_WOOD_FENCE);
        SPRUCE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.SPRUCE, Blocks.SPRUCE_WOOD, STRIPPED_SPRUCE_WOOD_FENCE_GATE);
        BIRCH_WOOD_STAIRS = BVBlocks.woodStairs("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_WOOD_STAIRS);
        BIRCH_WOOD_SLAB = BVBlocks.woodSlab("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_WOOD_SLAB);
        BIRCH_WOOD_WALL = BVBlocks.woodWall("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_WOOD_WALL);
        BIRCH_WOOD_FENCE = BVBlocks.woodFence("birch", Blocks.BIRCH_WOOD, STRIPPED_BIRCH_WOOD_FENCE);
        BIRCH_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.BIRCH, Blocks.BIRCH_WOOD, STRIPPED_BIRCH_WOOD_FENCE_GATE);
        JUNGLE_WOOD_STAIRS = BVBlocks.woodStairs("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_WOOD_STAIRS);
        JUNGLE_WOOD_SLAB = BVBlocks.woodSlab("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_WOOD_SLAB);
        JUNGLE_WOOD_WALL = BVBlocks.woodWall("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_WOOD_WALL);
        JUNGLE_WOOD_FENCE = BVBlocks.woodFence("jungle", Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_WOOD_FENCE);
        JUNGLE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.JUNGLE, Blocks.JUNGLE_WOOD, STRIPPED_JUNGLE_WOOD_FENCE_GATE);
        ACACIA_WOOD_STAIRS = BVBlocks.woodStairs("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_WOOD_STAIRS);
        ACACIA_WOOD_SLAB = BVBlocks.woodSlab("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_WOOD_SLAB);
        ACACIA_WOOD_WALL = BVBlocks.woodWall("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_WOOD_WALL);
        ACACIA_WOOD_FENCE = BVBlocks.woodFence("acacia", Blocks.ACACIA_WOOD, STRIPPED_ACACIA_WOOD_FENCE);
        ACACIA_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.ACACIA, Blocks.ACACIA_WOOD, STRIPPED_ACACIA_WOOD_FENCE_GATE);
        DARK_OAK_WOOD_STAIRS = BVBlocks.woodStairs("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_WOOD_STAIRS);
        DARK_OAK_WOOD_SLAB = BVBlocks.woodSlab("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_WOOD_SLAB);
        DARK_OAK_WOOD_WALL = BVBlocks.woodWall("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_WOOD_WALL);
        DARK_OAK_WOOD_FENCE = BVBlocks.woodFence("dark_oak", Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_WOOD_FENCE);
        DARK_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.DARK_OAK, Blocks.DARK_OAK_WOOD, STRIPPED_DARK_OAK_WOOD_FENCE_GATE);
        MANGROVE_WOOD_STAIRS = BVBlocks.woodStairs("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_WOOD_STAIRS);
        MANGROVE_WOOD_SLAB = BVBlocks.woodSlab("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_WOOD_SLAB);
        MANGROVE_WOOD_WALL = BVBlocks.woodWall("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_WOOD_WALL);
        MANGROVE_WOOD_FENCE = BVBlocks.woodFence("mangrove", Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_WOOD_FENCE);
        MANGROVE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.MANGROVE, Blocks.MANGROVE_WOOD, STRIPPED_MANGROVE_WOOD_FENCE_GATE);
        CHERRY_WOOD_STAIRS = BVBlocks.woodStairs("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_WOOD_STAIRS);
        CHERRY_WOOD_SLAB = BVBlocks.woodSlab("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_WOOD_SLAB);
        CHERRY_WOOD_WALL = BVBlocks.woodWall("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_WOOD_WALL);
        CHERRY_WOOD_FENCE = BVBlocks.woodFence("cherry", Blocks.CHERRY_WOOD, STRIPPED_CHERRY_WOOD_FENCE);
        CHERRY_WOOD_FENCE_GATE = BVBlocks.woodFenceGate(WoodType.CHERRY, Blocks.CHERRY_WOOD, STRIPPED_CHERRY_WOOD_FENCE_GATE);
        BAMBOO_BLOCK_STAIRS = BVBlocks.register("bamboo_block_stairs", () -> BVBlocks.strippableStair(STRIPPED_BAMBOO_BLOCK_STAIRS, Blocks.BAMBOO_BLOCK, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 150);
        BAMBOO_BLOCK_SLAB = BVBlocks.register("bamboo_block_slab", () -> BVBlocks.strippableSlab(STRIPPED_BAMBOO_BLOCK_SLAB, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW)), 75);
        BAMBOO_BLOCK_WALL = BVBlocks.register("bamboo_block_wall", () -> BVBlocks.strippableWall(STRIPPED_BAMBOO_BLOCK_WALL, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT)), 150);
        BAMBOO_BLOCK_FENCE = BVBlocks.register("bamboo_block_fence", () -> BVBlocks.strippableFence(STRIPPED_BAMBOO_BLOCK_FENCE, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT)), 150);
        BAMBOO_BLOCK_FENCE_GATE = BVBlocks.register("bamboo_block_fence_gate", () -> BVBlocks.strippableFenceGate(STRIPPED_BAMBOO_BLOCK_FENCE_GATE, WoodType.BAMBOO, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT)), 150);
        STRIPPED_CRIMSON_HYPHAE_STAIRS = BVBlocks.register("stripped_crimson_hyphae_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_SLAB = BVBlocks.register("stripped_crimson_hyphae_slab", () -> BVBlocks.slab(Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_WALL = BVBlocks.register("stripped_crimson_hyphae_wall", () -> BVBlocks.wall(Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_FENCE = BVBlocks.register("stripped_crimson_hyphae_fence", () -> BVBlocks.fence(Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_FENCE_GATE = BVBlocks.register("stripped_crimson_hyphae_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.CRIMSON, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE)), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_STAIRS = BVBlocks.register("stripped_warped_hyphae_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_SLAB = BVBlocks.register("stripped_warped_hyphae_slab", () -> BVBlocks.slab(Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_WALL = BVBlocks.register("stripped_warped_hyphae_wall", () -> BVBlocks.wall(Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_FENCE = BVBlocks.register("stripped_warped_hyphae_fence", () -> BVBlocks.fence(Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_FENCE_GATE = BVBlocks.register("stripped_warped_hyphae_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.WARPED, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE)), fireResistanceItemProperties);
        CRIMSON_HYPHAE_STAIRS = BVBlocks.register("crimson_hyphae_stairs", () -> BVBlocks.strippableStair(STRIPPED_CRIMSON_HYPHAE_STAIRS, Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_SLAB = BVBlocks.register("crimson_hyphae_slab", () -> BVBlocks.strippableSlab(STRIPPED_CRIMSON_HYPHAE_SLAB, Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_WALL = BVBlocks.register("crimson_hyphae_wall", () -> BVBlocks.strippableWall(STRIPPED_CRIMSON_HYPHAE_WALL, Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_FENCE = BVBlocks.register("crimson_hyphae_fence", () -> BVBlocks.strippableFence(STRIPPED_CRIMSON_HYPHAE_FENCE, Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_FENCE_GATE = BVBlocks.register("crimson_hyphae_fence_gate", () -> BVBlocks.strippableFenceGate(STRIPPED_CRIMSON_HYPHAE_FENCE_GATE, WoodType.CRIMSON, Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_STAIRS = BVBlocks.register("warped_hyphae_stairs", () -> BVBlocks.strippableStair(STRIPPED_WARPED_HYPHAE_STAIRS, Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_SLAB = BVBlocks.register("warped_hyphae_slab", () -> BVBlocks.strippableSlab(STRIPPED_WARPED_HYPHAE_SLAB, Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_WALL = BVBlocks.register("warped_hyphae_wall", () -> BVBlocks.strippableWall(STRIPPED_WARPED_HYPHAE_WALL, Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_FENCE = BVBlocks.register("warped_hyphae_fence", () -> BVBlocks.strippableFence(STRIPPED_WARPED_HYPHAE_FENCE, Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_FENCE_GATE = BVBlocks.register("warped_hyphae_fence_gate", () -> BVBlocks.strippableFenceGate(STRIPPED_WARPED_HYPHAE_FENCE_GATE, WoodType.WARPED, Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        CALCITE_STAIRS = BVBlocks.register("calcite_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CALCITE));
        CALCITE_SLAB = BVBlocks.register("calcite_slab", () -> BVBlocks.slab(Blocks.CALCITE));
        CALCITE_WALL = BVBlocks.register("calcite_wall", () -> BVBlocks.wall(Blocks.CALCITE));
        SMOOTH_BASALT_STAIRS = BVBlocks.register("smooth_basalt_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.SMOOTH_BASALT));
        SMOOTH_BASALT_SLAB = BVBlocks.register("smooth_basalt_slab", () -> BVBlocks.slab(Blocks.SMOOTH_BASALT));
        SMOOTH_BASALT_WALL = BVBlocks.register("smooth_basalt_wall", () -> BVBlocks.wall(Blocks.SMOOTH_BASALT));
        DEEPSLATE_STAIRS = BVBlocks.register("deepslate_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.DEEPSLATE));
        DEEPSLATE_SLAB = BVBlocks.register("deepslate_slab", () -> BVBlocks.slab(Blocks.DEEPSLATE));
        DEEPSLATE_WALL = BVBlocks.register("deepslate_wall", () -> BVBlocks.wall(Blocks.DEEPSLATE));
        CRACKED_DEEPSLATE_BRICK_STAIRS = BVBlocks.register("cracked_deepslate_brick_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRACKED_DEEPSLATE_BRICKS));
        CRACKED_DEEPSLATE_BRICK_SLAB = BVBlocks.register("cracked_deepslate_brick_slab", () -> BVBlocks.slab(Blocks.CRACKED_DEEPSLATE_BRICKS));
        CRACKED_DEEPSLATE_BRICK_WALL = BVBlocks.register("cracked_deepslate_brick_wall", () -> BVBlocks.wall(Blocks.CRACKED_DEEPSLATE_BRICKS));
        CRACKED_DEEPSLATE_TILE_STAIRS = BVBlocks.register("cracked_deepslate_tile_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRACKED_DEEPSLATE_TILES));
        CRACKED_DEEPSLATE_TILE_SLAB = BVBlocks.register("cracked_deepslate_tile_slab", () -> BVBlocks.slab(Blocks.CRACKED_DEEPSLATE_TILES));
        CRACKED_DEEPSLATE_TILE_WALL = BVBlocks.register("cracked_deepslate_tile_wall", () -> BVBlocks.wall(Blocks.CRACKED_DEEPSLATE_TILES));
        NETHER_BRICK_FENCE_GATE = BVBlocks.register("nether_brick_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.OAK, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.NETHER_BRICK_FENCE)));
        CRACKED_NETHER_BRICK_STAIRS = BVBlocks.register("cracked_nether_brick_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRACKED_NETHER_BRICKS));
        CRACKED_NETHER_BRICK_SLAB = BVBlocks.register("cracked_nether_brick_slab", () -> BVBlocks.slab(Blocks.CRACKED_NETHER_BRICKS));
        CRACKED_NETHER_BRICK_WALL = BVBlocks.register("cracked_nether_brick_wall", () -> BVBlocks.wall(Blocks.CRACKED_NETHER_BRICKS));
        CRACKED_NETHER_BRICK_FENCE = BVBlocks.register("cracked_nether_brick_fence", () -> BVBlocks.fence(Blocks.CRACKED_NETHER_BRICKS));
        CRACKED_NETHER_BRICK_FENCE_GATE = BVBlocks.register("cracked_nether_brick_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.OAK, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRACKED_NETHER_BRICKS)));
        RED_NETHER_BRICK_FENCE = BVBlocks.register("red_nether_brick_fence", () -> BVBlocks.fence(Blocks.RED_NETHER_BRICKS));
        RED_NETHER_BRICK_FENCE_GATE = BVBlocks.register("red_nether_brick_fence_gate", () -> BlockRegisterHelper.fenceGate((WoodType)WoodType.OAK, (BlockBehaviour.Properties)BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.RED_NETHER_BRICKS)));
        OBSIDIAN_STAIRS = BVBlocks.register("obsidian_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.OBSIDIAN));
        OBSIDIAN_SLAB = BVBlocks.register("obsidian_slab", () -> BVBlocks.slab(Blocks.OBSIDIAN));
        OBSIDIAN_WALL = BVBlocks.register("obsidian_wall", () -> BVBlocks.wall(Blocks.OBSIDIAN));
        CRYING_OBSIDIAN_STAIRS = BVBlocks.register("crying_obsidian_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.CRYING_OBSIDIAN));
        CRYING_OBSIDIAN_SLAB = BVBlocks.register("crying_obsidian_slab", () -> BVBlocks.slab(Blocks.CRYING_OBSIDIAN));
        CRYING_OBSIDIAN_WALL = BVBlocks.register("crying_obsidian_wall", () -> BVBlocks.wall(Blocks.CRYING_OBSIDIAN));
        WHITE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.WHITE);
        WHITE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.WHITE);
        WHITE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.WHITE);
        ORANGE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.ORANGE);
        ORANGE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.ORANGE);
        ORANGE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.ORANGE);
        MAGENTA_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.MAGENTA);
        MAGENTA_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.MAGENTA);
        MAGENTA_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.MAGENTA);
        LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIGHT_BLUE);
        YELLOW_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.YELLOW);
        YELLOW_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.YELLOW);
        YELLOW_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.YELLOW);
        LIME_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIME);
        LIME_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIME);
        LIME_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIME);
        PINK_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.PINK);
        PINK_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.PINK);
        PINK_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.PINK);
        GRAY_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.GRAY);
        GRAY_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.GRAY);
        GRAY_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIGHT_GRAY);
        CYAN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.CYAN);
        CYAN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.CYAN);
        CYAN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.CYAN);
        PURPLE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.PURPLE);
        PURPLE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.PURPLE);
        PURPLE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.PURPLE);
        BLUE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BLUE);
        BLUE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BLUE);
        BLUE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BLUE);
        BROWN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BROWN);
        BROWN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BROWN);
        BROWN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BROWN);
        GREEN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.GREEN);
        GREEN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.GREEN);
        GREEN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.GREEN);
        RED_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.RED);
        RED_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.RED);
        RED_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.RED);
        BLACK_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BLACK);
        BLACK_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BLACK);
        BLACK_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BLACK);
        WHITE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.WHITE);
        WHITE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.WHITE);
        WHITE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.WHITE);
        ORANGE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.ORANGE);
        ORANGE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.ORANGE);
        ORANGE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.ORANGE);
        MagentaWoolStairs = BVBlocks.regWoolStairs(DyeColor.MAGENTA);
        MagentaWoolSlab = BVBlocks.regWoolSlab(DyeColor.MAGENTA);
        MagentaWoolWall = BVBlocks.regWoolWall(DyeColor.MAGENTA);
        LightBlueWoolStairs = BVBlocks.regWoolStairs(DyeColor.LIGHT_BLUE);
        LightBlueWoolSlab = BVBlocks.regWoolSlab(DyeColor.LIGHT_BLUE);
        LightBlueWoolWall = BVBlocks.regWoolWall(DyeColor.LIGHT_BLUE);
        YellowWoolStairs = BVBlocks.regWoolStairs(DyeColor.YELLOW);
        YellowWoolSlab = BVBlocks.regWoolSlab(DyeColor.YELLOW);
        YellowWoolWall = BVBlocks.regWoolWall(DyeColor.YELLOW);
        LimeWoolStairs = BVBlocks.regWoolStairs(DyeColor.LIME);
        LimeWoolSlab = BVBlocks.regWoolSlab(DyeColor.LIME);
        LimeWoolWall = BVBlocks.regWoolWall(DyeColor.LIME);
        PinkWoolStairs = BVBlocks.regWoolStairs(DyeColor.PINK);
        PinkWoolSlab = BVBlocks.regWoolSlab(DyeColor.PINK);
        PinkWoolWall = BVBlocks.regWoolWall(DyeColor.PINK);
        GrayWoolStairs = BVBlocks.regWoolStairs(DyeColor.GRAY);
        GrayWoolSlab = BVBlocks.regWoolSlab(DyeColor.GRAY);
        GrayWoolWall = BVBlocks.regWoolWall(DyeColor.GRAY);
        LightGrayWoolStairs = BVBlocks.regWoolStairs(DyeColor.LIGHT_GRAY);
        LightGrayWoolSlab = BVBlocks.regWoolSlab(DyeColor.LIGHT_GRAY);
        LightGrayWoolWall = BVBlocks.regWoolWall(DyeColor.LIGHT_GRAY);
        CYAN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.CYAN);
        CYAN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.CYAN);
        CYAN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.CYAN);
        PURPLE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.PURPLE);
        PURPLE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.PURPLE);
        PURPLE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.PURPLE);
        BLUE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BLUE);
        BLUE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BLUE);
        BLUE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BLUE);
        BROWN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BROWN);
        BROWN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BROWN);
        BROWN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BROWN);
        GREEN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.GREEN);
        GREEN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.GREEN);
        GREEN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.GREEN);
        RED_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.RED);
        RED_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.RED);
        RED_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.RED);
        BLACK_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BLACK);
        BLACK_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BLACK);
        BLACK_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BLACK);
        PACKED_MUD_STAIRS = BVBlocks.register("packed_mud_stairs", () -> BlockRegisterHelper.stair((Block)Blocks.PACKED_MUD));
        PACKED_MUD_SLAB = BVBlocks.register("packed_mud_slab", () -> BVBlocks.slab(Blocks.PACKED_MUD));
        PACKED_MUD_WALL = BVBlocks.register("packed_mud_wall", () -> BVBlocks.wall(Blocks.PACKED_MUD));
    }
}

