/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.data.provider;

import com.ametrinstudios.ametrin.data.provider.ExtendedItemTagsProvider;
import com.barion.block_variants.block.StrippableSlabBlock;
import com.barion.block_variants.block.StrippableStairBlock;
import com.barion.block_variants.block.StrippableWallBlock;
import com.barion.block_variants.registry.BVBlocks;
import com.barion.block_variants.registry.BVItems;
import com.barion.block_variants.registry.BVTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public final class BVItemTagsProvider
extends ExtendedItemTagsProvider {
    public BVItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> provider, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, provider, "block_variants", existingFileHelper);
        this.itemTagProviderRules.add((item, name) -> {
            if (!name.contains("wool")) {
                return;
            }
            if (name.contains("stairs")) {
                this.tag(BVTags.Items.WOOL_STAIRS).add((Object)item);
            } else if (name.contains("slab")) {
                this.tag(BVTags.Items.WOOL_SLABS).add((Object)item);
            } else if (name.contains("wall")) {
                this.tag(BVTags.Items.WOOL_WALLS).add((Object)item);
            }
        });
    }

    protected void addTags(@NotNull HolderLookup.Provider lookupProvider) {
        this.runRules(BVItems.REGISTER);
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.copy(BlockTags.WALLS, ItemTags.WALLS);
        this.copy(BlockTags.FENCES, ItemTags.FENCES);
        this.copy(BlockTags.FENCE_GATES, ItemTags.FENCE_GATES);
        this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
        this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
        this.copy(BVTags.Blocks.WOODEN_WALLS, BVTags.Items.WOODEN_WALLS);
        this.copy(BlockTags.WOODEN_FENCES, ItemTags.WOODEN_FENCES);
        this.copy(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.tag(BVTags.Items.STONE_CRAFTING).addTags(new TagKey[]{ItemTags.STONE_CRAFTING_MATERIALS, Tags.Items.STONES});
        this.tag(ItemTags.NON_FLAMMABLE_WOOD).add((Object[])new Item[]{((StrippableStairBlock)((Object)BVBlocks.CRIMSON_HYPHAE_STAIRS.get())).asItem(), ((StrippableSlabBlock)((Object)BVBlocks.CRIMSON_HYPHAE_SLAB.get())).asItem(), ((StrippableWallBlock)((Object)BVBlocks.CRIMSON_HYPHAE_WALL.get())).asItem(), ((StrippableStairBlock)((Object)BVBlocks.WARPED_HYPHAE_STAIRS.get())).asItem(), ((StrippableSlabBlock)((Object)BVBlocks.WARPED_HYPHAE_SLAB.get())).asItem(), ((StrippableWallBlock)((Object)BVBlocks.WARPED_HYPHAE_WALL.get())).asItem(), ((WallBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_WALL.get()).asItem(), ((SlabBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_SLAB.get()).asItem(), ((SlabBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_SLAB.get()).asItem(), ((StairBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_STAIRS.get()).asItem(), ((StairBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_STAIRS.get()).asItem(), ((WallBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_WALL.get()).asItem()});
    }
}

