/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.data.provider;

import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.provider.ExtendedItemModelProvider;
import com.barion.block_variants.BVUtil;
import com.barion.block_variants.registry.BVBlocks;
import com.barion.block_variants.registry.BVItems;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class BVItemModelProvider
extends ExtendedItemModelProvider {
    public BVItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "block_variants", existingFileHelper);
        this.excludedClasses.add(BlockItem.class);
    }

    protected void registerModels() {
        this.runProviderRules(BVItems.REGISTER);
        this.blocks(BVBlocks.getAllBlocks());
    }

    private <B extends Block> void blocks(Iterator<B> blocks) {
        block5: while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            String textureName = BVUtil.getBlockName(block);
            String name = BVUtil.getBlockName(block);
            if (textureName.contains("wood")) {
                textureName = textureName.replace("wood", "log");
            }
            if (textureName.contains("hyphae")) {
                textureName = textureName.replace("hyphae", "stem");
            }
            Block block2 = block;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WallBlock.class, FenceBlock.class, FenceGateBlock.class}, (Object)block2, n)) {
                case 0: {
                    WallBlock wallBlock = (WallBlock)block2;
                    ResourceLocation texture = Objects.equals(textureName, "quartz_wall") ? this.blockTexture(textureName.replace("_wall", "_block_top")) : (DataProviderExtensions.shouldAppendS((String)textureName) ? this.blockTexture(textureName.replace("_wall", "s")) : (BVUtil.shouldAppendBlock(textureName) ? this.blockTexture(textureName.replace("wall", "block")) : (Objects.equals(textureName, "smooth_quartz_wall") ? this.blockTexture(textureName.replace("_wall", "_block_bottom").replace("smooth_", "")) : (BVUtil.isBasalt(textureName) ? this.blockTexture(textureName.replace("wall", "side")) : this.blockTexture(textureName.replace("_wall", ""))))));
                    this.wallInventory(name, texture);
                    continue block5;
                }
                case 1: {
                    FenceBlock fenceBlock = (FenceBlock)block2;
                    ResourceLocation texture = DataProviderExtensions.shouldAppendS((String)textureName) ? this.blockTexture(textureName.replace("_fence", "s")) : (DataProviderExtensions.isWood((String)name) || name.contains("bamboo") ? this.blockTexture(textureName.replace("_fence", "")) : this.blockTexture(textureName.replace("_fence", "_planks")));
                    this.fenceInventory(name, texture);
                    continue block5;
                }
                case 2: {
                    FenceGateBlock fenceGateBlock = (FenceGateBlock)block2;
                    ResourceLocation texture = DataProviderExtensions.shouldAppendS((String)textureName) ? this.blockTexture(textureName.replace("_fence_gate", "s")) : (DataProviderExtensions.isWood((String)name) || name.contains("bamboo") ? this.blockTexture(textureName.replace("_fence_gate", "")) : this.blockTexture(textureName.replace("_fence_gate", "_planks")));
                    this.fenceGate(name, texture);
                    continue block5;
                }
            }
            this.withExistingParent(name, this.modBlockLoc(name));
        }
    }

    private ResourceLocation blockTexture(String texture) {
        return this.mcLoc("block/" + texture);
    }
}

