/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.data.provider;

import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.provider.ExtendedBlockStateProvider;
import com.barion.block_variants.BVUtil;
import com.barion.block_variants.registry.BVBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class BVBlockStateProvider
extends ExtendedBlockStateProvider {
    public BVBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "block_variants", existingFileHelper);
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!name.contains("chiseled_quartz")) {
                return false;
            }
            if (block instanceof StairBlock) {
                this.stairsBlock((StairBlock)block, this.modBlockLoc("chiseled_quartz_block"), this.modBlockLoc("chiseled_quartz_block_top"), this.modBlockLoc("chiseled_quartz_block_top"));
            } else if (block instanceof SlabBlock) {
                this.slabBlock((SlabBlock)block, this.modBlockLoc("chiseled_quartz_block"), this.modBlockLoc("chiseled_quartz_block"), this.modBlockLoc("chiseled_quartz_block_top"), this.modBlockLoc("chiseled_quartz_block_top"));
            } else if (block instanceof WallBlock) {
                this.wallBlock((WallBlock)block, this.modBlockLoc("chiseled_quartz_block"));
            } else {
                return false;
            }
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!name.contains("smooth_stone") || !(block instanceof StairBlock)) {
                return false;
            }
            this.stairsBlock((StairBlock)block, this.modBlockLoc("smooth_stone_slab_side"), this.modBlockLoc("smooth_stone"), this.modBlockLoc("smooth_stone"));
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!BVUtil.isCutSandstone(name) || !(block instanceof StairBlock)) {
                return false;
            }
            ResourceLocation topTexture = this.modBlockLoc(texture.replace("cut_", "").replace("stairs", "top"));
            this.stairsBlock((StairBlock)block, this.modBlockLoc(texture.replace("_stairs", "")), topTexture, topTexture);
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!BVUtil.isBasalt(name)) {
                return false;
            }
            if (block instanceof StairBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("stairs", "top"));
                this.stairsBlock((StairBlock)block, this.modBlockLoc(texture.replace("stairs", "side")), top, top);
            } else if (block instanceof SlabBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("slab", "top"));
                this.slabBlock((SlabBlock)block, this.modBlockLoc(texture.replace("_slab", "")), this.modBlockLoc(texture.replace("slab", "side")), top, top);
            } else if (block instanceof WallBlock) {
                this.wallBlock((WallBlock)block, this.modBlockLoc(texture.replace("wall", "side")));
            } else {
                return false;
            }
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!DataProviderExtensions.isLog((String)name)) {
                return false;
            }
            if (block instanceof StairBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("stairs", "top"));
                this.stairsBlock((StairBlock)block, this.modBlockLoc(texture.replace("_stairs", "")), top, top);
            } else if (block instanceof SlabBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("slab", "top"));
                this.slabBlock((SlabBlock)block, this.modBlockLoc(texture.replace("_slab", "")), this.modBlockLoc(texture.replace("_slab", "")), top, top);
            } else {
                return false;
            }
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (block != BVBlocks.QUARTZ_WALL.get()) {
                return false;
            }
            this.wallBlock((WallBlock)block, this.modBlockLoc(texture.replace("_wall", "_block_top")));
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (block != BVBlocks.SMOOTH_QUARTZ_WALL.get()) {
                return false;
            }
            this.wallBlock((WallBlock)block, this.modBlockLoc(texture.replace("_wall", "_block_bottom").replace("smooth_", "")));
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (block != BVBlocks.PURPUR_WALL.get()) {
                return false;
            }
            this.wallBlock((WallBlock)block, this.modBlockLoc(texture.replace("wall", "block")));
            return true;
        });
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!name.contains("bamboo")) {
                return false;
            }
            if (block instanceof StairBlock) {
                texture = texture.replace("_stairs", "");
                ResourceLocation side = this.modBlockLoc(texture);
                ResourceLocation top = this.modBlockLoc(texture + "_top");
                this.stairsBlock((StairBlock)block, side, top, top);
                return true;
            }
            if (block instanceof SlabBlock) {
                texture = texture.replace("_slab", "");
                ResourceLocation side = this.modBlockLoc(texture);
                ResourceLocation top = this.modBlockLoc(texture + "_top");
                this.slabBlock((SlabBlock)block, side, side, top, top);
                return true;
            }
            return false;
        });
    }

    protected void registerStatesAndModels() {
        this.runProviderRules(BVBlocks.REGISTER);
    }

    protected String getTextureLocation(String name) {
        if (name.contains("wood")) {
            name = name.replace("wood", "log");
        }
        if (name.contains("hyphae")) {
            name = name.replace("hyphae", "stem");
        }
        return name;
    }

    protected ResourceLocation modBlockLoc(String key) {
        return this.mcLoc("block/" + key);
    }
}

