/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.property.BigIntegerProperty;
import dev.ftb.mods.ftbteams.api.property.BooleanProperty;
import dev.ftb.mods.ftbteams.api.property.ColorProperty;
import dev.ftb.mods.ftbteams.api.property.DoubleProperty;
import dev.ftb.mods.ftbteams.api.property.EnumProperty;
import dev.ftb.mods.ftbteams.api.property.IntProperty;
import dev.ftb.mods.ftbteams.api.property.PrivacyMode;
import dev.ftb.mods.ftbteams.api.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.api.property.StringListProperty;
import dev.ftb.mods.ftbteams.api.property.StringMapProperty;
import dev.ftb.mods.ftbteams.api.property.StringProperty;
import dev.ftb.mods.ftbteams.api.property.StringSetProperty;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TeamPropertyType<T> {
    private static final Map<ResourceLocation, TeamPropertyType<?>> MAP = new ConcurrentHashMap();
    public static final TeamPropertyType<Boolean> BOOLEAN = TeamPropertyType.register("boolean", BooleanProperty::fromNetwork);
    public static final TeamPropertyType<String> STRING = TeamPropertyType.register("string", StringProperty::fromNetwork);
    public static final TeamPropertyType<List<String>> STRING_LIST = TeamPropertyType.register("string_list", StringListProperty::fromNetwork);
    public static final TeamPropertyType<Set<String>> STRING_SET = TeamPropertyType.register("string_set", StringSetProperty::fromNetwork);
    public static final TeamPropertyType<Integer> INT = TeamPropertyType.register("int", IntProperty::fromNetwork);
    public static final TeamPropertyType<Double> DOUBLE = TeamPropertyType.register("double", DoubleProperty::fromNetwork);
    public static final TeamPropertyType<Color4I> COLOR = TeamPropertyType.register("color", ColorProperty::fromNetwork);
    public static final TeamPropertyType<String> ENUM = TeamPropertyType.register("enum", EnumProperty::fromNetwork);
    public static final TeamPropertyType<PrivacyMode> PRIVACY_MODE = TeamPropertyType.register("privacy_mode", PrivacyProperty::fromNetwork);
    public static final TeamPropertyType<BigInteger> BIG_INTEGER = TeamPropertyType.register("big_integer", BigIntegerProperty::fromNetwork);
    public static final TeamPropertyType<Map<String, Integer>> INT_MAP = TeamPropertyType.register("int_map", StringMapProperty.ToInteger::fromNetwork);
    public static final TeamPropertyType<Map<String, Boolean>> BOOL_MAP = TeamPropertyType.register("bool_map", StringMapProperty.ToBoolean::fromNetwork);
    public static final TeamPropertyType<Map<String, String>> STRING_MAP = TeamPropertyType.register("string_map", StringMapProperty.ToString::fromNetwork);
    private final ResourceLocation id;
    private final FromNet<T> deserializer;

    private TeamPropertyType(ResourceLocation id, FromNet<T> deserializer) {
        this.id = id;
        this.deserializer = deserializer;
    }

    public static TeamProperty<?> read(RegistryFriendlyByteBuf buf) {
        ResourceLocation typeId = buf.readResourceLocation();
        ResourceLocation propId = buf.readResourceLocation();
        boolean playerEditable = buf.readBoolean();
        TeamProperty prop = TeamPropertyType.MAP.get((Object)typeId).deserializer.apply(propId, buf);
        return playerEditable ? prop : prop.notPlayerEditable();
    }

    public static void write(RegistryFriendlyByteBuf buf, TeamProperty<?> prop) {
        buf.writeResourceLocation(prop.getType().id);
        buf.writeResourceLocation(prop.id);
        buf.writeBoolean(prop.isPlayerEditable());
        prop.write(buf);
    }

    private static <Y> TeamPropertyType<Y> register(String id, FromNet<Y> deserializer) {
        return TeamPropertyType.register(FTBTeamsAPI.rl(id), deserializer);
    }

    public static <Y> TeamPropertyType<Y> register(ResourceLocation id, FromNet<Y> deserializer) {
        TeamPropertyType<Y> t = new TeamPropertyType<Y>(id, deserializer);
        if (MAP.containsKey(id)) {
            throw new IllegalStateException("team property type '" + String.valueOf(id) + "' is already registered!");
        }
        MAP.put(id, t);
        return t;
    }

    public static interface FromNet<Y> {
        public TeamProperty<Y> apply(ResourceLocation var1, RegistryFriendlyByteBuf var2);
    }
}

