/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.util;

import it.hurts.octostudios.octolib.client.animation.easing.Interpolator;
import it.hurts.octostudios.octolib.util.OctoColor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class AnimationUtils {
    private static final Map<Class<?>, Interpolator<?>> INTERPOLATOR_REGISTRY = new HashMap();
    public static final Interpolator<Double> DOUBLE = AnimationUtils.register(Double.class, (from, to, t) -> from + (to - from) * t);
    public static final Interpolator<Float> FLOAT = AnimationUtils.register(Float.class, (from, to, t) -> Float.valueOf(from.floatValue() + (to.floatValue() - from.floatValue()) * (float)t));
    public static final Interpolator<OctoColor> COLOR = AnimationUtils.register(OctoColor.class, OctoColor::lerp);
    public static final Interpolator<Vec2> VEC2 = AnimationUtils.register(Vec2.class, (from, to, t) -> new Vec2(FLOAT.lerp(Float.valueOf(from.x), Float.valueOf(to.x), t).floatValue(), FLOAT.lerp(Float.valueOf(from.y), Float.valueOf(to.y), t).floatValue()));
    public static final Interpolator<Vec3> VEC3 = AnimationUtils.register(Vec3.class, Vec3::lerp);
    public static final Interpolator<Vector2d> VECTOR2D = AnimationUtils.register(Vector2d.class, Vector2d::lerp);
    public static final Interpolator<Vector3d> VECTOR3D = AnimationUtils.register(Vector3d.class, Vector3d::lerp);
    public static final Interpolator<Vector2f> VECTOR2F = AnimationUtils.register(Vector2f.class, (from, to, t) -> new Vector2f(FLOAT.lerp(Float.valueOf(from.x), Float.valueOf(to.x), t).floatValue(), FLOAT.lerp(Float.valueOf(from.y), Float.valueOf(to.y), t).floatValue()));
    public static final Interpolator<Vector3f> VECTOR3F = AnimationUtils.register(Vector3f.class, (from, to, t) -> new Vector3f(FLOAT.lerp(Float.valueOf(from.x), Float.valueOf(to.x), t).floatValue(), FLOAT.lerp(Float.valueOf(from.y), Float.valueOf(to.y), t).floatValue(), FLOAT.lerp(Float.valueOf(from.z), Float.valueOf(to.z), t).floatValue()));
    private static final Map<Class<?>, BinaryOperator<?>> ADD_REGISTRY = new HashMap();
    private static final Map<Class<?>, BinaryOperator<?>> SUBTRACT_REGISTRY = new HashMap();

    public static <T> T lerp(T from, T to, double t) {
        Class<?> classTo;
        if (from == null || to == null) {
            throw new IllegalArgumentException("Lerp arguments cannot be null");
        }
        Class<?> classFrom = from.getClass();
        if (!classFrom.equals(classTo = to.getClass())) {
            if (AnimationUtils.isNum(from) && AnimationUtils.isNum(to)) {
                Class<? extends Number> numClass = AnimationUtils.getCompatibleNumberType((Number)from, (Number)to);
                if (numClass == Double.class) {
                    double dFrom = ((Number)from).doubleValue();
                    double dTo = ((Number)to).doubleValue();
                    Double result = DOUBLE.lerp(dFrom, dTo, t);
                    return (T)result;
                }
                float fFrom = ((Number)from).floatValue();
                float fTo = ((Number)to).floatValue();
                Float result = FLOAT.lerp(Float.valueOf(fFrom), Float.valueOf(fTo), t);
                return (T)result;
            }
            throw new IllegalArgumentException("Lerp types must match");
        }
        Interpolator<?> interpolator = INTERPOLATOR_REGISTRY.get(classFrom);
        if (interpolator == null) {
            throw new IllegalArgumentException("No interpolator registered for " + classFrom.getName());
        }
        return (T)interpolator.lerp(from, to, t);
    }

    public static <T> T add(T first, T second) {
        Class<?> classSecond;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Add arguments cannot be null");
        }
        Class<?> classFirst = first.getClass();
        if (!classFirst.equals(classSecond = second.getClass())) {
            if (AnimationUtils.isNum(first) && AnimationUtils.isNum(second)) {
                Class<? extends Number> numClass = AnimationUtils.getCompatibleNumberType((Number)first, (Number)second);
                if (numClass == Double.class) {
                    double a = ((Number)first).doubleValue();
                    double b = ((Number)second).doubleValue();
                    Double result = a + b;
                    return (T)result;
                }
                float a = ((Number)first).floatValue();
                float b = ((Number)second).floatValue();
                Float result = Float.valueOf(a + b);
                return (T)result;
            }
            throw new IllegalArgumentException("Add types must match or both be numbers");
        }
        BinaryOperator<?> op = ADD_REGISTRY.get(classFirst);
        if (op == null) {
            throw new IllegalArgumentException("No add operation registered for " + classFirst.getName());
        }
        return (T)op.apply(first, second);
    }

    public static <T> T subtract(T first, T second) {
        Class<?> classSecond;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Subtract arguments cannot be null");
        }
        Class<?> classFirst = first.getClass();
        if (!classFirst.equals(classSecond = second.getClass())) {
            if (AnimationUtils.isNum(first) && AnimationUtils.isNum(second)) {
                Class<? extends Number> numClass = AnimationUtils.getCompatibleNumberType((Number)first, (Number)second);
                if (numClass == Double.class) {
                    double a = ((Number)first).doubleValue();
                    double b = ((Number)second).doubleValue();
                    Double result = a - b;
                    return (T)result;
                }
                float a = ((Number)first).floatValue();
                float b = ((Number)second).floatValue();
                Float result = Float.valueOf(a - b);
                return (T)result;
            }
            throw new IllegalArgumentException("Subtract types must match or both be numbers");
        }
        BinaryOperator<?> op = SUBTRACT_REGISTRY.get(classFirst);
        if (op == null) {
            throw new IllegalArgumentException("No subtract operation registered for " + classFirst.getName());
        }
        return (T)op.apply(first, second);
    }

    private static <T> void registerAdd(Class<T> clazz, BinaryOperator<T> op) {
        ADD_REGISTRY.put(clazz, op);
    }

    private static <T> void registerSubtract(Class<T> clazz, BinaryOperator<T> op) {
        SUBTRACT_REGISTRY.put(clazz, op);
    }

    private static <T> Interpolator<T> register(Class<T> clazz, Interpolator<T> interpolator) {
        INTERPOLATOR_REGISTRY.put(clazz, interpolator);
        return interpolator;
    }

    private static boolean isNum(Object obj) {
        return obj instanceof Number;
    }

    private static Class<? extends Number> getCompatibleNumberType(Number first, Number second) {
        boolean isDoublePresent = first instanceof Double || second instanceof Double;
        return isDoublePresent ? Double.class : Float.class;
    }

    static {
        AnimationUtils.registerAdd(Double.class, Double::sum);
        AnimationUtils.registerSubtract(Double.class, (a, b) -> a - b);
        AnimationUtils.registerAdd(Float.class, Float::sum);
        AnimationUtils.registerSubtract(Float.class, (a, b) -> Float.valueOf(a.floatValue() - b.floatValue()));
        AnimationUtils.registerAdd(OctoColor.class, OctoColor::add);
        AnimationUtils.registerSubtract(OctoColor.class, OctoColor::subtract);
        AnimationUtils.registerAdd(Vec2.class, (a, b) -> new Vec2(a.x + b.x, a.y + b.y));
        AnimationUtils.registerSubtract(Vec2.class, (a, b) -> new Vec2(a.x - b.x, a.y - b.y));
        AnimationUtils.registerAdd(Vec3.class, Vec3::add);
        AnimationUtils.registerSubtract(Vec3.class, Vec3::subtract);
        AnimationUtils.registerAdd(Vector2d.class, (a, b) -> new Vector2d(a.x + b.x, a.y + b.y));
        AnimationUtils.registerSubtract(Vector2d.class, (a, b) -> new Vector2d(a.x - b.x, a.y - b.y));
        AnimationUtils.registerAdd(Vector3d.class, (a, b) -> new Vector3d(a.x + b.x, a.y + b.y, a.z + b.z));
        AnimationUtils.registerSubtract(Vector3d.class, (a, b) -> new Vector3d(a.x - b.x, a.y - b.y, a.z - b.z));
        AnimationUtils.registerAdd(Vector2f.class, (a, b) -> new Vector2f(a.x + b.x, a.y + b.y));
        AnimationUtils.registerSubtract(Vector2f.class, (a, b) -> new Vector2f(a.x - b.x, a.y - b.y));
        AnimationUtils.registerAdd(Vector3f.class, (a, b) -> new Vector3f(a.x + b.x, a.y + b.y, a.z + b.z));
        AnimationUtils.registerSubtract(Vector3f.class, (a, b) -> new Vector3f(a.x - b.x, a.y - b.y, a.z - b.z));
    }
}

