/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.util.common;

import com.reggarf.mods.better_lib.util.common.BaseRow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public abstract class BaseScrollArea<R extends BaseRow>
extends AbstractWidget {
    protected final List<R> rows = new ArrayList<R>();
    protected int scroll = 0;
    protected final int rowHeight;

    public BaseScrollArea(int x, int y, int w, int h, int rowHeight) {
        super(x, y, w, h, (Component)Component.empty());
        this.rowHeight = rowHeight;
    }

    public void clear() {
        this.rows.clear();
        this.scroll = 0;
    }

    public void addRow(R row) {
        this.rows.add(row);
    }

    protected void updateWidgetNarration(NarrationElementOutput n) {
    }

    public boolean mouseScrolled(double mx, double my, double dx, double dy) {
        int total = this.rows.size() * this.rowHeight;
        int max = Math.max(0, total - this.height);
        this.scroll = Mth.clamp((int)(this.scroll - (int)(dy * 20.0)), (int)0, (int)max);
        return true;
    }

    public boolean mouseClicked(double mx, double my, int btn) {
        if (btn != 0) {
            return false;
        }
        int y = this.getY() - this.scroll;
        for (BaseRow row : this.rows) {
            if (my >= (double)y && my <= (double)(y + this.rowHeight) && mx >= (double)this.getX() && mx <= (double)(this.getX() + this.width) && row.click(mx, my)) {
                return true;
            }
            y += this.rowHeight;
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int btn) {
        for (BaseRow row : this.rows) {
            if (!row.mouseReleased(mx, my, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mx, double my, int btn, double dx, double dy) {
        for (BaseRow row : this.rows) {
            if (!row.mouseDragged(mx, my, btn, dx, dy)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (BaseRow row : this.rows) {
            if (!row.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (BaseRow row : this.rows) {
            if (!row.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics gfx, int mx, int my, float pt) {
        int y = this.getY() - this.scroll;
        int top = this.getY();
        int bottom = this.getY() + this.height;
        for (BaseRow row : this.rows) {
            if (y + this.rowHeight > top && y < bottom) {
                row.render(gfx, this.getX(), y, this.width, this.rowHeight, mx, my);
            }
            y += this.rowHeight;
        }
        this.drawScrollbar(gfx);
    }

    private void drawScrollbar(GuiGraphics gfx) {
        int total = this.rows.size() * this.rowHeight;
        if (total <= this.height) {
            return;
        }
        int barX = this.getX() + this.width - 8;
        gfx.fill(barX, this.getY(), barX + 6, this.getY() + this.height, 0x44000000);
        float p = (float)this.scroll / (float)(total - this.height);
        int thumb = Math.max(20, this.height * this.height / total);
        int ty = this.getY() + (int)((float)(this.height - thumb) * p);
        gfx.fill(barX, ty, barX + 6, ty + thumb, -22016);
    }
}

