/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.message.util;

import com.reggarf.mods.better_lib.message.api.OnlineMessagePlugin;
import com.reggarf.mods.better_lib.message.event.OnlineMessageSet;
import com.reggarf.mods.better_lib.message.util.OnlineMessageFetcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;

public final class OnlineMessageHandler {
    private static final Map<String, OnlineMessageSet> CACHE = new ConcurrentHashMap<String, OnlineMessageSet>();
    private static final Map<String, Boolean> ENABLED = new ConcurrentHashMap<String, Boolean>();

    private OnlineMessageHandler() {
    }

    public static void initializeFor(String modId, OnlineMessagePlugin plugin) {
        boolean enabled = plugin.isOnlineMessageEnabled();
        ENABLED.put(modId, enabled);
        if (!enabled) {
            return;
        }
        OnlineMessageSet set = OnlineMessageHandler.fetchAndBuildMessages(plugin);
        CACHE.put(modId, set);
    }

    public static void refreshMessages(String modId, OnlineMessagePlugin plugin) {
        if (!ENABLED.getOrDefault(modId, true).booleanValue()) {
            return;
        }
        CACHE.put(modId, OnlineMessageHandler.fetchAndBuildMessages(plugin));
    }

    public static void onPlayerJoin(ServerPlayer player) {
        for (Map.Entry<String, OnlineMessageSet> entry : CACHE.entrySet()) {
            OnlineMessageSet set;
            String modId = entry.getKey();
            if (!ENABLED.getOrDefault(modId, true).booleanValue() || (set = entry.getValue()) == null) continue;
            String hash = set.hash();
            String tag = "better_lib:online_" + modId + "_" + hash;
            if (player.getTags().contains(tag)) continue;
            set.sendTo(player);
            player.addTag(tag);
        }
    }

    private static OnlineMessageSet fetchAndBuildMessages(OnlineMessagePlugin plugin) {
        String messageData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getMessageUrl());
        String clickableData = OnlineMessageFetcher.fetchOnlineMessage(plugin.getClickableUrl());
        OnlineMessageSet set = new OnlineMessageSet();
        for (String line : messageData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            set.addText(line, "#FFFFFF");
        }
        for (String line : clickableData.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] p = line.split("\\|");
            set.addLink(p.length > 0 ? p[0].trim() : "Link", p.length > 1 ? p[1].trim() : "", p.length > 2 ? p[2].trim() : "#00FF00", p.length > 3 ? p[3].trim() : "");
        }
        return set;
    }
}

