/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.message.event;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;

public class OnlineMessageSet {
    private final List<Component> messages = new ArrayList<Component>();

    public OnlineMessageSet addText(String text, String colorHex) {
        this.messages.add((Component)Component.literal((String)text).setStyle(Style.EMPTY.withColor(this.parseColor(colorHex))));
        return this;
    }

    public OnlineMessageSet addLink(String label, String url, String colorHex, String description) {
        ClickEvent clickEvent = this.createUrlClickEvent(url);
        MutableComponent comp = Component.literal((String)" - ").append((Component)Component.literal((String)label).setStyle(Style.EMPTY.withClickEvent(clickEvent).withColor(this.parseColor(colorHex)).withUnderlined(Boolean.valueOf(true)))).append((Component)Component.literal((String)(description != null && !description.isEmpty() ? " " + description : "")));
        this.messages.add((Component)comp);
        return this;
    }

    public OnlineMessageSet addBlankLine() {
        this.messages.add((Component)Component.literal((String)""));
        return this;
    }

    public void sendTo(ServerPlayer player) {
        for (Component msg : this.messages) {
            player.sendSystemMessage(msg);
        }
    }

    public String hash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder sb = new StringBuilder();
            for (Component msg : this.messages) {
                sb.append(msg.getString());
            }
            byte[] hash = digest.digest(sb.toString().getBytes());
            StringBuilder hex = new StringBuilder();
            for (byte b : hash) {
                hex.append(String.format("%02x", b));
            }
            return hex.toString();
        }
        catch (Exception e) {
            return String.valueOf(this.messages.hashCode());
        }
    }

    private TextColor parseColor(String hex) {
        try {
            if (hex == null) {
                return TextColor.fromRgb((int)0xFFFFFF);
            }
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            int rgb = Integer.parseInt(hex, 16);
            return TextColor.fromRgb((int)rgb);
        }
        catch (Exception e) {
            return TextColor.fromRgb((int)0xFFFFFF);
        }
    }

    private ClickEvent createUrlClickEvent(String url) {
        try {
            Class<?> openUrlClass = Class.forName("net.minecraft.network.chat.ClickEvent$OpenUrl");
            Constructor<?> ctor = openUrlClass.getConstructor(URI.class);
            return (ClickEvent)ctor.newInstance(URI.create(url));
        }
        catch (Throwable ignored) {
            return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        }
    }
}

