/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.config.gui;

import com.reggarf.mods.better_lib.config.annotation.Config;
import com.reggarf.mods.better_lib.config.core.BetterConfigManager;
import com.reggarf.mods.better_lib.config.helper.BetterEntryBuilder;
import com.reggarf.mods.better_lib.config.helper.ColorButton;
import com.reggarf.mods.better_lib.config.helper.ConfigPermissionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class BetterConfigScreen
extends Screen {
    private final Screen parent;
    private final Object config;
    private final List<BetterEntryBuilder> entries;
    private final String configName;
    private final ResourceLocation background;
    private final List<WidgetData> widgetData = new ArrayList<WidgetData>();
    private final Map<String, String> cachedTextValues = new HashMap<String, String>();
    private ConfigScrollArea scrollArea;
    private final Minecraft mc = Minecraft.getInstance();
    private boolean canEditServerConfig;

    public BetterConfigScreen(Screen parent, Component title, Object config, List<BetterEntryBuilder> entries, String name, String bgTexture) {
        super(title);
        this.parent = parent;
        this.config = config;
        this.entries = entries;
        this.configName = name;
        this.background = bgTexture != null ? ResourceLocation.tryParse((String)bgTexture) : null;
    }

    protected void init() {
        this.canEditServerConfig = ConfigPermissionHelper.canClientEditServerConfig(this.mc);
        this.cachedTextValues.clear();
        for (WidgetData wd : this.widgetData) {
            Object object;
            if (!wd.type().equals("text") || !((object = wd.widget()) instanceof EditBox)) continue;
            EditBox eb = (EditBox)object;
            this.cachedTextValues.put(wd.fieldName(), eb.getValue());
        }
        this.widgetData.clear();
        int panelWidth = 250;
        int panelHeight = this.height - 180;
        int centerX = this.width / 2;
        int panelX = centerX - panelWidth / 2;
        int panelY = 90;
        this.scrollArea = new ConfigScrollArea(panelX, panelY, panelWidth, panelHeight);
        String modid = this.configName != null && !this.configName.isEmpty() ? this.configName : "assets/better_lib";
        for (BetterEntryBuilder entry : this.entries) {
            BetterEntryBuilder.EntryData data = entry.build();
            String fieldName = this.sanitizeFieldName(data.label().getString(), modid);
            String labelKey = "config." + modid + "." + fieldName;
            String descriptionKey = labelKey + ".tooltip";
            final Component label = this.getLangOrFallback(labelKey);
            Component tooltipText = this.getTooltipText("General", descriptionKey);
            Object widget = null;
            switch (data.type()) {
                case "bool": {
                    widget = Checkbox.builder((Component)label, (Font)this.font).pos(panelX + 25, 0).selected(((Boolean)data.value()).booleanValue()).build();
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "slider": {
                    final int min = data.min();
                    final int max = data.max();
                    int initial = (Integer)data.value();
                    widget = new AbstractSliderButton(this, panelX + 25, 0, 200, 20, (Component)Component.literal((String)(label.getString() + ": " + initial)), (double)(initial - min) / (double)(max - min)){

                        protected void updateMessage() {
                            int val = (int)((double)min + this.value * (double)(max - min));
                            this.setMessage((Component)Component.literal((String)(label.getString() + ": " + val)));
                        }

                        protected void applyValue() {
                        }
                    };
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "text": {
                    EditBox box = new EditBox(this.font, panelX + 25, 0, 200, 20, label);
                    box.setMaxLength(999999);
                    box.setValue(this.cachedTextValues.getOrDefault(fieldName, data.value().toString()));
                    widget = box;
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    break;
                }
                case "dropdown": {
                    String[] options = data.dropdownValues();
                    int index = 0;
                    for (int i = 0; i < options.length; ++i) {
                        if (!options[i].equals(data.value().toString())) continue;
                        index = i;
                    }
                    int[] currentIndex = new int[]{index};
                    widget = Button.builder((Component)Component.literal((String)(label.getString() + ": " + options[currentIndex[0]])), btn -> {
                        currentIndex[0] = (currentIndex[0] + 1) % options.length;
                        btn.setMessage((Component)Component.literal((String)(label.getString() + ": " + options[currentIndex[0]])));
                    }).pos(panelX + 25, 0).size(200, 20).build();
                    widget.setTooltip(Tooltip.create((Component)tooltipText));
                    this.widgetData.add(new WidgetData(fieldName, "dropdown", widget, options, currentIndex));
                    break;
                }
                case "color": {
                    int color = (Integer)data.value();
                    String colorHex = String.format("#%08X", color);
                    ColorButton btn2 = new ColorButton(panelX + 25, 0, 200, 20, (Component)Component.literal((String)("Color: " + colorHex)), color, b -> {
                        int newColor = (int)(Math.random() * 1.6777215E7) | 0xFF000000;
                        String newHex = String.format("#%08X", newColor);
                        b.setMessage((Component)Component.literal((String)("Color: " + newHex)));
                        ((ColorButton)b).setColor(newColor);
                    });
                    btn2.setTooltip(Tooltip.create((Component)tooltipText));
                    widget = btn2;
                }
            }
            if (widget == null) continue;
            if (!this.canEditServerConfig) {
                widget.active = false;
            }
            this.scrollArea.addEntry((AbstractWidget)widget, 28);
            if (!this.widgetData.stream().noneMatch(w -> w.fieldName().equals(fieldName))) continue;
            this.widgetData.add(new WidgetData(fieldName, data.type(), widget));
        }
        this.addRenderableWidget((GuiEventListener)this.scrollArea);
        Button saveButton = Button.builder((Component)Component.literal((String)"\ud83d\udcbe Save & Close"), b -> this.onSave()).pos(centerX - 105, this.height - 50).size(100, 20).build();
        saveButton.active = this.canEditServerConfig;
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2716 Cancel"), b -> this.minecraft.setScreen(this.parent)).pos(centerX + 5, this.height - 50).size(100, 20).build());
    }

    private void onSave() {
        if (!this.canEditServerConfig) {
            this.minecraft.setScreen(this.parent);
            return;
        }
        try {
            Class<?> configClass = this.config.getClass();
            for (WidgetData data : this.widgetData) {
                Object value;
                Field field = configClass.getDeclaredField(data.fieldName());
                field.setAccessible(true);
                if ((value = (switch (data.type()) {
                    case "bool" -> ((Checkbox)data.widget()).selected();
                    case "slider" -> {
                        String s = ((AbstractSliderButton)data.widget()).getMessage().getString().replaceAll("[^0-9-]", "");
                        yield Integer.parseInt(s);
                    }
                    case "text" -> ((EditBox)data.widget()).getValue();
                    case "dropdown" -> data.options()[data.selectedIndex()[0]];
                    case "color" -> value = Integer.valueOf(((ColorButton)((Object)data.widget())).getColor());
                    default -> null;
                })) == null) continue;
                field.set(this.config, value);
            }
            BetterConfigManager.save(this.getModIdFromConfig(), this.getNameFromConfig(), this.config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minecraft.setScreen(this.parent);
    }

    private String getModIdFromConfig() {
        Config cfg = this.config.getClass().getAnnotation(Config.class);
        return cfg != null ? cfg.modid() : "unknown";
    }

    private String getNameFromConfig() {
        Config cfg = this.config.getClass().getAnnotation(Config.class);
        return cfg != null ? cfg.name() : this.config.getClass().getSimpleName();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollArea.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int centerX = this.width / 2;
        int boxWidth = 260;
        int boxHeight = this.height - 160;
        int boxY = 80;
        int padding = 10;
        graphics.fill(centerX - boxWidth / 2 - padding, boxY - padding, centerX + boxWidth / 2 + padding, boxY + boxHeight + padding, -1442840576);
        graphics.fill(centerX - boxWidth / 2 - padding, 35, centerX + boxWidth / 2 + padding, 65, -1442840576);
        graphics.fill(centerX - boxWidth / 2 - padding, this.height - 60, centerX + boxWidth / 2 + padding, this.height - 20, -1442840576);
        super.render(graphics, mouseX, mouseY, delta);
        String modid = this.configName != null && !this.configName.isEmpty() ? this.configName : "better_lib";
        String titleKey = "config." + modid + ".title";
        MutableComponent title = Language.getInstance().has(titleKey) ? Component.translatable((String)titleKey) : Component.literal((String)(StringUtils.capitalize((String)modid) + " Config"));
        graphics.drawCenteredString(this.font, (Component)title, centerX, 45, -1);
    }

    private Component getLangOrFallback(String key) {
        return I18n.exists((String)key) ? Component.translatable((String)key) : Component.literal((String)key);
    }

    private Component getTooltipText(String category, String tooltipKey) {
        String text = I18n.exists((String)tooltipKey) ? I18n.get((String)tooltipKey, (Object[])new Object[0]) : tooltipKey;
        return Component.literal((String)("\u00a7l" + category + "\u00a7r\n" + text));
    }

    private String sanitizeFieldName(String key, String modid) {
        if ((key = key.trim()).startsWith("config." + modid + ".")) {
            key = key.substring(("config." + modid + ".").length());
        }
        if (key.contains(".tooltip")) {
            key = key.replace(".tooltip", "");
        }
        return key.replaceAll("[^A-Za-z0-9_]", "").trim();
    }

    private record WidgetData(String fieldName, String type, Object widget, String[] options, int[] selectedIndex) {
        public WidgetData(String fieldName, String type, Object widget) {
            this(fieldName, type, widget, new String[0], new int[]{0});
        }
    }

    private static class ConfigScrollArea
    extends AbstractWidget {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int scrollOffset = 0;
        private final int entrySpacing = 28;
        private AbstractWidget focusedWidget;

        public ConfigScrollArea(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
        }

        public void addEntry(AbstractWidget widget, int heightStep) {
            this.entries.add(new Entry(widget, heightStep));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int startY = this.getY() - this.scrollOffset;
            int visibleBottom = this.getY() + this.getHeight();
            for (Entry entry : this.entries) {
                AbstractWidget widget = entry.widget();
                int widgetY = startY;
                if (widgetY + entry.height() > this.getY() && widgetY < visibleBottom) {
                    widget.setY(widgetY);
                    widget.render(graphics, mouseX, mouseY, partialTick);
                }
                startY += entry.height();
            }
            int contentHeight = this.entries.size() * 28;
            if (contentHeight > this.height) {
                int scrollbarWidth = 6;
                int scrollbarX = this.getX() + this.getWidth() - scrollbarWidth - 2;
                int scrollbarY = this.getY();
                int visibleHeight = this.height;
                float progress = (float)this.scrollOffset / (float)(contentHeight - visibleHeight);
                int thumbHeight = Math.max(16, (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight));
                int thumbY = scrollbarY + (int)((float)(visibleHeight - thumbHeight) * progress);
                graphics.fill(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + visibleHeight, 0x44000000);
                graphics.fill(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -1426063361);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.clearFocus();
                return false;
            }
            for (Entry entry : this.entries) {
                AbstractWidget widget = entry.widget();
                if (!widget.visible || !widget.active) continue;
                if (widget.isMouseOver(mouseX, mouseY)) {
                    this.focusedWidget = widget;
                    widget.setFocused(true);
                    return widget.mouseClicked(mouseX, mouseY, button);
                }
                widget.setFocused(false);
            }
            this.focusedWidget = null;
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.focusedWidget != null && this.focusedWidget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.focusedWidget != null && this.focusedWidget.mouseReleased(mouseX, mouseY, button);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.focusedWidget != null && this.focusedWidget.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char codePoint, int modifiers) {
            return this.focusedWidget != null && this.focusedWidget.charTyped(codePoint, modifiers);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            int contentHeight = this.entries.size() * 28;
            int maxScroll = Math.max(0, contentHeight - this.height);
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset - (int)(scrollY * 20.0)), (int)0, (int)maxScroll);
            return true;
        }

        private void clearFocus() {
            if (this.focusedWidget != null) {
                this.focusedWidget.setFocused(false);
                this.focusedWidget = null;
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private record Entry(AbstractWidget widget, int height) {
        }
    }
}

