/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.slf4j.Logger;

public class SetItemDamageFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetItemDamageFunction> CODEC = RecordCodecBuilder.mapCodec(p_298138_ -> SetItemDamageFunction.commonFields(p_298138_).and(p_298138_.group((App)NumberProviders.CODEC.fieldOf("damage").forGetter(p_298141_ -> p_298141_.damage), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(p_298134_ -> p_298134_.add))).apply((Applicative)p_298138_, SetItemDamageFunction::new));
    private final NumberProvider damage;
    private final boolean add;

    private SetItemDamageFunction(List<LootItemCondition> p_298394_, NumberProvider p_165428_, boolean p_165429_) {
        super(p_298394_);
        this.damage = p_165428_;
        this.add = p_165429_;
    }

    public LootItemFunctionType<SetItemDamageFunction> getType() {
        return LootItemFunctions.SET_DAMAGE;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.damage.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack p_81048_, LootContext p_81049_) {
        if (p_81048_.isDamageableItem()) {
            int $$2 = p_81048_.getMaxDamage();
            float $$3 = this.add ? 1.0f - (float)p_81048_.getDamageValue() / (float)$$2 : 0.0f;
            float $$4 = 1.0f - Mth.clamp(this.damage.getFloat(p_81049_) + $$3, 0.0f, 1.0f);
            p_81048_.setDamageValue(Mth.floor($$4 * (float)$$2));
        } else {
            LOGGER.warn("Couldn't set damage of loot item {}", (Object)p_81048_);
        }
        return p_81048_;
    }

    public static LootItemConditionalFunction.Builder<?> setDamage(NumberProvider p_165431_) {
        return SetItemDamageFunction.simpleBuilder(p_298140_ -> new SetItemDamageFunction((List<LootItemCondition>)p_298140_, p_165431_, false));
    }

    public static LootItemConditionalFunction.Builder<?> setDamage(NumberProvider p_165433_, boolean p_165434_) {
        return SetItemDamageFunction.simpleBuilder(p_298137_ -> new SetItemDamageFunction((List<LootItemCondition>)p_298137_, p_165433_, p_165434_));
    }
}

