/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.SingleValuePalette;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private final PaletteResize<T> dummyPaletteResize = (p_238275_, p_238276_) -> 0;
    private final IdMap<T> registry;
    private volatile Data<T> data;
    private final Strategy strategy;
    private final ThreadingDetector threadingDetector = new ThreadingDetector("PalettedContainer");

    public void acquire() {
        this.threadingDetector.checkAndLock();
    }

    public void release() {
        this.threadingDetector.checkAndUnlock();
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> p_238372_, Codec<T> p_238373_, Strategy p_238374_, T p_238375_) {
        PalettedContainerRO.Unpacker $$4 = PalettedContainer::unpack;
        return PalettedContainer.codec(p_238372_, p_238373_, p_238374_, p_238375_, $$4);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(IdMap<T> p_238419_, Codec<T> p_238420_, Strategy p_238421_, T p_238422_) {
        PalettedContainerRO.Unpacker $$4 = (p_338083_, p_338084_, p_338085_) -> PalettedContainer.unpack(p_338083_, p_338084_, p_338085_).map(p_238264_ -> p_238264_);
        return PalettedContainer.codec(p_238419_, p_238420_, p_238421_, p_238422_, $$4);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(IdMap<T> p_238428_, Codec<T> p_238429_, Strategy p_238430_, T p_238431_, PalettedContainerRO.Unpacker<T, C> p_238432_) {
        return RecordCodecBuilder.create(p_338082_ -> p_338082_.group((App)p_238429_.mapResult(ExtraCodecs.orElsePartial(p_238431_)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)p_338082_, PalettedContainerRO.PackedData::new)).comapFlatMap(p_238262_ -> p_238432_.read(p_238428_, p_238430_, (PalettedContainerRO.PackedData)p_238262_), p_238263_ -> p_238263_.pack(p_238428_, p_238430_));
    }

    public PalettedContainer(IdMap<T> p_188035_, Strategy p_188036_, Configuration<T> p_188037_, BitStorage p_188038_, List<T> p_188039_) {
        this.registry = p_188035_;
        this.strategy = p_188036_;
        this.data = new Data<T>(p_188037_, p_188038_, p_188037_.factory().create(p_188037_.bits(), p_188035_, this, p_188039_));
    }

    private PalettedContainer(IdMap<T> p_199928_, Strategy p_199929_, Data<T> p_199930_) {
        this.registry = p_199928_;
        this.strategy = p_199929_;
        this.data = p_199930_;
    }

    public PalettedContainer(IdMap<T> p_188041_, T p_188042_, Strategy p_188043_) {
        this.strategy = p_188043_;
        this.registry = p_188041_;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(p_188042_);
    }

    private Data<T> createOrReuseData(@Nullable Data<T> p_188052_, int p_188053_) {
        Configuration<T> $$2 = this.strategy.getConfiguration(this.registry, p_188053_);
        if (p_188052_ != null && $$2.equals(p_188052_.configuration())) {
            return p_188052_;
        }
        return $$2.createData(this.registry, this, this.strategy.size());
    }

    @Override
    public int onResize(int p_63142_, T p_63143_) {
        Data<T> $$2 = this.data;
        Data $$3 = this.createOrReuseData($$2, p_63142_);
        $$3.copyFrom($$2.palette, $$2.storage);
        this.data = $$3;
        return $$3.palette.idFor(p_63143_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAndSet(int p_63092_, int p_63093_, int p_63094_, T p_63095_) {
        this.acquire();
        try {
            T t = this.getAndSet(this.strategy.getIndex(p_63092_, p_63093_, p_63094_), p_63095_);
            return t;
        }
        finally {
            this.release();
        }
    }

    public T getAndSetUnchecked(int p_63128_, int p_63129_, int p_63130_, T p_63131_) {
        return this.getAndSet(this.strategy.getIndex(p_63128_, p_63129_, p_63130_), p_63131_);
    }

    private T getAndSet(int p_63097_, T p_63098_) {
        int $$2 = this.data.palette.idFor(p_63098_);
        int $$3 = this.data.storage.getAndSet(p_63097_, $$2);
        return this.data.palette.valueFor($$3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int p_156471_, int p_156472_, int p_156473_, T p_156474_) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(p_156471_, p_156472_, p_156473_), p_156474_);
        }
        finally {
            this.release();
        }
    }

    private void set(int p_63133_, T p_63134_) {
        int $$2 = this.data.palette.idFor(p_63134_);
        this.data.storage.set(p_63133_, $$2);
    }

    @Override
    public T get(int p_63088_, int p_63089_, int p_63090_) {
        return this.get(this.strategy.getIndex(p_63088_, p_63089_, p_63090_));
    }

    protected T get(int p_63086_) {
        Data<T> $$1 = this.data;
        return $$1.palette.valueFor($$1.storage.get(p_63086_));
    }

    @Override
    public void getAll(Consumer<T> p_196880_) {
        Palette $$1 = this.data.palette();
        IntArraySet $$2 = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)$$2).add(arg_0));
        $$2.forEach(p_238274_ -> p_196880_.accept($$1.valueFor(p_238274_)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(FriendlyByteBuf p_63119_) {
        this.acquire();
        try {
            byte $$1 = p_63119_.readByte();
            Data<T> $$2 = this.createOrReuseData(this.data, $$1);
            $$2.palette.read(p_63119_);
            p_63119_.readLongArray($$2.storage.getRaw());
            this.data = $$2;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void write(FriendlyByteBuf p_63136_) {
        this.acquire();
        try {
            this.data.write(p_63136_);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> DataResult<PalettedContainer<T>> unpack(IdMap<T> p_188068_, Strategy p_188069_, PalettedContainerRO.PackedData<T> p_238258_) {
        void $$16;
        List<T> $$3 = p_238258_.paletteEntries();
        int $$4 = p_188069_.size();
        int $$5 = p_188069_.calculateBitsForSerialization(p_188068_, $$3.size());
        Configuration<T> $$6 = p_188069_.getConfiguration(p_188068_, $$5);
        if ($$5 == 0) {
            ZeroBitStorage $$7 = new ZeroBitStorage($$4);
        } else {
            Optional<LongStream> $$8 = p_238258_.storage();
            if ($$8.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] $$9 = $$8.get().toArray();
            try {
                if ($$6.factory() == Strategy.GLOBAL_PALETTE_FACTORY) {
                    HashMapPalette<Object> $$10 = new HashMapPalette<Object>(p_188068_, $$5, (p_238278_, p_238279_) -> 0, $$3);
                    SimpleBitStorage $$11 = new SimpleBitStorage($$5, $$4, $$9);
                    int[] $$12 = new int[$$4];
                    $$11.unpack($$12);
                    PalettedContainer.swapPalette($$12, p_238283_ -> p_188068_.getId($$10.valueFor(p_238283_)));
                    SimpleBitStorage $$13 = new SimpleBitStorage($$6.bits(), $$4, $$12);
                } else {
                    SimpleBitStorage $$14 = new SimpleBitStorage($$6.bits(), $$4, $$9);
                }
            }
            catch (SimpleBitStorage.InitializationException $$15) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + $$15.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(p_188068_, p_188069_, $$6, (BitStorage)$$16, $$3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PalettedContainerRO.PackedData<T> pack(IdMap<T> p_188065_, Strategy p_188066_) {
        this.acquire();
        try {
            Optional<LongStream> $$8;
            HashMapPalette<T> $$2 = new HashMapPalette<T>(p_188065_, this.data.storage.getBits(), this.dummyPaletteResize);
            int $$3 = p_188066_.size();
            int[] $$4 = new int[$$3];
            this.data.storage.unpack($$4);
            PalettedContainer.swapPalette($$4, p_198178_ -> $$2.idFor(this.data.palette.valueFor(p_198178_)));
            int $$5 = p_188066_.calculateBitsForSerialization(p_188065_, $$2.getSize());
            if ($$5 != 0) {
                SimpleBitStorage $$6 = new SimpleBitStorage($$5, $$3, $$4);
                Optional<LongStream> $$7 = Optional.of(Arrays.stream($$6.getRaw()));
            } else {
                $$8 = Optional.empty();
            }
            PalettedContainerRO.PackedData<T> packedData = new PalettedContainerRO.PackedData<T>($$2.getEntries(), $$8);
            return packedData;
        }
        finally {
            this.release();
        }
    }

    private static <T> void swapPalette(int[] p_198190_, IntUnaryOperator p_198191_) {
        int $$2 = -1;
        int $$3 = -1;
        for (int $$4 = 0; $$4 < p_198190_.length; ++$$4) {
            int $$5 = p_198190_[$$4];
            if ($$5 != $$2) {
                $$2 = $$5;
                $$3 = p_198191_.applyAsInt($$5);
            }
            p_198190_[$$4] = $$3;
        }
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize();
    }

    @Override
    public boolean maybeHas(Predicate<T> p_63110_) {
        return this.data.palette.maybeHas(p_63110_);
    }

    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this.registry, this.strategy, this.data.copy());
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer<T>(this.registry, this.data.palette.valueFor(0), this.strategy);
    }

    @Override
    public void count(CountConsumer<T> p_63100_) {
        if (this.data.palette.getSize() == 1) {
            p_63100_.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
            return;
        }
        Int2IntOpenHashMap $$1 = new Int2IntOpenHashMap();
        this.data.storage.getAll((int p_238269_) -> $$1.addTo(p_238269_, 1));
        $$1.int2IntEntrySet().forEach(p_238271_ -> p_63100_.accept(this.data.palette.valueFor(p_238271_.getIntKey()), p_238271_.getIntValue()));
    }

    public static abstract class Strategy {
        public static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
        public static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
        public static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
        static final Palette.Factory GLOBAL_PALETTE_FACTORY = GlobalPalette::create;
        public static final Strategy SECTION_STATES = new Strategy(4){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> p_188157_, int p_188158_) {
                return switch (p_188158_) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, p_188158_);
                    case 1, 2, 3, 4 -> new Configuration(LINEAR_PALETTE_FACTORY, 4);
                    case 5, 6, 7, 8 -> new Configuration(HASHMAP_PALETTE_FACTORY, p_188158_);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(p_188157_.size()));
                };
            }
        };
        public static final Strategy SECTION_BIOMES = new Strategy(2){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> p_188162_, int p_188163_) {
                return switch (p_188163_) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, p_188163_);
                    case 1, 2, 3 -> new Configuration(LINEAR_PALETTE_FACTORY, p_188163_);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(p_188162_.size()));
                };
            }
        };
        private final int sizeBits;

        Strategy(int p_188143_) {
            this.sizeBits = p_188143_;
        }

        public int size() {
            return 1 << this.sizeBits * 3;
        }

        public int getIndex(int p_188146_, int p_188147_, int p_188148_) {
            return (p_188147_ << this.sizeBits | p_188148_) << this.sizeBits | p_188146_;
        }

        public abstract <A> Configuration<A> getConfiguration(IdMap<A> var1, int var2);

        <A> int calculateBitsForSerialization(IdMap<A> p_188152_, int p_188153_) {
            int $$2 = Mth.ceillog2(p_188153_);
            Configuration<A> $$3 = this.getConfiguration(p_188152_, $$2);
            return $$3.factory() == GLOBAL_PALETTE_FACTORY ? $$2 : $$3.bits();
        }
    }

    record Data<T>(Configuration<T> configuration, BitStorage storage, Palette<T> palette) {
        public void copyFrom(Palette<T> p_188112_, BitStorage p_188113_) {
            for (int $$2 = 0; $$2 < p_188113_.getSize(); ++$$2) {
                T $$3 = p_188112_.valueFor(p_188113_.get($$2));
                this.storage.set($$2, this.palette.idFor($$3));
            }
        }

        public int getSerializedSize() {
            return 1 + this.palette.getSerializedSize() + VarInt.getByteSize(this.storage.getRaw().length) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf p_188115_) {
            p_188115_.writeByte(this.storage.getBits());
            this.palette.write(p_188115_);
            p_188115_.writeLongArray(this.storage.getRaw());
        }

        public Data<T> copy() {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy());
        }
    }

    record Configuration<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IdMap<T> p_188092_, PaletteResize<T> p_188093_, int p_188094_) {
            BitStorage $$3 = this.bits == 0 ? new ZeroBitStorage(p_188094_) : new SimpleBitStorage(this.bits, p_188094_);
            Palette<T> $$4 = this.factory.create(this.bits, p_188092_, p_188093_, List.of());
            return new Data<T>(this, $$3, $$4);
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

