/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class Style {
    public static final Style EMPTY = new Style(null, null, null, null, null, null, null, null, null, null);
    public static final ResourceLocation DEFAULT_FONT = ResourceLocation.withDefaultNamespace("default");
    @Nullable
    final TextColor color;
    @Nullable
    final Boolean bold;
    @Nullable
    final Boolean italic;
    @Nullable
    final Boolean underlined;
    @Nullable
    final Boolean strikethrough;
    @Nullable
    final Boolean obfuscated;
    @Nullable
    final ClickEvent clickEvent;
    @Nullable
    final HoverEvent hoverEvent;
    @Nullable
    final String insertion;
    @Nullable
    final ResourceLocation font;

    private static Style create(Optional<TextColor> p_237258_, Optional<Boolean> p_237259_, Optional<Boolean> p_237260_, Optional<Boolean> p_237261_, Optional<Boolean> p_237262_, Optional<Boolean> p_237263_, Optional<ClickEvent> p_237264_, Optional<HoverEvent> p_237265_, Optional<String> p_304921_, Optional<ResourceLocation> p_304811_) {
        Style $$10 = new Style(p_237258_.orElse(null), p_237259_.orElse(null), p_237260_.orElse(null), p_237261_.orElse(null), p_237262_.orElse(null), p_237263_.orElse(null), p_237264_.orElse(null), p_237265_.orElse(null), p_304921_.orElse(null), p_304811_.orElse(null));
        if ($$10.equals(EMPTY)) {
            return EMPTY;
        }
        return $$10;
    }

    private Style(@Nullable TextColor p_131113_, @Nullable Boolean p_131114_, @Nullable Boolean p_131115_, @Nullable Boolean p_131116_, @Nullable Boolean p_131117_, @Nullable Boolean p_131118_, @Nullable ClickEvent p_131119_, @Nullable HoverEvent p_131120_, @Nullable String p_131121_, @Nullable ResourceLocation p_131122_) {
        this.color = p_131113_;
        this.bold = p_131114_;
        this.italic = p_131115_;
        this.underlined = p_131116_;
        this.strikethrough = p_131117_;
        this.obfuscated = p_131118_;
        this.clickEvent = p_131119_;
        this.hoverEvent = p_131120_;
        this.insertion = p_131121_;
        this.font = p_131122_;
    }

    @Nullable
    public TextColor getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold == Boolean.TRUE;
    }

    public boolean isItalic() {
        return this.italic == Boolean.TRUE;
    }

    public boolean isStrikethrough() {
        return this.strikethrough == Boolean.TRUE;
    }

    public boolean isUnderlined() {
        return this.underlined == Boolean.TRUE;
    }

    public boolean isObfuscated() {
        return this.obfuscated == Boolean.TRUE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    @Nullable
    public HoverEvent getHoverEvent() {
        return this.hoverEvent;
    }

    @Nullable
    public String getInsertion() {
        return this.insertion;
    }

    public ResourceLocation getFont() {
        return this.font != null ? this.font : DEFAULT_FONT;
    }

    private static <T> Style checkEmptyAfterChange(Style p_304840_, @Nullable T p_304483_, @Nullable T p_304384_) {
        if (p_304483_ != null && p_304384_ == null && p_304840_.equals(EMPTY)) {
            return EMPTY;
        }
        return p_304840_;
    }

    public Style withColor(@Nullable TextColor p_131149_) {
        if (Objects.equals(this.color, p_131149_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(p_131149_, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.color, p_131149_);
    }

    public Style withColor(@Nullable ChatFormatting p_131141_) {
        return this.withColor(p_131141_ != null ? TextColor.fromLegacyFormat(p_131141_) : null);
    }

    public Style withColor(int p_178521_) {
        return this.withColor(TextColor.fromRgb(p_178521_));
    }

    public Style withBold(@Nullable Boolean p_131137_) {
        if (Objects.equals(this.bold, p_131137_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, p_131137_, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.bold, p_131137_);
    }

    public Style withItalic(@Nullable Boolean p_131156_) {
        if (Objects.equals(this.italic, p_131156_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, p_131156_, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.italic, p_131156_);
    }

    public Style withUnderlined(@Nullable Boolean p_131163_) {
        if (Objects.equals(this.underlined, p_131163_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, p_131163_, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.underlined, p_131163_);
    }

    public Style withStrikethrough(@Nullable Boolean p_178523_) {
        if (Objects.equals(this.strikethrough, p_178523_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, p_178523_, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.strikethrough, p_178523_);
    }

    public Style withObfuscated(@Nullable Boolean p_178525_) {
        if (Objects.equals(this.obfuscated, p_178525_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, this.strikethrough, p_178525_, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.obfuscated, p_178525_);
    }

    public Style withClickEvent(@Nullable ClickEvent p_131143_) {
        if (Objects.equals(this.clickEvent, p_131143_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, p_131143_, this.hoverEvent, this.insertion, this.font), this.clickEvent, p_131143_);
    }

    public Style withHoverEvent(@Nullable HoverEvent p_131145_) {
        if (Objects.equals(this.hoverEvent, p_131145_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, p_131145_, this.insertion, this.font), this.hoverEvent, p_131145_);
    }

    public Style withInsertion(@Nullable String p_131139_) {
        if (Objects.equals(this.insertion, p_131139_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, p_131139_, this.font), this.insertion, p_131139_);
    }

    public Style withFont(@Nullable ResourceLocation p_131151_) {
        if (Objects.equals(this.font, p_131151_)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, p_131151_), this.font, p_131151_);
    }

    public Style applyFormat(ChatFormatting p_131158_) {
        TextColor $$1 = this.color;
        Boolean $$2 = this.bold;
        Boolean $$3 = this.italic;
        Boolean $$4 = this.strikethrough;
        Boolean $$5 = this.underlined;
        Boolean $$6 = this.obfuscated;
        switch (p_131158_) {
            case OBFUSCATED: {
                $$6 = true;
                break;
            }
            case BOLD: {
                $$2 = true;
                break;
            }
            case STRIKETHROUGH: {
                $$4 = true;
                break;
            }
            case UNDERLINE: {
                $$5 = true;
                break;
            }
            case ITALIC: {
                $$3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                $$1 = TextColor.fromLegacyFormat(p_131158_);
            }
        }
        return new Style($$1, $$2, $$3, $$5, $$4, $$6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyLegacyFormat(ChatFormatting p_131165_) {
        TextColor $$1 = this.color;
        Boolean $$2 = this.bold;
        Boolean $$3 = this.italic;
        Boolean $$4 = this.strikethrough;
        Boolean $$5 = this.underlined;
        Boolean $$6 = this.obfuscated;
        switch (p_131165_) {
            case OBFUSCATED: {
                $$6 = true;
                break;
            }
            case BOLD: {
                $$2 = true;
                break;
            }
            case STRIKETHROUGH: {
                $$4 = true;
                break;
            }
            case UNDERLINE: {
                $$5 = true;
                break;
            }
            case ITALIC: {
                $$3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                $$6 = false;
                $$2 = false;
                $$4 = false;
                $$5 = false;
                $$3 = false;
                $$1 = TextColor.fromLegacyFormat(p_131165_);
            }
        }
        return new Style($$1, $$2, $$3, $$5, $$4, $$6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyFormats(ChatFormatting ... p_131153_) {
        TextColor $$1 = this.color;
        Boolean $$2 = this.bold;
        Boolean $$3 = this.italic;
        Boolean $$4 = this.strikethrough;
        Boolean $$5 = this.underlined;
        Boolean $$6 = this.obfuscated;
        block8: for (ChatFormatting $$7 : p_131153_) {
            switch ($$7) {
                case OBFUSCATED: {
                    $$6 = true;
                    continue block8;
                }
                case BOLD: {
                    $$2 = true;
                    continue block8;
                }
                case STRIKETHROUGH: {
                    $$4 = true;
                    continue block8;
                }
                case UNDERLINE: {
                    $$5 = true;
                    continue block8;
                }
                case ITALIC: {
                    $$3 = true;
                    continue block8;
                }
                case RESET: {
                    return EMPTY;
                }
                default: {
                    $$1 = TextColor.fromLegacyFormat($$7);
                }
            }
        }
        return new Style($$1, $$2, $$3, $$5, $$4, $$6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyTo(Style p_131147_) {
        if (this == EMPTY) {
            return p_131147_;
        }
        if (p_131147_ == EMPTY) {
            return this;
        }
        return new Style(this.color != null ? this.color : p_131147_.color, this.bold != null ? this.bold : p_131147_.bold, this.italic != null ? this.italic : p_131147_.italic, this.underlined != null ? this.underlined : p_131147_.underlined, this.strikethrough != null ? this.strikethrough : p_131147_.strikethrough, this.obfuscated != null ? this.obfuscated : p_131147_.obfuscated, this.clickEvent != null ? this.clickEvent : p_131147_.clickEvent, this.hoverEvent != null ? this.hoverEvent : p_131147_.hoverEvent, this.insertion != null ? this.insertion : p_131147_.insertion, this.font != null ? this.font : p_131147_.font);
    }

    public String toString() {
        final StringBuilder $$0 = new StringBuilder("{");
        class Collector {
            private boolean isNotFirst;

            Collector() {
            }

            private void prependSeparator() {
                if (this.isNotFirst) {
                    $$0.append(',');
                }
                this.isNotFirst = true;
            }

            void addFlagString(String p_237290_, @Nullable Boolean p_237291_) {
                if (p_237291_ != null) {
                    this.prependSeparator();
                    if (!p_237291_.booleanValue()) {
                        $$0.append('!');
                    }
                    $$0.append(p_237290_);
                }
            }

            void addValueString(String p_237293_, @Nullable Object p_237294_) {
                if (p_237294_ != null) {
                    this.prependSeparator();
                    $$0.append(p_237293_);
                    $$0.append('=');
                    $$0.append(p_237294_);
                }
            }
        }
        Collector $$1 = new Collector();
        $$1.addValueString("color", this.color);
        $$1.addFlagString("bold", this.bold);
        $$1.addFlagString("italic", this.italic);
        $$1.addFlagString("underlined", this.underlined);
        $$1.addFlagString("strikethrough", this.strikethrough);
        $$1.addFlagString("obfuscated", this.obfuscated);
        $$1.addValueString("clickEvent", this.clickEvent);
        $$1.addValueString("hoverEvent", this.hoverEvent);
        $$1.addValueString("insertion", this.insertion);
        $$1.addValueString("font", this.font);
        $$0.append("}");
        return $$0.toString();
    }

    public boolean equals(Object p_131175_) {
        if (this == p_131175_) {
            return true;
        }
        if (p_131175_ instanceof Style) {
            Style $$1 = (Style)p_131175_;
            return this.bold == $$1.bold && Objects.equals(this.getColor(), $$1.getColor()) && this.italic == $$1.italic && this.obfuscated == $$1.obfuscated && this.strikethrough == $$1.strikethrough && this.underlined == $$1.underlined && Objects.equals(this.clickEvent, $$1.clickEvent) && Objects.equals(this.hoverEvent, $$1.hoverEvent) && Objects.equals(this.insertion, $$1.insertion) && Objects.equals(this.font, $$1.font);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public static class Serializer {
        public static final MapCodec<Style> MAP_CODEC = RecordCodecBuilder.mapCodec(p_304583_ -> p_304583_.group((App)TextColor.CODEC.optionalFieldOf("color").forGetter(p_304458_ -> Optional.ofNullable(p_304458_.color)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(p_304491_ -> Optional.ofNullable(p_304491_.bold)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(p_304980_ -> Optional.ofNullable(p_304980_.italic)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(p_304946_ -> Optional.ofNullable(p_304946_.underlined)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(p_304494_ -> Optional.ofNullable(p_304494_.strikethrough)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(p_304916_ -> Optional.ofNullable(p_304916_.obfuscated)), (App)ClickEvent.CODEC.optionalFieldOf("clickEvent").forGetter(p_304578_ -> Optional.ofNullable(p_304578_.clickEvent)), (App)HoverEvent.CODEC.optionalFieldOf("hoverEvent").forGetter(p_304424_ -> Optional.ofNullable(p_304424_.hoverEvent)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(p_304670_ -> Optional.ofNullable(p_304670_.insertion)), (App)ResourceLocation.CODEC.optionalFieldOf("font").forGetter(p_304448_ -> Optional.ofNullable(p_304448_.font))).apply((Applicative)p_304583_, Style::create));
        public static final Codec<Style> CODEC = MAP_CODEC.codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, Style> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    }
}

