/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.functions.FunctionBuilder;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public interface CommandFunction<T> {
    public ResourceLocation id();

    public InstantiatedFunction<T> instantiate(@Nullable CompoundTag var1, CommandDispatcher<T> var2) throws FunctionInstantiationException;

    private static boolean shouldConcatenateNextLine(CharSequence p_306338_) {
        int $$1 = p_306338_.length();
        return $$1 > 0 && p_306338_.charAt($$1 - 1) == '\\';
    }

    public static <T extends ExecutionCommandSource<T>> CommandFunction<T> fromLines(ResourceLocation p_306082_, CommandDispatcher<T> p_306046_, T p_305973_, List<String> p_306307_) {
        FunctionBuilder<T> $$4 = new FunctionBuilder<T>();
        for (int $$5 = 0; $$5 < p_306307_.size(); ++$$5) {
            String $$11;
            int $$6 = $$5 + 1;
            String $$7 = p_306307_.get($$5).trim();
            if (CommandFunction.shouldConcatenateNextLine($$7)) {
                StringBuilder $$8 = new StringBuilder($$7);
                do {
                    if (++$$5 == p_306307_.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    $$8.deleteCharAt($$8.length() - 1);
                    String $$9 = p_306307_.get($$5).trim();
                    $$8.append($$9);
                    CommandFunction.checkCommandLineLength($$8);
                } while (CommandFunction.shouldConcatenateNextLine($$8));
                String $$10 = $$8.toString();
            } else {
                $$11 = $$7;
            }
            CommandFunction.checkCommandLineLength($$11);
            StringReader $$12 = new StringReader($$11);
            if (!$$12.canRead() || $$12.peek() == '#') continue;
            if ($$12.peek() == '/') {
                $$12.skip();
                if ($$12.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + $$11 + "' on line " + $$6 + " (if you intended to make a comment, use '#' not '//')");
                }
                String $$13 = $$12.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + $$11 + "' on line " + $$6 + " (did you mean '" + $$13 + "'? Do not use a preceding forwards slash.)");
            }
            if ($$12.peek() == '$') {
                $$4.addMacro($$11.substring(1), $$6, p_305973_);
                continue;
            }
            try {
                $$4.addCommand(CommandFunction.parseCommand(p_306046_, p_305973_, $$12));
                continue;
            }
            catch (CommandSyntaxException $$14) {
                throw new IllegalArgumentException("Whilst parsing command on line " + $$6 + ": " + $$14.getMessage());
            }
        }
        return $$4.build(p_306082_);
    }

    public static void checkCommandLineLength(CharSequence p_326091_) {
        if (p_326091_.length() > 2000000) {
            CharSequence $$1 = p_326091_.subSequence(0, Math.min(512, 2000000));
            throw new IllegalStateException("Command too long: " + p_326091_.length() + " characters, contents: " + String.valueOf($$1) + "...");
        }
    }

    public static <T extends ExecutionCommandSource<T>> UnboundEntryAction<T> parseCommand(CommandDispatcher<T> p_306213_, T p_305785_, StringReader p_306140_) throws CommandSyntaxException {
        ParseResults $$3 = p_306213_.parse(p_306140_, p_305785_);
        Commands.validateParseResults($$3);
        Optional $$4 = ContextChain.tryFlatten((CommandContext)$$3.getContext().build(p_306140_.getString()));
        if ($$4.isEmpty()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext($$3.getReader());
        }
        return new BuildContexts.Unbound(p_306140_.getString(), (ContextChain)$$4.get());
    }
}

